/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.Artifact;
import com.microsoft.graph.models.security.Host;
import com.microsoft.graph.models.security.SslCertificateEntity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SslCertificate
extends Artifact
implements Parsable {
    public SslCertificate() {
        this.setOdataType("#microsoft.graph.security.sslCertificate");
    }

    @Nonnull
    public static SslCertificate createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SslCertificate();
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("fingerprint", n -> this.setFingerprint(n.getStringValue()));
        deserializerMap.put("firstSeenDateTime", n -> this.setFirstSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("issueDateTime", n -> this.setIssueDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("issuer", n -> this.setIssuer((SslCertificateEntity)n.getObjectValue(SslCertificateEntity::createFromDiscriminatorValue)));
        deserializerMap.put("lastSeenDateTime", n -> this.setLastSeenDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("relatedHosts", n -> this.setRelatedHosts(n.getCollectionOfObjectValues(Host::createFromDiscriminatorValue)));
        deserializerMap.put("serialNumber", n -> this.setSerialNumber(n.getStringValue()));
        deserializerMap.put("sha1", n -> this.setSha1(n.getStringValue()));
        deserializerMap.put("subject", n -> this.setSubject((SslCertificateEntity)n.getObjectValue(SslCertificateEntity::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getFingerprint() {
        return (String)this.backingStore.get("fingerprint");
    }

    @Nullable
    public OffsetDateTime getFirstSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("firstSeenDateTime");
    }

    @Nullable
    public OffsetDateTime getIssueDateTime() {
        return (OffsetDateTime)this.backingStore.get("issueDateTime");
    }

    @Nullable
    public SslCertificateEntity getIssuer() {
        return (SslCertificateEntity)this.backingStore.get("issuer");
    }

    @Nullable
    public OffsetDateTime getLastSeenDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastSeenDateTime");
    }

    @Nullable
    public List<Host> getRelatedHosts() {
        return (List)this.backingStore.get("relatedHosts");
    }

    @Nullable
    public String getSerialNumber() {
        return (String)this.backingStore.get("serialNumber");
    }

    @Nullable
    public String getSha1() {
        return (String)this.backingStore.get("sha1");
    }

    @Nullable
    public SslCertificateEntity getSubject() {
        return (SslCertificateEntity)this.backingStore.get("subject");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeStringValue("fingerprint", this.getFingerprint());
        writer.writeOffsetDateTimeValue("firstSeenDateTime", this.getFirstSeenDateTime());
        writer.writeOffsetDateTimeValue("issueDateTime", this.getIssueDateTime());
        writer.writeObjectValue("issuer", (Parsable)this.getIssuer(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastSeenDateTime", this.getLastSeenDateTime());
        writer.writeCollectionOfObjectValues("relatedHosts", this.getRelatedHosts());
        writer.writeStringValue("serialNumber", this.getSerialNumber());
        writer.writeStringValue("sha1", this.getSha1());
        writer.writeObjectValue("subject", (Parsable)this.getSubject(), new Parsable[0]);
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setFingerprint(@Nullable String value) {
        this.backingStore.set("fingerprint", (Object)value);
    }

    public void setFirstSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("firstSeenDateTime", (Object)value);
    }

    public void setIssueDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("issueDateTime", (Object)value);
    }

    public void setIssuer(@Nullable SslCertificateEntity value) {
        this.backingStore.set("issuer", (Object)value);
    }

    public void setLastSeenDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastSeenDateTime", (Object)value);
    }

    public void setRelatedHosts(@Nullable List<Host> value) {
        this.backingStore.set("relatedHosts", value);
    }

    public void setSerialNumber(@Nullable String value) {
        this.backingStore.set("serialNumber", (Object)value);
    }

    public void setSha1(@Nullable String value) {
        this.backingStore.set("sha1", (Object)value);
    }

    public void setSubject(@Nullable SslCertificateEntity value) {
        this.backingStore.set("subject", (Object)value);
    }
}

