/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AllowInvitesFrom;
import com.microsoft.graph.models.DefaultUserRolePermissions;
import com.microsoft.graph.models.PolicyBase;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class AuthorizationPolicy
extends PolicyBase
implements Parsable {
    public AuthorizationPolicy() {
        this.setOdataType("#microsoft.graph.authorizationPolicy");
    }

    @Nonnull
    public static AuthorizationPolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AuthorizationPolicy();
    }

    @Nullable
    public Boolean getAllowedToSignUpEmailBasedSubscriptions() {
        return (Boolean)this.backingStore.get("allowedToSignUpEmailBasedSubscriptions");
    }

    @Nullable
    public Boolean getAllowedToUseSSPR() {
        return (Boolean)this.backingStore.get("allowedToUseSSPR");
    }

    @Nullable
    public Boolean getAllowEmailVerifiedUsersToJoinOrganization() {
        return (Boolean)this.backingStore.get("allowEmailVerifiedUsersToJoinOrganization");
    }

    @Nullable
    public AllowInvitesFrom getAllowInvitesFrom() {
        return (AllowInvitesFrom)((Object)this.backingStore.get("allowInvitesFrom"));
    }

    @Nullable
    public Boolean getAllowUserConsentForRiskyApps() {
        return (Boolean)this.backingStore.get("allowUserConsentForRiskyApps");
    }

    @Nullable
    public Boolean getBlockMsolPowerShell() {
        return (Boolean)this.backingStore.get("blockMsolPowerShell");
    }

    @Nullable
    public DefaultUserRolePermissions getDefaultUserRolePermissions() {
        return (DefaultUserRolePermissions)this.backingStore.get("defaultUserRolePermissions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowedToSignUpEmailBasedSubscriptions", n -> this.setAllowedToSignUpEmailBasedSubscriptions(n.getBooleanValue()));
        deserializerMap.put("allowedToUseSSPR", n -> this.setAllowedToUseSSPR(n.getBooleanValue()));
        deserializerMap.put("allowEmailVerifiedUsersToJoinOrganization", n -> this.setAllowEmailVerifiedUsersToJoinOrganization(n.getBooleanValue()));
        deserializerMap.put("allowInvitesFrom", n -> this.setAllowInvitesFrom((AllowInvitesFrom)n.getEnumValue(AllowInvitesFrom::forValue)));
        deserializerMap.put("allowUserConsentForRiskyApps", n -> this.setAllowUserConsentForRiskyApps(n.getBooleanValue()));
        deserializerMap.put("blockMsolPowerShell", n -> this.setBlockMsolPowerShell(n.getBooleanValue()));
        deserializerMap.put("defaultUserRolePermissions", n -> this.setDefaultUserRolePermissions((DefaultUserRolePermissions)n.getObjectValue(DefaultUserRolePermissions::createFromDiscriminatorValue)));
        deserializerMap.put("guestUserRoleId", n -> this.setGuestUserRoleId(n.getUUIDValue()));
        return deserializerMap;
    }

    @Nullable
    public UUID getGuestUserRoleId() {
        return (UUID)this.backingStore.get("guestUserRoleId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeBooleanValue("allowedToSignUpEmailBasedSubscriptions", this.getAllowedToSignUpEmailBasedSubscriptions());
        writer.writeBooleanValue("allowedToUseSSPR", this.getAllowedToUseSSPR());
        writer.writeBooleanValue("allowEmailVerifiedUsersToJoinOrganization", this.getAllowEmailVerifiedUsersToJoinOrganization());
        writer.writeEnumValue("allowInvitesFrom", (Enum)this.getAllowInvitesFrom());
        writer.writeBooleanValue("allowUserConsentForRiskyApps", this.getAllowUserConsentForRiskyApps());
        writer.writeBooleanValue("blockMsolPowerShell", this.getBlockMsolPowerShell());
        writer.writeObjectValue("defaultUserRolePermissions", (Parsable)this.getDefaultUserRolePermissions(), new Parsable[0]);
        writer.writeUUIDValue("guestUserRoleId", this.getGuestUserRoleId());
    }

    public void setAllowedToSignUpEmailBasedSubscriptions(@Nullable Boolean value) {
        this.backingStore.set("allowedToSignUpEmailBasedSubscriptions", (Object)value);
    }

    public void setAllowedToUseSSPR(@Nullable Boolean value) {
        this.backingStore.set("allowedToUseSSPR", (Object)value);
    }

    public void setAllowEmailVerifiedUsersToJoinOrganization(@Nullable Boolean value) {
        this.backingStore.set("allowEmailVerifiedUsersToJoinOrganization", (Object)value);
    }

    public void setAllowInvitesFrom(@Nullable AllowInvitesFrom value) {
        this.backingStore.set("allowInvitesFrom", (Object)value);
    }

    public void setAllowUserConsentForRiskyApps(@Nullable Boolean value) {
        this.backingStore.set("allowUserConsentForRiskyApps", (Object)value);
    }

    public void setBlockMsolPowerShell(@Nullable Boolean value) {
        this.backingStore.set("blockMsolPowerShell", (Object)value);
    }

    public void setDefaultUserRolePermissions(@Nullable DefaultUserRolePermissions value) {
        this.backingStore.set("defaultUserRolePermissions", (Object)value);
    }

    public void setGuestUserRoleId(@Nullable UUID value) {
        this.backingStore.set("guestUserRoleId", (Object)value);
    }
}

