/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.IncludedUserRoles;
import com.microsoft.graph.models.IncludedUserTypes;
import com.microsoft.graph.models.UserRegistrationMethodCount;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserRegistrationMethodSummary
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UserRegistrationMethodSummary() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UserRegistrationMethodSummary createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserRegistrationMethodSummary();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("totalUserCount", n -> this.setTotalUserCount(n.getLongValue()));
        deserializerMap.put("userRegistrationMethodCounts", n -> this.setUserRegistrationMethodCounts(n.getCollectionOfObjectValues(UserRegistrationMethodCount::createFromDiscriminatorValue)));
        deserializerMap.put("userRoles", n -> this.setUserRoles((IncludedUserRoles)n.getEnumValue(IncludedUserRoles::forValue)));
        deserializerMap.put("userTypes", n -> this.setUserTypes((IncludedUserTypes)n.getEnumValue(IncludedUserTypes::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Long getTotalUserCount() {
        return (Long)this.backingStore.get("totalUserCount");
    }

    @Nullable
    public List<UserRegistrationMethodCount> getUserRegistrationMethodCounts() {
        return (List)this.backingStore.get("userRegistrationMethodCounts");
    }

    @Nullable
    public IncludedUserRoles getUserRoles() {
        return (IncludedUserRoles)((Object)this.backingStore.get("userRoles"));
    }

    @Nullable
    public IncludedUserTypes getUserTypes() {
        return (IncludedUserTypes)((Object)this.backingStore.get("userTypes"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeLongValue("totalUserCount", this.getTotalUserCount());
        writer.writeCollectionOfObjectValues("userRegistrationMethodCounts", this.getUserRegistrationMethodCounts());
        writer.writeEnumValue("userRoles", (Enum)this.getUserRoles());
        writer.writeEnumValue("userTypes", (Enum)this.getUserTypes());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setTotalUserCount(@Nullable Long value) {
        this.backingStore.set("totalUserCount", (Object)value);
    }

    public void setUserRegistrationMethodCounts(@Nullable List<UserRegistrationMethodCount> value) {
        this.backingStore.set("userRegistrationMethodCounts", value);
    }

    public void setUserRoles(@Nullable IncludedUserRoles value) {
        this.backingStore.set("userRoles", (Object)value);
    }

    public void setUserTypes(@Nullable IncludedUserTypes value) {
        this.backingStore.set("userTypes", (Object)value);
    }
}

