/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.search;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.search.Acronym;
import com.microsoft.graph.models.search.Bookmark;
import com.microsoft.graph.models.search.IdentitySet;
import com.microsoft.graph.models.search.Qna;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SearchAnswer
extends Entity
implements Parsable {
    @Nonnull
    public static SearchAnswer createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.search.acronym": {
                    return new Acronym();
                }
                case "#microsoft.graph.search.bookmark": {
                    return new Bookmark();
                }
                case "#microsoft.graph.search.qna": {
                    return new Qna();
                }
            }
        }
        return new SearchAnswer();
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("webUrl", n -> this.setWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public String getWebUrl() {
        return (String)this.backingStore.get("webUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeStringValue("webUrl", this.getWebUrl());
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setWebUrl(@Nullable String value) {
        this.backingStore.set("webUrl", (Object)value);
    }
}

