/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota;

import com.microsoft.kiota.serialization.ParseNodeFactory;
import com.microsoft.kiota.serialization.ParseNodeFactoryRegistry;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import com.microsoft.kiota.serialization.SerializationWriterFactoryRegistry;
import com.microsoft.kiota.store.BackingStoreParseNodeFactory;
import com.microsoft.kiota.store.BackingStoreSerializationWriterProxyFactory;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Supplier;

public class ApiClientBuilder {
    private ApiClientBuilder() {
    }

    public static void registerDefaultSerializer(@Nonnull Supplier<SerializationWriterFactory> factorySupplier) {
        Objects.requireNonNull(factorySupplier);
        SerializationWriterFactory factory = factorySupplier.get();
        SerializationWriterFactoryRegistry.defaultInstance.contentTypeAssociatedFactories.put(factory.getValidContentType(), factory);
    }

    public static void registerDefaultDeserializer(@Nonnull Supplier<ParseNodeFactory> factorySupplier) {
        Objects.requireNonNull(factorySupplier);
        ParseNodeFactory factory = factorySupplier.get();
        ParseNodeFactoryRegistry.defaultInstance.contentTypeAssociatedFactories.put(factory.getValidContentType(), factory);
    }

    @Nonnull
    public static SerializationWriterFactory enableBackingStoreForSerializationWriterFactory(@Nonnull SerializationWriterFactory original) {
        SerializationWriterFactory result = Objects.requireNonNull(original);
        if (original instanceof SerializationWriterFactoryRegistry) {
            ApiClientBuilder.enableBackingStoreForSerializationWriterRegistry((SerializationWriterFactoryRegistry)original);
        } else {
            result = new BackingStoreSerializationWriterProxyFactory(original);
        }
        ApiClientBuilder.enableBackingStoreForSerializationWriterRegistry(SerializationWriterFactoryRegistry.defaultInstance);
        return result;
    }

    @Nonnull
    public static ParseNodeFactory enableBackingStoreForParseNodeFactory(@Nonnull ParseNodeFactory original) {
        ParseNodeFactory result = Objects.requireNonNull(original);
        if (original instanceof ParseNodeFactoryRegistry) {
            ApiClientBuilder.enableBackingStoreForParseNodeRegistry((ParseNodeFactoryRegistry)original);
        } else {
            result = new BackingStoreParseNodeFactory(original);
        }
        ApiClientBuilder.enableBackingStoreForParseNodeRegistry(ParseNodeFactoryRegistry.defaultInstance);
        return result;
    }

    private static void enableBackingStoreForParseNodeRegistry(@Nonnull ParseNodeFactoryRegistry registry) {
        Objects.requireNonNull(registry);
        for (ParseNodeFactory factory : registry.contentTypeAssociatedFactories.values()) {
            if (factory instanceof BackingStoreParseNodeFactory || factory instanceof ParseNodeFactoryRegistry) continue;
            registry.contentTypeAssociatedFactories.put(factory.getValidContentType(), new BackingStoreParseNodeFactory(factory));
        }
    }

    private static void enableBackingStoreForSerializationWriterRegistry(@Nonnull SerializationWriterFactoryRegistry registry) {
        Objects.requireNonNull(registry);
        for (SerializationWriterFactory factory : registry.contentTypeAssociatedFactories.values()) {
            if (factory instanceof BackingStoreSerializationWriterProxyFactory || factory instanceof SerializationWriterFactoryRegistry) continue;
            registry.contentTypeAssociatedFactories.put(factory.getValidContentType(), new BackingStoreSerializationWriterProxyFactory(factory));
        }
    }
}

