/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.http.TelemetrySemanticConventions;
import com.microsoft.kiota.http.middleware.ObservabilityHelper;
import com.microsoft.kiota.http.middleware.options.IShouldRetry;
import com.microsoft.kiota.http.middleware.options.RetryHandlerOption;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RetryHandler
implements Interceptor {
    @Nonnull
    private RetryHandlerOption mRetryOption;
    private static final String RETRY_ATTEMPT_HEADER = "Retry-Attempt";
    private static final String RETRY_AFTER = "Retry-After";
    public static final int MSClientErrorCodeTooManyRequests = 429;
    public static final int MSClientErrorCodeServiceUnavailable = 503;
    public static final int MSClientErrorCodeGatewayTimeout = 504;
    private static final long DELAY_MILLISECONDS = 1000L;

    public RetryHandler(@Nullable RetryHandlerOption retryOption) {
        this.mRetryOption = retryOption == null ? new RetryHandlerOption() : retryOption;
    }

    public RetryHandler() {
        this(null);
    }

    boolean retryRequest(@Nonnull Response response, int executionCount, @Nonnull Request request, @Nonnull RetryHandlerOption retryOption, @Nonnull Span span) {
        IShouldRetry shouldRetryCallback = null;
        if (retryOption != null) {
            shouldRetryCallback = retryOption.shouldRetry();
        }
        boolean shouldRetry = false;
        int statusCode = response.code();
        boolean bl = shouldRetry = shouldRetryCallback != null && executionCount <= retryOption.maxRetries() && this.checkStatus(statusCode) && this.isBuffered(request) && shouldRetryCallback.shouldRetry(retryOption.delay(), executionCount, request, response);
        if (shouldRetry) {
            long retryInterval = this.getRetryAfter(response, retryOption.delay(), executionCount);
            span.setAttribute(TelemetrySemanticConventions.HTTP_REQUEST_RESEND_DELAY, Math.round((float)retryInterval / 1000.0f));
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return shouldRetry;
    }

    long getRetryAfter(Response response, long delay, int executionCount) {
        String retryAfterHeader = response.header(RETRY_AFTER);
        double retryDelay = -1.0;
        if (retryAfterHeader != null) {
            retryDelay = this.tryParseTimeHeader(retryAfterHeader);
            if (retryDelay == -1.0) {
                retryDelay = this.tryParseDateHeader(retryAfterHeader);
            }
        } else if (retryDelay == -1.0) {
            retryDelay = this.exponentialBackOffDelay(delay, executionCount);
        }
        return (long)Math.min(retryDelay, 180000.0);
    }

    double tryParseTimeHeader(String retryAfterHeader) {
        String[] values;
        for (String value : values = retryAfterHeader.split(",")) {
            try {
                double parsedValue = Double.parseDouble(value.trim());
                if (!(parsedValue > 0.0)) continue;
                return parsedValue * 1000.0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1.0;
    }

    double tryParseDateHeader(String retryAfterHeader) {
        double retryDelay = -1.0;
        try {
            DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;
            Instant headerTime = Instant.from(formatter.parse(retryAfterHeader));
            Instant now = Instant.now();
            if (headerTime.isAfter(now)) {
                retryDelay = ChronoUnit.MILLIS.between(now, headerTime);
            }
        }
        catch (DateTimeParseException e) {
            return retryDelay;
        }
        return retryDelay;
    }

    private double exponentialBackOffDelay(double delay, int executionCount) {
        double retryDelay = 3000.0;
        retryDelay = (Math.pow(2.0, executionCount) - 1.0) * 0.5;
        retryDelay = (executionCount < 2 ? delay : retryDelay + delay) + Math.random();
        return retryDelay *= 1000.0;
    }

    boolean checkStatus(int statusCode) {
        return statusCode == 429 || statusCode == 503 || statusCode == 504;
    }

    boolean isBuffered(Request request) {
        String methodName = request.method();
        boolean isHTTPMethodPutPatchOrPost = methodName.equalsIgnoreCase("POST") || methodName.equalsIgnoreCase("PUT") || methodName.equalsIgnoreCase("PATCH");
        RequestBody requestBody = request.body();
        if (isHTTPMethodPutPatchOrPost && requestBody != null) {
            try {
                return requestBody.contentLength() != -1L;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public RetryHandlerOption getRetryOptions() {
        return this.mRetryOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Objects.requireNonNull(chain, "parameter chain cannot be null");
        Request request = chain.request();
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Span span = ObservabilityHelper.getSpanForRequest(request, "RetryHandler_Intercept");
        Scope scope = null;
        if (span != null) {
            scope = span.makeCurrent();
            span.setAttribute("com.microsoft.kiota.handler.retry.enable", true);
        }
        try {
            Response response;
            if (span != null) {
                request = request.newBuilder().tag(Span.class, (Object)span).build();
            }
            if ((response = chain.proceed(request)) == null) {
                throw new RuntimeException("unable to get a response from the chain");
            }
            RetryHandlerOption retryOption = (RetryHandlerOption)request.tag(RetryHandlerOption.class);
            if (retryOption == null) {
                retryOption = this.mRetryOption;
            }
            int executionCount = 1;
            while (this.retryRequest(response, executionCount, request, retryOption, span)) {
                Request.Builder builder = request.newBuilder().addHeader(RETRY_ATTEMPT_HEADER, String.valueOf(executionCount));
                if (span != null) {
                    builder.tag(Span.class, (Object)span);
                }
                if ((request = builder.build()) == null) {
                    throw new IllegalArgumentException("request cannot be null");
                }
                ++executionCount;
                ResponseBody body = response.body();
                if (body != null) {
                    body.close();
                }
                response.close();
                Span retrySpan = ObservabilityHelper.getSpanForRequest(request, "RetryHandler_Intercept - attempt " + executionCount, span);
                retrySpan.setAttribute(TelemetrySemanticConventions.HTTP_REQUEST_RESEND_COUNT, executionCount);
                retrySpan.setAttribute(TelemetrySemanticConventions.HTTP_RESPONSE_STATUS_CODE, response.code());
                retrySpan.end();
                response = chain.proceed(request);
                if (response != null) continue;
                throw new RuntimeException("unable to get a response from the chain");
            }
            Response response2 = response;
            return response2;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.end();
            }
        }
    }
}

