"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.source = void 0;
const source = exports.source = "\nvar __commonJS = obj => {\n  let required = false;\n  let result;\n  return function __require() {\n    if (!required) {\n      required = true;\n      let fn;\n      for (const name in obj) { fn = obj[name]; break; }\n      const module = { exports: {} };\n      fn(module.exports, module);\n      result = module.exports;\n    }\n    return result;\n  }\n};\nvar __export = (target, all) => {for (var name in all) target[name] = all[name];};\nvar __toESM = mod => ({ ...mod, 'default': mod });\nvar __toCommonJS = mod => ({ ...mod, __esModule: true });\n\n\n// packages/playwright-core/src/server/injected/recorder/recorder.ts\nvar recorder_exports = {};\n__export(recorder_exports, {\n  PollingRecorder: () => PollingRecorder,\n  Recorder: () => Recorder,\n  default: () => recorder_default\n});\nmodule.exports = __toCommonJS(recorder_exports);\nvar NoneTool = class {\n  cursor() {\n    return \"default\";\n  }\n};\nvar InspectTool = class {\n  constructor(recorder, assertVisibility) {\n    this._hoveredModel = null;\n    this._hoveredElement = null;\n    this._hoveredSelectors = null;\n    this._recorder = recorder;\n    this._assertVisibility = assertVisibility;\n  }\n  cursor() {\n    return \"pointer\";\n  }\n  cleanup() {\n    this._hoveredModel = null;\n    this._hoveredElement = null;\n    this._hoveredSelectors = null;\n  }\n  onClick(event) {\n    var _a;\n    consumeEvent(event);\n    if (event.button !== 0)\n      return;\n    if ((_a = this._hoveredModel) == null ? void 0 : _a.selector)\n      this._commit(this._hoveredModel.selector);\n  }\n  onContextMenu(event) {\n    if (this._hoveredModel && !this._hoveredModel.tooltipListItemSelected && this._hoveredSelectors && this._hoveredSelectors.length > 1) {\n      consumeEvent(event);\n      const selectors = this._hoveredSelectors;\n      this._hoveredModel.tooltipFooter = void 0;\n      this._hoveredModel.tooltipList = selectors.map((selector) => this._recorder.injectedScript.utils.asLocator(this._recorder.state.language, selector));\n      this._hoveredModel.tooltipListItemSelected = (index) => {\n        if (index === void 0)\n          this._reset(true);\n        else\n          this._commit(selectors[index]);\n      };\n      this._recorder.updateHighlight(this._hoveredModel, true);\n    }\n  }\n  onPointerDown(event) {\n    consumeEvent(event);\n  }\n  onPointerUp(event) {\n    consumeEvent(event);\n  }\n  onMouseDown(event) {\n    consumeEvent(event);\n  }\n  onMouseUp(event) {\n    consumeEvent(event);\n  }\n  onMouseMove(event) {\n    var _a;\n    consumeEvent(event);\n    let target = this._recorder.deepEventTarget(event);\n    if (!target.isConnected)\n      target = null;\n    if (this._hoveredElement === target)\n      return;\n    this._hoveredElement = target;\n    let model = null;\n    let selectors = [];\n    if (this._hoveredElement) {\n      const generated = this._recorder.injectedScript.generateSelector(this._hoveredElement, { testIdAttributeName: this._recorder.state.testIdAttributeName, multiple: false });\n      selectors = generated.selectors;\n      model = {\n        selector: generated.selector,\n        elements: generated.elements,\n        tooltipText: this._recorder.injectedScript.utils.asLocator(this._recorder.state.language, generated.selector),\n        tooltipFooter: selectors.length > 1 ? `Click to select, right-click for more options` : void 0,\n        color: this._assertVisibility ? \"#8acae480\" : void 0\n      };\n    }\n    if (((_a = this._hoveredModel) == null ? void 0 : _a.selector) === (model == null ? void 0 : model.selector))\n      return;\n    this._hoveredModel = model;\n    this._hoveredSelectors = selectors;\n    this._recorder.updateHighlight(model, true);\n  }\n  onMouseEnter(event) {\n    consumeEvent(event);\n  }\n  onMouseLeave(event) {\n    consumeEvent(event);\n    const window = this._recorder.injectedScript.window;\n    if (window.top !== window && this._recorder.deepEventTarget(event).nodeType === Node.DOCUMENT_NODE)\n      this._reset(true);\n  }\n  onKeyDown(event) {\n    var _a, _b, _c;\n    consumeEvent(event);\n    if (event.key === \"Escape\") {\n      if ((_a = this._hoveredModel) == null ? void 0 : _a.tooltipListItemSelected)\n        this._reset(true);\n      else if (this._assertVisibility)\n        (_c = (_b = this._recorder.delegate).setMode) == null ? void 0 : _c.call(_b, \"recording\");\n    }\n  }\n  onKeyUp(event) {\n    consumeEvent(event);\n  }\n  onScroll(event) {\n    this._reset(false);\n  }\n  _commit(selector) {\n    var _a, _b, _c, _d, _e, _f, _g;\n    if (this._assertVisibility) {\n      (_b = (_a = this._recorder.delegate).recordAction) == null ? void 0 : _b.call(_a, {\n        name: \"assertVisible\",\n        selector,\n        signals: []\n      });\n      (_d = (_c = this._recorder.delegate).setMode) == null ? void 0 : _d.call(_c, \"recording\");\n      (_e = this._recorder.overlay) == null ? void 0 : _e.flashToolSucceeded(\"assertingVisibility\");\n    } else {\n      (_g = (_f = this._recorder.delegate).setSelector) == null ? void 0 : _g.call(_f, selector);\n    }\n  }\n  _reset(userGesture) {\n    this._hoveredElement = null;\n    this._hoveredModel = null;\n    this._hoveredSelectors = null;\n    this._recorder.updateHighlight(null, userGesture);\n  }\n};\nvar RecordActionTool = class {\n  constructor(recorder) {\n    this._performingAction = false;\n    this._hoveredModel = null;\n    this._hoveredElement = null;\n    this._activeModel = null;\n    this._expectProgrammaticKeyUp = false;\n    this._recorder = recorder;\n  }\n  cursor() {\n    return \"pointer\";\n  }\n  cleanup() {\n    this._hoveredModel = null;\n    this._hoveredElement = null;\n    this._activeModel = null;\n    this._expectProgrammaticKeyUp = false;\n  }\n  onClick(event) {\n    if (isRangeInput(this._hoveredElement))\n      return;\n    if (this._shouldIgnoreMouseEvent(event))\n      return;\n    if (this._actionInProgress(event))\n      return;\n    if (this._consumedDueToNoModel(event, this._hoveredModel))\n      return;\n    const checkbox = asCheckbox(this._recorder.deepEventTarget(event));\n    if (checkbox) {\n      this._performAction({\n        name: checkbox.checked ? \"check\" : \"uncheck\",\n        selector: this._hoveredModel.selector,\n        signals: []\n      });\n      return;\n    }\n    this._performAction({\n      name: \"click\",\n      selector: this._hoveredModel.selector,\n      position: positionForEvent(event),\n      signals: [],\n      button: buttonForEvent(event),\n      modifiers: modifiersForEvent(event),\n      clickCount: event.detail\n    });\n  }\n  onPointerDown(event) {\n    if (this._shouldIgnoreMouseEvent(event))\n      return;\n    if (!this._performingAction)\n      consumeEvent(event);\n  }\n  onPointerUp(event) {\n    if (this._shouldIgnoreMouseEvent(event))\n      return;\n    if (!this._performingAction)\n      consumeEvent(event);\n  }\n  onMouseDown(event) {\n    if (this._shouldIgnoreMouseEvent(event))\n      return;\n    if (!this._performingAction)\n      consumeEvent(event);\n    this._activeModel = this._hoveredModel;\n  }\n  onMouseUp(event) {\n    if (this._shouldIgnoreMouseEvent(event))\n      return;\n    if (!this._performingAction)\n      consumeEvent(event);\n  }\n  onMouseMove(event) {\n    const target = this._recorder.deepEventTarget(event);\n    if (this._hoveredElement === target)\n      return;\n    this._hoveredElement = target;\n    this._updateModelForHoveredElement();\n  }\n  onMouseLeave(event) {\n    const window = this._recorder.injectedScript.window;\n    if (window.top !== window && this._recorder.deepEventTarget(event).nodeType === Node.DOCUMENT_NODE) {\n      this._hoveredElement = null;\n      this._updateModelForHoveredElement();\n    }\n  }\n  onFocus(event) {\n    this._onFocus(true);\n  }\n  onInput(event) {\n    var _a, _b, _c, _d, _e, _f;\n    const target = this._recorder.deepEventTarget(event);\n    if (target.nodeName === \"INPUT\" && target.type.toLowerCase() === \"file\") {\n      (_b = (_a = this._recorder.delegate).recordAction) == null ? void 0 : _b.call(_a, {\n        name: \"setInputFiles\",\n        selector: this._activeModel.selector,\n        signals: [],\n        files: [...target.files || []].map((file) => file.name)\n      });\n      return;\n    }\n    if (isRangeInput(target)) {\n      (_d = (_c = this._recorder.delegate).recordAction) == null ? void 0 : _d.call(_c, {\n        name: \"fill\",\n        // must use hoveredModel instead of activeModel for it to work in webkit\n        selector: this._hoveredModel.selector,\n        signals: [],\n        text: target.value\n      });\n      return;\n    }\n    if ([\"INPUT\", \"TEXTAREA\"].includes(target.nodeName) || target.isContentEditable) {\n      if (target.nodeName === \"INPUT\" && [\"checkbox\", \"radio\"].includes(target.type.toLowerCase())) {\n        return;\n      }\n      if (this._consumedDueWrongTarget(event))\n        return;\n      (_f = (_e = this._recorder.delegate).recordAction) == null ? void 0 : _f.call(_e, {\n        name: \"fill\",\n        selector: this._activeModel.selector,\n        signals: [],\n        text: target.isContentEditable ? target.innerText : target.value\n      });\n    }\n    if (target.nodeName === \"SELECT\") {\n      const selectElement = target;\n      if (this._actionInProgress(event))\n        return;\n      this._performAction({\n        name: \"select\",\n        selector: this._hoveredModel.selector,\n        options: [...selectElement.selectedOptions].map((option) => option.value),\n        signals: []\n      });\n    }\n  }\n  onKeyDown(event) {\n    if (!this._shouldGenerateKeyPressFor(event))\n      return;\n    if (this._actionInProgress(event)) {\n      this._expectProgrammaticKeyUp = true;\n      return;\n    }\n    if (this._consumedDueWrongTarget(event))\n      return;\n    if (event.key === \" \") {\n      const checkbox = asCheckbox(this._recorder.deepEventTarget(event));\n      if (checkbox) {\n        this._performAction({\n          name: checkbox.checked ? \"uncheck\" : \"check\",\n          selector: this._activeModel.selector,\n          signals: []\n        });\n        return;\n      }\n    }\n    this._performAction({\n      name: \"press\",\n      selector: this._activeModel.selector,\n      signals: [],\n      key: event.key,\n      modifiers: modifiersForEvent(event)\n    });\n  }\n  onKeyUp(event) {\n    if (!this._shouldGenerateKeyPressFor(event))\n      return;\n    if (!this._expectProgrammaticKeyUp) {\n      consumeEvent(event);\n      return;\n    }\n    this._expectProgrammaticKeyUp = false;\n  }\n  onScroll(event) {\n    this._hoveredModel = null;\n    this._hoveredElement = null;\n    this._recorder.updateHighlight(null, false);\n  }\n  _onFocus(userGesture) {\n    const activeElement = deepActiveElement(this._recorder.document);\n    if (userGesture && activeElement === this._recorder.document.body)\n      return;\n    const result = activeElement ? this._recorder.injectedScript.generateSelector(activeElement, { testIdAttributeName: this._recorder.state.testIdAttributeName }) : null;\n    this._activeModel = result && result.selector ? result : null;\n    if (userGesture)\n      this._hoveredElement = activeElement;\n    this._updateModelForHoveredElement();\n  }\n  _shouldIgnoreMouseEvent(event) {\n    const target = this._recorder.deepEventTarget(event);\n    const nodeName = target.nodeName;\n    if (nodeName === \"SELECT\" || nodeName === \"OPTION\")\n      return true;\n    if (nodeName === \"INPUT\" && [\"date\", \"range\"].includes(target.type))\n      return true;\n    return false;\n  }\n  _actionInProgress(event) {\n    if (this._performingAction)\n      return true;\n    consumeEvent(event);\n    return false;\n  }\n  _consumedDueToNoModel(event, model) {\n    if (model)\n      return false;\n    consumeEvent(event);\n    return true;\n  }\n  _consumedDueWrongTarget(event) {\n    if (this._activeModel && this._activeModel.elements[0] === this._recorder.deepEventTarget(event))\n      return false;\n    consumeEvent(event);\n    return true;\n  }\n  async _performAction(action) {\n    var _a, _b;\n    this._hoveredElement = null;\n    this._hoveredModel = null;\n    this._activeModel = null;\n    this._recorder.updateHighlight(null, false);\n    this._performingAction = true;\n    await ((_b = (_a = this._recorder.delegate).performAction) == null ? void 0 : _b.call(_a, action).catch(() => {\n    }));\n    this._performingAction = false;\n    this._onFocus(false);\n    if (this._recorder.injectedScript.isUnderTest) {\n      console.error(\"Action performed for test: \" + JSON.stringify({\n        // eslint-disable-line no-console\n        hovered: this._hoveredModel ? this._hoveredModel.selector : null,\n        active: this._activeModel ? this._activeModel.selector : null\n      }));\n    }\n  }\n  _shouldGenerateKeyPressFor(event) {\n    if (event.key === \"Enter\" && (this._recorder.deepEventTarget(event).nodeName === \"TEXTAREA\" || this._recorder.deepEventTarget(event).isContentEditable))\n      return false;\n    if ([\"Backspace\", \"Delete\", \"AltGraph\"].includes(event.key))\n      return false;\n    if (event.key === \"@\" && event.code === \"KeyL\")\n      return false;\n    if (navigator.platform.includes(\"Mac\")) {\n      if (event.key === \"v\" && event.metaKey)\n        return false;\n    } else {\n      if (event.key === \"v\" && event.ctrlKey)\n        return false;\n      if (event.key === \"Insert\" && event.shiftKey)\n        return false;\n    }\n    if ([\"Shift\", \"Control\", \"Meta\", \"Alt\", \"Process\"].includes(event.key))\n      return false;\n    const hasModifier = event.ctrlKey || event.altKey || event.metaKey;\n    if (event.key.length === 1 && !hasModifier)\n      return !!asCheckbox(this._recorder.deepEventTarget(event));\n    return true;\n  }\n  _updateModelForHoveredElement() {\n    if (!this._hoveredElement || !this._hoveredElement.isConnected) {\n      this._hoveredModel = null;\n      this._hoveredElement = null;\n      this._recorder.updateHighlight(null, true);\n      return;\n    }\n    const { selector, elements } = this._recorder.injectedScript.generateSelector(this._hoveredElement, { testIdAttributeName: this._recorder.state.testIdAttributeName });\n    if (this._hoveredModel && this._hoveredModel.selector === selector)\n      return;\n    this._hoveredModel = selector ? { selector, elements, color: \"#dc6f6f7f\" } : null;\n    this._recorder.updateHighlight(this._hoveredModel, true);\n  }\n};\nvar TextAssertionTool = class {\n  constructor(recorder, kind) {\n    this._hoverHighlight = null;\n    this._action = null;\n    this._dialogElement = null;\n    this._textCache = /* @__PURE__ */ new Map();\n    this._recorder = recorder;\n    this._kind = kind;\n    this._acceptButton = this._recorder.document.createElement(\"x-pw-tool-item\");\n    this._acceptButton.title = \"Accept\";\n    this._acceptButton.classList.add(\"accept\");\n    this._acceptButton.appendChild(this._recorder.document.createElement(\"x-div\"));\n    this._acceptButton.addEventListener(\"click\", () => this._commit());\n    this._cancelButton = this._recorder.document.createElement(\"x-pw-tool-item\");\n    this._cancelButton.title = \"Close\";\n    this._cancelButton.classList.add(\"cancel\");\n    this._cancelButton.appendChild(this._recorder.document.createElement(\"x-div\"));\n    this._cancelButton.addEventListener(\"click\", () => this._closeDialog());\n  }\n  cursor() {\n    return \"pointer\";\n  }\n  cleanup() {\n    this._closeDialog();\n    this._hoverHighlight = null;\n  }\n  onClick(event) {\n    consumeEvent(event);\n    if (this._kind === \"value\") {\n      this._commitAssertValue();\n    } else {\n      if (!this._dialogElement)\n        this._showDialog();\n    }\n  }\n  onMouseDown(event) {\n    const target = this._recorder.deepEventTarget(event);\n    if (this._elementHasValue(target))\n      event.preventDefault();\n  }\n  onPointerUp(event) {\n    var _a;\n    const target = (_a = this._hoverHighlight) == null ? void 0 : _a.elements[0];\n    if (this._kind === \"value\" && target && target.nodeName === \"INPUT\" && target.disabled) {\n      this._commitAssertValue();\n    }\n  }\n  onMouseMove(event) {\n    var _a;\n    if (this._dialogElement)\n      return;\n    const target = this._recorder.deepEventTarget(event);\n    if (((_a = this._hoverHighlight) == null ? void 0 : _a.elements[0]) === target)\n      return;\n    if (this._kind === \"text\")\n      this._hoverHighlight = this._recorder.injectedScript.utils.elementText(this._textCache, target).full ? { elements: [target], selector: \"\" } : null;\n    else\n      this._hoverHighlight = this._elementHasValue(target) ? this._recorder.injectedScript.generateSelector(target, { testIdAttributeName: this._recorder.state.testIdAttributeName }) : null;\n    if (this._hoverHighlight)\n      this._hoverHighlight.color = \"#8acae480\";\n    this._recorder.updateHighlight(this._hoverHighlight, true);\n  }\n  onKeyDown(event) {\n    var _a, _b;\n    if (event.key === \"Escape\")\n      (_b = (_a = this._recorder.delegate).setMode) == null ? void 0 : _b.call(_a, \"recording\");\n    consumeEvent(event);\n  }\n  onScroll(event) {\n    this._recorder.updateHighlight(this._hoverHighlight, false);\n  }\n  _elementHasValue(element) {\n    return element.nodeName === \"TEXTAREA\" || element.nodeName === \"SELECT\" || element.nodeName === \"INPUT\" && ![\"button\", \"image\", \"reset\", \"submit\"].includes(element.type);\n  }\n  _generateAction() {\n    var _a;\n    this._textCache.clear();\n    const target = (_a = this._hoverHighlight) == null ? void 0 : _a.elements[0];\n    if (!target)\n      return null;\n    if (this._kind === \"value\") {\n      if (!this._elementHasValue(target))\n        return null;\n      const { selector } = this._recorder.injectedScript.generateSelector(target, { testIdAttributeName: this._recorder.state.testIdAttributeName });\n      if (target.nodeName === \"INPUT\" && [\"checkbox\", \"radio\"].includes(target.type.toLowerCase())) {\n        return {\n          name: \"assertChecked\",\n          selector,\n          signals: [],\n          // Interestingly, inputElement.checked is reversed inside this event handler.\n          checked: !target.checked\n        };\n      } else {\n        return {\n          name: \"assertValue\",\n          selector,\n          signals: [],\n          value: target.value\n        };\n      }\n    } else {\n      this._hoverHighlight = this._recorder.injectedScript.generateSelector(target, { testIdAttributeName: this._recorder.state.testIdAttributeName, forTextExpect: true });\n      this._hoverHighlight.color = \"#8acae480\";\n      this._recorder.updateHighlight(this._hoverHighlight, true);\n      return {\n        name: \"assertText\",\n        selector: this._hoverHighlight.selector,\n        signals: [],\n        text: this._recorder.injectedScript.utils.elementText(this._textCache, target).normalized,\n        substring: true\n      };\n    }\n  }\n  _renderValue(action) {\n    if ((action == null ? void 0 : action.name) === \"assertText\")\n      return this._recorder.injectedScript.utils.normalizeWhiteSpace(action.text);\n    if ((action == null ? void 0 : action.name) === \"assertChecked\")\n      return String(action.checked);\n    if ((action == null ? void 0 : action.name) === \"assertValue\")\n      return action.value;\n    return \"\";\n  }\n  _commit() {\n    var _a, _b, _c, _d;\n    if (!this._action || !this._dialogElement)\n      return;\n    this._closeDialog();\n    (_b = (_a = this._recorder.delegate).recordAction) == null ? void 0 : _b.call(_a, this._action);\n    (_d = (_c = this._recorder.delegate).setMode) == null ? void 0 : _d.call(_c, \"recording\");\n  }\n  _showDialog() {\n    var _a;\n    if (!((_a = this._hoverHighlight) == null ? void 0 : _a.elements[0]))\n      return;\n    this._action = this._generateAction();\n    if (!this._action || this._action.name !== \"assertText\")\n      return;\n    this._dialogElement = this._recorder.document.createElement(\"x-pw-dialog\");\n    this._keyboardListener = (event) => {\n      if (event.key === \"Escape\") {\n        this._closeDialog();\n        return;\n      }\n      if (event.key === \"Enter\" && (event.ctrlKey || event.metaKey)) {\n        if (this._dialogElement)\n          this._commit();\n        return;\n      }\n    };\n    this._recorder.document.addEventListener(\"keydown\", this._keyboardListener, true);\n    const toolbarElement = this._recorder.document.createElement(\"x-pw-tools-list\");\n    const labelElement = this._recorder.document.createElement(\"label\");\n    labelElement.textContent = \"Assert that element contains text\";\n    toolbarElement.appendChild(labelElement);\n    toolbarElement.appendChild(this._recorder.document.createElement(\"x-spacer\"));\n    toolbarElement.appendChild(this._acceptButton);\n    toolbarElement.appendChild(this._cancelButton);\n    this._dialogElement.appendChild(toolbarElement);\n    const bodyElement = this._recorder.document.createElement(\"x-pw-dialog-body\");\n    const action = this._action;\n    const textElement = this._recorder.document.createElement(\"textarea\");\n    textElement.setAttribute(\"spellcheck\", \"false\");\n    textElement.value = this._renderValue(this._action);\n    textElement.classList.add(\"text-editor\");\n    const updateAndValidate = () => {\n      var _a2;\n      const newValue = this._recorder.injectedScript.utils.normalizeWhiteSpace(textElement.value);\n      const target = (_a2 = this._hoverHighlight) == null ? void 0 : _a2.elements[0];\n      if (!target)\n        return;\n      action.text = newValue;\n      const targetText = this._recorder.injectedScript.utils.elementText(this._textCache, target).normalized;\n      const matches = newValue && targetText.includes(newValue);\n      textElement.classList.toggle(\"does-not-match\", !matches);\n    };\n    textElement.addEventListener(\"input\", updateAndValidate);\n    bodyElement.appendChild(textElement);\n    this._dialogElement.appendChild(bodyElement);\n    this._recorder.highlight.appendChild(this._dialogElement);\n    const position = this._recorder.highlight.tooltipPosition(this._recorder.highlight.firstBox(), this._dialogElement);\n    this._dialogElement.style.top = position.anchorTop + \"px\";\n    this._dialogElement.style.left = position.anchorLeft + \"px\";\n    textElement.focus();\n  }\n  _closeDialog() {\n    if (!this._dialogElement)\n      return;\n    this._dialogElement.remove();\n    this._recorder.document.removeEventListener(\"keydown\", this._keyboardListener);\n    this._dialogElement = null;\n  }\n  _commitAssertValue() {\n    var _a, _b, _c, _d, _e;\n    if (this._kind !== \"value\")\n      return;\n    const action = this._generateAction();\n    if (!action)\n      return;\n    (_b = (_a = this._recorder.delegate).recordAction) == null ? void 0 : _b.call(_a, action);\n    (_d = (_c = this._recorder.delegate).setMode) == null ? void 0 : _d.call(_c, \"recording\");\n    (_e = this._recorder.overlay) == null ? void 0 : _e.flashToolSucceeded(\"assertingValue\");\n  }\n};\nvar Overlay = class {\n  constructor(recorder) {\n    this._listeners = [];\n    this._offsetX = 0;\n    this._measure = { width: 0, height: 0 };\n    this._recorder = recorder;\n    const document = this._recorder.injectedScript.document;\n    this._overlayElement = document.createElement(\"x-pw-overlay\");\n    const toolsListElement = document.createElement(\"x-pw-tools-list\");\n    this._overlayElement.appendChild(toolsListElement);\n    this._dragHandle = document.createElement(\"x-pw-tool-gripper\");\n    this._dragHandle.appendChild(document.createElement(\"x-div\"));\n    toolsListElement.appendChild(this._dragHandle);\n    this._recordToggle = this._recorder.injectedScript.document.createElement(\"x-pw-tool-item\");\n    this._recordToggle.title = \"Record\";\n    this._recordToggle.classList.add(\"record\");\n    this._recordToggle.appendChild(this._recorder.injectedScript.document.createElement(\"x-div\"));\n    toolsListElement.appendChild(this._recordToggle);\n    this._pickLocatorToggle = this._recorder.injectedScript.document.createElement(\"x-pw-tool-item\");\n    this._pickLocatorToggle.title = \"Pick locator\";\n    this._pickLocatorToggle.classList.add(\"pick-locator\");\n    this._pickLocatorToggle.appendChild(this._recorder.injectedScript.document.createElement(\"x-div\"));\n    toolsListElement.appendChild(this._pickLocatorToggle);\n    this._assertVisibilityToggle = this._recorder.injectedScript.document.createElement(\"x-pw-tool-item\");\n    this._assertVisibilityToggle.title = \"Assert visibility\";\n    this._assertVisibilityToggle.classList.add(\"visibility\");\n    this._assertVisibilityToggle.appendChild(this._recorder.injectedScript.document.createElement(\"x-div\"));\n    toolsListElement.appendChild(this._assertVisibilityToggle);\n    this._assertTextToggle = this._recorder.injectedScript.document.createElement(\"x-pw-tool-item\");\n    this._assertTextToggle.title = \"Assert text\";\n    this._assertTextToggle.classList.add(\"text\");\n    this._assertTextToggle.appendChild(this._recorder.injectedScript.document.createElement(\"x-div\"));\n    toolsListElement.appendChild(this._assertTextToggle);\n    this._assertValuesToggle = this._recorder.injectedScript.document.createElement(\"x-pw-tool-item\");\n    this._assertValuesToggle.title = \"Assert value\";\n    this._assertValuesToggle.classList.add(\"value\");\n    this._assertValuesToggle.appendChild(this._recorder.injectedScript.document.createElement(\"x-div\"));\n    toolsListElement.appendChild(this._assertValuesToggle);\n    this._updateVisualPosition();\n    this._refreshListeners();\n  }\n  _refreshListeners() {\n    removeEventListeners(this._listeners);\n    this._listeners = [\n      addEventListener(this._dragHandle, \"mousedown\", (event) => {\n        this._dragState = { offsetX: this._offsetX, dragStart: { x: event.clientX, y: 0 } };\n      }),\n      addEventListener(this._recordToggle, \"click\", () => {\n        var _a, _b;\n        (_b = (_a = this._recorder.delegate).setMode) == null ? void 0 : _b.call(_a, this._recorder.state.mode === \"none\" || this._recorder.state.mode === \"standby\" || this._recorder.state.mode === \"inspecting\" ? \"recording\" : \"standby\");\n      }),\n      addEventListener(this._pickLocatorToggle, \"click\", () => {\n        var _a, _b;\n        const newMode = {\n          \"inspecting\": \"standby\",\n          \"none\": \"inspecting\",\n          \"standby\": \"inspecting\",\n          \"recording\": \"recording-inspecting\",\n          \"recording-inspecting\": \"recording\",\n          \"assertingText\": \"recording-inspecting\",\n          \"assertingVisibility\": \"recording-inspecting\",\n          \"assertingValue\": \"recording-inspecting\"\n        };\n        (_b = (_a = this._recorder.delegate).setMode) == null ? void 0 : _b.call(_a, newMode[this._recorder.state.mode]);\n      }),\n      addEventListener(this._assertVisibilityToggle, \"click\", () => {\n        var _a, _b;\n        if (!this._assertVisibilityToggle.classList.contains(\"disabled\"))\n          (_b = (_a = this._recorder.delegate).setMode) == null ? void 0 : _b.call(_a, this._recorder.state.mode === \"assertingVisibility\" ? \"recording\" : \"assertingVisibility\");\n      }),\n      addEventListener(this._assertTextToggle, \"click\", () => {\n        var _a, _b;\n        if (!this._assertTextToggle.classList.contains(\"disabled\"))\n          (_b = (_a = this._recorder.delegate).setMode) == null ? void 0 : _b.call(_a, this._recorder.state.mode === \"assertingText\" ? \"recording\" : \"assertingText\");\n      }),\n      addEventListener(this._assertValuesToggle, \"click\", () => {\n        var _a, _b;\n        if (!this._assertValuesToggle.classList.contains(\"disabled\"))\n          (_b = (_a = this._recorder.delegate).setMode) == null ? void 0 : _b.call(_a, this._recorder.state.mode === \"assertingValue\" ? \"recording\" : \"assertingValue\");\n      })\n    ];\n  }\n  install() {\n    this._recorder.highlight.appendChild(this._overlayElement);\n    this._refreshListeners();\n    this._updateVisualPosition();\n  }\n  contains(element) {\n    return this._recorder.injectedScript.utils.isInsideScope(this._overlayElement, element);\n  }\n  setUIState(state) {\n    this._recordToggle.classList.toggle(\"active\", state.mode === \"recording\" || state.mode === \"assertingText\" || state.mode === \"assertingVisibility\" || state.mode === \"assertingValue\" || state.mode === \"recording-inspecting\");\n    this._pickLocatorToggle.classList.toggle(\"active\", state.mode === \"inspecting\" || state.mode === \"recording-inspecting\");\n    this._assertVisibilityToggle.classList.toggle(\"active\", state.mode === \"assertingVisibility\");\n    this._assertVisibilityToggle.classList.toggle(\"disabled\", state.mode === \"none\" || state.mode === \"standby\" || state.mode === \"inspecting\");\n    this._assertTextToggle.classList.toggle(\"active\", state.mode === \"assertingText\");\n    this._assertTextToggle.classList.toggle(\"disabled\", state.mode === \"none\" || state.mode === \"standby\" || state.mode === \"inspecting\");\n    this._assertValuesToggle.classList.toggle(\"active\", state.mode === \"assertingValue\");\n    this._assertValuesToggle.classList.toggle(\"disabled\", state.mode === \"none\" || state.mode === \"standby\" || state.mode === \"inspecting\");\n    if (this._offsetX !== state.overlay.offsetX) {\n      this._offsetX = state.overlay.offsetX;\n      this._updateVisualPosition();\n    }\n    if (state.mode === \"none\")\n      this._hideOverlay();\n    else\n      this._showOverlay();\n  }\n  flashToolSucceeded(tool) {\n    const element = tool === \"assertingVisibility\" ? this._assertVisibilityToggle : this._assertValuesToggle;\n    element.classList.add(\"succeeded\");\n    setTimeout(() => element.classList.remove(\"succeeded\"), 2e3);\n  }\n  _hideOverlay() {\n    this._overlayElement.setAttribute(\"hidden\", \"true\");\n  }\n  _showOverlay() {\n    if (!this._overlayElement.hasAttribute(\"hidden\"))\n      return;\n    this._overlayElement.removeAttribute(\"hidden\");\n    this._updateVisualPosition();\n  }\n  _updateVisualPosition() {\n    this._measure = this._overlayElement.getBoundingClientRect();\n    this._overlayElement.style.left = (this._recorder.injectedScript.window.innerWidth - this._measure.width) / 2 + this._offsetX + \"px\";\n  }\n  onMouseMove(event) {\n    var _a, _b;\n    if (!event.buttons) {\n      this._dragState = void 0;\n      return false;\n    }\n    if (this._dragState) {\n      this._offsetX = this._dragState.offsetX + event.clientX - this._dragState.dragStart.x;\n      const halfGapSize = (this._recorder.injectedScript.window.innerWidth - this._measure.width) / 2 - 10;\n      this._offsetX = Math.max(-halfGapSize, Math.min(halfGapSize, this._offsetX));\n      this._updateVisualPosition();\n      (_b = (_a = this._recorder.delegate).setOverlayState) == null ? void 0 : _b.call(_a, { offsetX: this._offsetX });\n      consumeEvent(event);\n      return true;\n    }\n    return false;\n  }\n  onMouseUp(event) {\n    if (this._dragState) {\n      consumeEvent(event);\n      return true;\n    }\n    return false;\n  }\n  onClick(event) {\n    if (this._dragState) {\n      this._dragState = void 0;\n      consumeEvent(event);\n      return true;\n    }\n    return false;\n  }\n};\nvar Recorder = class {\n  constructor(injectedScript) {\n    this._listeners = [];\n    this._actionSelectorModel = null;\n    this.state = { mode: \"none\", testIdAttributeName: \"data-testid\", language: \"javascript\", overlay: { offsetX: 0 } };\n    this.delegate = {};\n    this.document = injectedScript.document;\n    this.injectedScript = injectedScript;\n    this.highlight = injectedScript.createHighlight();\n    this._tools = {\n      \"none\": new NoneTool(),\n      \"standby\": new NoneTool(),\n      \"inspecting\": new InspectTool(this, false),\n      \"recording\": new RecordActionTool(this),\n      \"recording-inspecting\": new InspectTool(this, false),\n      \"assertingText\": new TextAssertionTool(this, \"text\"),\n      \"assertingVisibility\": new InspectTool(this, true),\n      \"assertingValue\": new TextAssertionTool(this, \"value\")\n    };\n    this._currentTool = this._tools.none;\n    if (injectedScript.window.top === injectedScript.window) {\n      this.overlay = new Overlay(this);\n      this.overlay.setUIState(this.state);\n    }\n    this._styleElement = this.document.createElement(\"style\");\n    this._styleElement.textContent = `\n      body[data-pw-cursor=pointer] *, body[data-pw-cursor=pointer] *::after { cursor: pointer !important; }\n      body[data-pw-cursor=text] *, body[data-pw-cursor=text] *::after { cursor: text !important; }\n    `;\n    this.installListeners();\n    if (injectedScript.isUnderTest)\n      console.error(\"Recorder script ready for test\");\n  }\n  installListeners() {\n    var _a;\n    removeEventListeners(this._listeners);\n    this._listeners = [\n      addEventListener(this.document, \"click\", (event) => this._onClick(event), true),\n      addEventListener(this.document, \"auxclick\", (event) => this._onClick(event), true),\n      addEventListener(this.document, \"contextmenu\", (event) => this._onContextMenu(event), true),\n      addEventListener(this.document, \"dragstart\", (event) => this._onDragStart(event), true),\n      addEventListener(this.document, \"input\", (event) => this._onInput(event), true),\n      addEventListener(this.document, \"keydown\", (event) => this._onKeyDown(event), true),\n      addEventListener(this.document, \"keyup\", (event) => this._onKeyUp(event), true),\n      addEventListener(this.document, \"pointerdown\", (event) => this._onPointerDown(event), true),\n      addEventListener(this.document, \"pointerup\", (event) => this._onPointerUp(event), true),\n      addEventListener(this.document, \"mousedown\", (event) => this._onMouseDown(event), true),\n      addEventListener(this.document, \"mouseup\", (event) => this._onMouseUp(event), true),\n      addEventListener(this.document, \"mousemove\", (event) => this._onMouseMove(event), true),\n      addEventListener(this.document, \"mouseleave\", (event) => this._onMouseLeave(event), true),\n      addEventListener(this.document, \"mouseenter\", (event) => this._onMouseEnter(event), true),\n      addEventListener(this.document, \"focus\", (event) => this._onFocus(event), true),\n      addEventListener(this.document, \"scroll\", (event) => this._onScroll(event), true)\n    ];\n    this.highlight.install();\n    (_a = this.overlay) == null ? void 0 : _a.install();\n    this.injectedScript.document.head.appendChild(this._styleElement);\n  }\n  _switchCurrentTool() {\n    var _a, _b, _c;\n    const newTool = this._tools[this.state.mode];\n    if (newTool === this._currentTool)\n      return;\n    (_b = (_a = this._currentTool).cleanup) == null ? void 0 : _b.call(_a);\n    this.clearHighlight();\n    this._currentTool = newTool;\n    (_c = this.injectedScript.document.body) == null ? void 0 : _c.setAttribute(\"data-pw-cursor\", newTool.cursor());\n  }\n  setUIState(state, delegate) {\n    var _a, _b, _c, _d;\n    this.delegate = delegate;\n    if (state.actionPoint && this.state.actionPoint && state.actionPoint.x === this.state.actionPoint.x && state.actionPoint.y === this.state.actionPoint.y) {\n    } else if (!state.actionPoint && !this.state.actionPoint) {\n    } else {\n      if (state.actionPoint)\n        this.highlight.showActionPoint(state.actionPoint.x, state.actionPoint.y);\n      else\n        this.highlight.hideActionPoint();\n    }\n    this.state = state;\n    this.highlight.setLanguage(state.language);\n    this._switchCurrentTool();\n    (_a = this.overlay) == null ? void 0 : _a.setUIState(state);\n    if (((_b = this._actionSelectorModel) == null ? void 0 : _b.selector) && !((_c = this._actionSelectorModel) == null ? void 0 : _c.elements.length))\n      this._actionSelectorModel = null;\n    if (state.actionSelector !== ((_d = this._actionSelectorModel) == null ? void 0 : _d.selector))\n      this._actionSelectorModel = state.actionSelector ? querySelector(this.injectedScript, state.actionSelector, this.document) : null;\n    if (this.state.mode === \"none\" || this.state.mode === \"standby\")\n      this.updateHighlight(this._actionSelectorModel, false);\n  }\n  clearHighlight() {\n    var _a, _b;\n    (_b = (_a = this._currentTool).cleanup) == null ? void 0 : _b.call(_a);\n    this.updateHighlight(null, false);\n  }\n  _onClick(event) {\n    var _a, _b, _c;\n    if (!event.isTrusted)\n      return;\n    if ((_a = this.overlay) == null ? void 0 : _a.onClick(event))\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_c = (_b = this._currentTool).onClick) == null ? void 0 : _c.call(_b, event);\n  }\n  _onContextMenu(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onContextMenu) == null ? void 0 : _b.call(_a, event);\n  }\n  _onDragStart(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onDragStart) == null ? void 0 : _b.call(_a, event);\n  }\n  _onPointerDown(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onPointerDown) == null ? void 0 : _b.call(_a, event);\n  }\n  _onPointerUp(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onPointerUp) == null ? void 0 : _b.call(_a, event);\n  }\n  _onMouseDown(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onMouseDown) == null ? void 0 : _b.call(_a, event);\n  }\n  _onMouseUp(event) {\n    var _a, _b, _c;\n    if (!event.isTrusted)\n      return;\n    if ((_a = this.overlay) == null ? void 0 : _a.onMouseUp(event))\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_c = (_b = this._currentTool).onMouseUp) == null ? void 0 : _c.call(_b, event);\n  }\n  _onMouseMove(event) {\n    var _a, _b, _c;\n    if (!event.isTrusted)\n      return;\n    if ((_a = this.overlay) == null ? void 0 : _a.onMouseMove(event))\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_c = (_b = this._currentTool).onMouseMove) == null ? void 0 : _c.call(_b, event);\n  }\n  _onMouseEnter(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onMouseEnter) == null ? void 0 : _b.call(_a, event);\n  }\n  _onMouseLeave(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onMouseLeave) == null ? void 0 : _b.call(_a, event);\n  }\n  _onFocus(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onFocus) == null ? void 0 : _b.call(_a, event);\n  }\n  _onScroll(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    this.highlight.hideActionPoint();\n    (_b = (_a = this._currentTool).onScroll) == null ? void 0 : _b.call(_a, event);\n  }\n  _onInput(event) {\n    var _a, _b;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onInput) == null ? void 0 : _b.call(_a, event);\n  }\n  _onKeyDown(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onKeyDown) == null ? void 0 : _b.call(_a, event);\n  }\n  _onKeyUp(event) {\n    var _a, _b;\n    if (!event.isTrusted)\n      return;\n    if (this._ignoreOverlayEvent(event))\n      return;\n    (_b = (_a = this._currentTool).onKeyUp) == null ? void 0 : _b.call(_a, event);\n  }\n  updateHighlight(model, userGesture) {\n    var _a, _b;\n    let tooltipText = model == null ? void 0 : model.tooltipText;\n    if (tooltipText === void 0 && !(model == null ? void 0 : model.tooltipList) && (model == null ? void 0 : model.selector))\n      tooltipText = this.injectedScript.utils.asLocator(this.state.language, model.selector);\n    this.highlight.updateHighlight((model == null ? void 0 : model.elements) || [], { ...model, tooltipText });\n    if (userGesture)\n      (_b = (_a = this.delegate).highlightUpdated) == null ? void 0 : _b.call(_a);\n  }\n  _ignoreOverlayEvent(event) {\n    return event.composedPath().some((e) => {\n      const nodeName = e.nodeName || \"\";\n      return nodeName.toLowerCase() === \"x-pw-glass\";\n    });\n  }\n  deepEventTarget(event) {\n    var _a;\n    for (const element of event.composedPath()) {\n      if (!((_a = this.overlay) == null ? void 0 : _a.contains(element)))\n        return element;\n    }\n    return event.composedPath()[0];\n  }\n};\nfunction deepActiveElement(document) {\n  let activeElement = document.activeElement;\n  while (activeElement && activeElement.shadowRoot && activeElement.shadowRoot.activeElement)\n    activeElement = activeElement.shadowRoot.activeElement;\n  return activeElement;\n}\nfunction modifiersForEvent(event) {\n  return (event.altKey ? 1 : 0) | (event.ctrlKey ? 2 : 0) | (event.metaKey ? 4 : 0) | (event.shiftKey ? 8 : 0);\n}\nfunction buttonForEvent(event) {\n  switch (event.which) {\n    case 1:\n      return \"left\";\n    case 2:\n      return \"middle\";\n    case 3:\n      return \"right\";\n  }\n  return \"left\";\n}\nfunction positionForEvent(event) {\n  const targetElement = event.target;\n  if (targetElement.nodeName !== \"CANVAS\")\n    return;\n  return {\n    x: event.offsetX,\n    y: event.offsetY\n  };\n}\nfunction consumeEvent(e) {\n  e.preventDefault();\n  e.stopPropagation();\n  e.stopImmediatePropagation();\n}\nfunction asCheckbox(node) {\n  if (!node || node.nodeName !== \"INPUT\")\n    return null;\n  const inputElement = node;\n  return [\"checkbox\", \"radio\"].includes(inputElement.type) ? inputElement : null;\n}\nfunction isRangeInput(node) {\n  if (!node || node.nodeName !== \"INPUT\")\n    return false;\n  const inputElement = node;\n  return inputElement.type.toLowerCase() === \"range\";\n}\nfunction addEventListener(target, eventName, listener, useCapture) {\n  target.addEventListener(eventName, listener, useCapture);\n  const remove = () => {\n    target.removeEventListener(eventName, listener, useCapture);\n  };\n  return remove;\n}\nfunction removeEventListeners(listeners) {\n  for (const listener of listeners)\n    listener();\n  listeners.splice(0, listeners.length);\n}\nfunction querySelector(injectedScript, selector, ownerDocument) {\n  try {\n    const parsedSelector = injectedScript.parseSelector(selector);\n    return {\n      selector,\n      elements: injectedScript.querySelectorAll(parsedSelector, ownerDocument)\n    };\n  } catch (e) {\n    return {\n      selector,\n      elements: []\n    };\n  }\n}\nvar PollingRecorder = class {\n  constructor(injectedScript) {\n    this._recorder = new Recorder(injectedScript);\n    this._embedder = injectedScript.window;\n    injectedScript.onGlobalListenersRemoved.add(() => this._recorder.installListeners());\n    const refreshOverlay = () => {\n      this._pollRecorderMode().catch((e) => console.log(e));\n    };\n    this._embedder.__pw_refreshOverlay = refreshOverlay;\n    refreshOverlay();\n  }\n  async _pollRecorderMode() {\n    const pollPeriod = 1e3;\n    if (this._pollRecorderModeTimer)\n      clearTimeout(this._pollRecorderModeTimer);\n    const state = await this._embedder.__pw_recorderState().catch(() => {\n    });\n    if (!state) {\n      this._pollRecorderModeTimer = setTimeout(() => this._pollRecorderMode(), pollPeriod);\n      return;\n    }\n    const win = this._recorder.document.defaultView;\n    if (win.top !== win) {\n      state.actionPoint = void 0;\n    }\n    this._recorder.setUIState(state, this);\n    this._pollRecorderModeTimer = setTimeout(() => this._pollRecorderMode(), pollPeriod);\n  }\n  async performAction(action) {\n    await this._embedder.__pw_recorderPerformAction(action);\n  }\n  async recordAction(action) {\n    await this._embedder.__pw_recorderRecordAction(action);\n  }\n  async setSelector(selector) {\n    await this._embedder.__pw_recorderSetSelector(selector);\n  }\n  async setMode(mode) {\n    await this._embedder.__pw_recorderSetMode(mode);\n  }\n  async setOverlayState(state) {\n    await this._embedder.__pw_recorderSetOverlayState(state);\n  }\n};\nvar recorder_default = PollingRecorder;\n";