/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Single;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Function;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.reactivestreams.Subscription;

class NettyResponse
extends HttpResponse {
    private final io.netty.handler.codec.http.HttpResponse rxnRes;
    private final Flowable<ByteBuf> contentStream;

    NettyResponse(io.netty.handler.codec.http.HttpResponse rxnRes, Flowable<ByteBuf> emitter) {
        this.rxnRes = rxnRes;
        this.contentStream = emitter;
    }

    @Override
    public int statusCode() {
        return this.rxnRes.status().code();
    }

    @Override
    public String headerValue(String headerName) {
        return this.rxnRes.headers().get(headerName);
    }

    @Override
    public HttpHeaders headers() {
        HttpHeaders headers = new HttpHeaders();
        for (Map.Entry header : this.rxnRes.headers()) {
            headers.set((String)header.getKey(), (String)header.getValue());
        }
        return headers;
    }

    private Single<ByteBuf> collectContent() {
        ByteBuf allContent = null;
        String contentLengthString = this.headerValue("Content-Length");
        if (contentLengthString != null) {
            try {
                int contentLength = Integer.parseInt(contentLengthString);
                allContent = Unpooled.buffer((int)contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (allContent == null) {
            allContent = Unpooled.buffer();
        }
        return this.contentStream.collectInto((Object)allContent, (BiConsumer)new BiConsumer<ByteBuf, ByteBuf>(){

            public void accept(ByteBuf allContent, ByteBuf chunk) throws Exception {
                try {
                    allContent.writeBytes(chunk);
                }
                finally {
                    chunk.release();
                }
            }
        });
    }

    @Override
    public Single<byte[]> bodyAsByteArray() {
        return this.collectContent().map((Function)new Function<ByteBuf, byte[]>(){

            public byte[] apply(ByteBuf byteBuf) throws Exception {
                byte[] result;
                if (byteBuf.readableBytes() == byteBuf.array().length) {
                    result = byteBuf.array();
                } else {
                    byte[] dst = new byte[byteBuf.readableBytes()];
                    byteBuf.readBytes(dst);
                    result = dst;
                }
                byteBuf.release();
                return result;
            }
        });
    }

    @Override
    public Flowable<ByteBuffer> body() {
        return this.contentStream.map((Function)new Function<ByteBuf, ByteBuffer>(){

            public ByteBuffer apply(ByteBuf byteBuf) {
                ByteBuffer dst = ByteBuffer.allocate(byteBuf.readableBytes());
                byteBuf.readBytes(dst);
                byteBuf.release();
                dst.flip();
                return dst;
            }
        });
    }

    @Override
    public Single<String> bodyAsString() {
        return this.collectContent().map((Function)new Function<ByteBuf, String>(){

            public String apply(ByteBuf byteBuf) throws Exception {
                String result = byteBuf.toString(StandardCharsets.UTF_8);
                byteBuf.release();
                return result;
            }
        });
    }

    @Override
    public void close() {
        this.contentStream.subscribe((FlowableSubscriber)new FlowableSubscriber<ByteBuf>(){

            public void onSubscribe(Subscription s) {
                s.cancel();
            }

            public void onNext(ByteBuf byteBuf) {
            }

            public void onError(Throwable ignored) {
            }

            public void onComplete() {
            }
        });
    }
}

