/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import com.microsoft.rest.v2.util.Base64Util;
import io.reactivex.Single;
import java.nio.charset.StandardCharsets;

public class ProxyAuthenticationPolicyFactory
implements RequestPolicyFactory {
    private final String username;
    private final String password;

    public ProxyAuthenticationPolicyFactory(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new ProxyAuthenticationPolicy(next);
    }

    private final class ProxyAuthenticationPolicy
    implements RequestPolicy {
        private final RequestPolicy next;

        private ProxyAuthenticationPolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            String auth = ProxyAuthenticationPolicyFactory.this.username + ":" + ProxyAuthenticationPolicyFactory.this.password;
            String encodedAuth = Base64Util.encodeToString(auth.getBytes(StandardCharsets.UTF_8));
            request.withHeader("Proxy-Authentication", "Basic " + encodedAuth);
            return this.next.sendAsync(request);
        }
    }
}

