/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.util;

import com.microsoft.rest.v2.http.UnexpectedLengthException;
import com.microsoft.rest.v2.util.TypeUtil;
import io.netty.buffer.Unpooled;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.Single;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableUtil {
    private static final int DEFAULT_CHUNK_SIZE = 65536;

    public static boolean isFlowableByteBuffer(Type entityType) {
        Type innerType;
        return TypeUtil.isTypeOrSubTypeOf(entityType, Flowable.class) && TypeUtil.isTypeOrSubTypeOf(innerType = TypeUtil.getTypeArguments(entityType)[0], ByteBuffer.class);
    }

    public static Single<byte[]> collectBytesInArray(Flowable<ByteBuffer> content) {
        return content.collectInto((Object)Unpooled.buffer(), (buf, bb) -> buf.writeBytes(bb.slice())).map(out -> {
            try {
                if (out.array().length == out.readableBytes()) {
                    byte[] byArray = out.array();
                    return byArray;
                }
                byte[] arr = new byte[out.readableBytes()];
                out.readBytes(arr);
                byte[] byArray = arr;
                return byArray;
            }
            finally {
                out.release();
            }
        });
    }

    public static FlowableTransformer<ByteBuffer, ByteBuffer> ensureLength(final long bytesExpected) {
        return source -> Flowable.defer((Callable)new Callable<Publisher<? extends ByteBuffer>>(){
            long bytesRead = 0L;

            @Override
            public Publisher<? extends ByteBuffer> call() throws Exception {
                return source.doOnNext(bb -> {
                    this.bytesRead += (long)bb.remaining();
                    if (this.bytesRead > bytesExpected) {
                        throw new UnexpectedLengthException("Flowable<ByteBuffer> emitted more bytes than the expected " + bytesExpected, this.bytesRead, bytesExpected);
                    }
                }).doOnComplete(() -> {
                    if (this.bytesRead != bytesExpected) {
                        throw new UnexpectedLengthException(String.format("Flowable<ByteBuffer> emitted %d bytes instead of the expected %d bytes.", this.bytesRead, bytesExpected), this.bytesRead, bytesExpected);
                    }
                });
            }
        });
    }

    public static Single<ByteBuffer> collectBytesInBuffer(Flowable<ByteBuffer> content) {
        return FlowableUtil.collectBytesInArray(content).map(ByteBuffer::wrap);
    }

    public static Completable writeFile(Flowable<ByteBuffer> content, AsynchronousFileChannel outFile) {
        return FlowableUtil.writeFile(content, outFile, 0L);
    }

    public static Completable writeFile(Flowable<ByteBuffer> content, final AsynchronousFileChannel outFile, final long position) {
        return Completable.create(emitter -> content.subscribe((FlowableSubscriber)new FlowableSubscriber<ByteBuffer>(){
            volatile boolean isWriting = false;
            volatile boolean isCompleted = false;
            volatile Subscription subscription;
            volatile long pos = position;
            CompletionHandler onWriteCompleted = new CompletionHandler<Integer, Object>(){

                @Override
                public void completed(Integer bytesWritten, Object attachment) {
                    isWriting = false;
                    if (isCompleted) {
                        emitter.onComplete();
                    }
                    pos += (long)bytesWritten.intValue();
                    subscription.request(1L);
                }

                @Override
                public void failed(Throwable exc, Object attachment) {
                    subscription.cancel();
                    emitter.onError(exc);
                }
            };

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                s.request(1L);
            }

            public void onNext(ByteBuffer bytes) {
                this.isWriting = true;
                outFile.write(bytes, this.pos, null, this.onWriteCompleted);
            }

            public void onError(Throwable throwable) {
                this.subscription.cancel();
                emitter.onError(throwable);
            }

            public void onComplete() {
                this.isCompleted = true;
                if (!this.isWriting) {
                    emitter.onComplete();
                }
            }
        }));
    }

    public static Flowable<ByteBuffer> readFile(AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
        return new FileReadFlowable(fileChannel, chunkSize, offset, length);
    }

    public static Flowable<ByteBuffer> readFile(AsynchronousFileChannel fileChannel, long offset, long length) {
        return FlowableUtil.readFile(fileChannel, 65536, offset, length);
    }

    public static Flowable<ByteBuffer> readFile(AsynchronousFileChannel fileChannel) {
        try {
            long size = fileChannel.size();
            return FlowableUtil.readFile(fileChannel, 65536, 0L, size);
        }
        catch (IOException e) {
            return Flowable.error((Throwable)e);
        }
    }

    public static Flowable<ByteBuffer> split(ByteBuffer whole, int chunkSize) {
        return Flowable.generate(whole::position, (position, emitter) -> {
            int newLimit = Math.min(whole.limit(), position + chunkSize);
            if (position >= whole.limit()) {
                emitter.onComplete();
            } else {
                ByteBuffer chunk = whole.duplicate();
                chunk.position((int)position).limit(newLimit);
                emitter.onNext((Object)chunk);
            }
            return newLimit;
        });
    }

    private FlowableUtil() {
    }

    private static final class FileReadFlowable
    extends Flowable<ByteBuffer> {
        private final AsynchronousFileChannel fileChannel;
        private final int chunkSize;
        private final long offset;
        private final long length;

        FileReadFlowable(AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
            this.fileChannel = fileChannel;
            this.chunkSize = chunkSize;
            this.offset = offset;
            this.length = length;
        }

        protected void subscribeActual(Subscriber<? super ByteBuffer> s) {
            FileReadSubscription subscription = new FileReadSubscription(s);
            s.onSubscribe((Subscription)subscription);
        }

        private final class FileReadSubscription
        extends AtomicInteger
        implements Subscription,
        CompletionHandler<Integer, ByteBuffer> {
            private static final int NOT_SET = -1;
            private static final long serialVersionUID = -6831808726875304256L;
            private final AtomicLong requested = new AtomicLong();
            private final Subscriber<? super ByteBuffer> subscriber;
            private volatile boolean done;
            private Throwable error;
            private volatile ByteBuffer next;
            private volatile long position;
            private volatile boolean cancelled;

            FileReadSubscription(Subscriber<? super ByteBuffer> subscriber) {
                this.subscriber = subscriber;
                this.position = -1L;
            }

            public void request(long n) {
                if (SubscriptionHelper.validate((long)n)) {
                    BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                    this.drain();
                }
            }

            private void drain() {
                if (this.getAndIncrement() == 0) {
                    if (this.position == -1L) {
                        this.position = FileReadFlowable.this.offset;
                        this.doRead();
                    }
                    int missed = 1;
                    do {
                        if (this.cancelled) {
                            return;
                        }
                        if (this.requested.get() <= 0L) continue;
                        boolean emitted = false;
                        boolean d = this.done;
                        ByteBuffer bb = this.next;
                        if (bb != null) {
                            this.next = null;
                            this.subscriber.onNext((Object)bb);
                            emitted = true;
                        } else {
                            emitted = false;
                        }
                        if (d) {
                            if (this.error != null) {
                                this.subscriber.onError(this.error);
                                return;
                            }
                            this.subscriber.onComplete();
                            return;
                        }
                        if (!emitted) continue;
                        BackpressureHelper.produced((AtomicLong)this.requested, (long)1L);
                        this.doRead();
                    } while ((missed = this.addAndGet(-missed)) != 0);
                    return;
                }
            }

            private void doRead() {
                long pos = this.position;
                ByteBuffer innerBuf = ByteBuffer.allocate(Math.min(FileReadFlowable.this.chunkSize, this.maxRequired(pos)));
                FileReadFlowable.this.fileChannel.read(innerBuf, pos, innerBuf, this);
            }

            private int maxRequired(long pos) {
                long maxRequired = FileReadFlowable.this.offset + FileReadFlowable.this.length - pos;
                if (maxRequired <= 0L) {
                    return 0;
                }
                int m = (int)maxRequired;
                if (m < 0) {
                    return Integer.MAX_VALUE;
                }
                return m;
            }

            @Override
            public void completed(Integer bytesRead, ByteBuffer buffer) {
                if (!this.cancelled) {
                    if (bytesRead == -1) {
                        this.done = true;
                    } else {
                        long position2;
                        long pos = this.position;
                        int bytesWanted = Math.min(bytesRead, this.maxRequired(pos));
                        this.position = position2 = pos + (long)bytesWanted;
                        buffer.position(bytesWanted);
                        buffer.flip();
                        this.next = buffer;
                        if (position2 >= FileReadFlowable.this.offset + FileReadFlowable.this.length) {
                            this.done = true;
                        }
                    }
                    this.drain();
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                if (!this.cancelled) {
                    this.error = exc;
                    this.done = true;
                    this.drain();
                }
            }

            public void cancel() {
                this.cancelled = true;
            }
        }
    }
}

