/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import com.mks.api.util.InternalAPILogListener;
import com.mks.api.util.Queue;
import com.mks.api.util.StackTrace;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

final class Logger
implements Runnable {
    public static final String DEBUG = "DEBUG";
    public static final String FATAL = "FATAL";
    public static final String ERROR = "ERROR";
    public static final String GENERAL = "GENERAL";
    public static final String IGNORE = "IGNORE";
    public static final String WARNING = "WARNING";
    public static final String LOCKFILE = "LOCKFILE";
    public static final int LOWEST = 20;
    public static final int LOW = 10;
    public static final int MEDIUM = 5;
    public static final int HIGH = 0;
    public static final int OFF = -1;
    private static Logger defaultLogger;
    private List logListeners = new ArrayList();
    private static ThreadLocal threadData;
    private Queue messageQueue = new Queue();
    private int maxQueueSize = 10000;
    private Thread loggerThread;
    private boolean runLogger = true;

    public Logger(boolean makeAppDefault) {
        this(makeAppDefault, "Logger");
    }

    public Logger(boolean makeAppDefault, String threadName) {
        this.loggerThread = new Thread((Runnable)this, threadName);
        this.loggerThread.setDaemon(true);
        this.loggerThread.start();
        if (makeAppDefault) {
            Logger.setApplicationLogger(this);
        }
    }

    public void stop() {
        if (this == defaultLogger) {
            new Exception("Trying to stop the default logger!!").printStackTrace(System.out);
        } else {
            this.runLogger = false;
            this.loggerThread.interrupt();
        }
    }

    public static Logger getApplicationLogger() {
        return defaultLogger;
    }

    public static synchronized void setApplicationLogger(Logger logger) {
        if (defaultLogger != null && logger == null) {
            new Exception("Someone is trying to set the default logger to null!!!").printStackTrace(System.out);
        } else {
            defaultLogger = logger;
        }
    }

    public void setPriority(int priority) {
        this.loggerThread.setPriority(priority);
    }

    public void setMessageQueueSize(int maxsize) {
        this.maxQueueSize = maxsize;
    }

    public static void setApplicationMessageQueueSize(int maxsize) {
        if (defaultLogger != null) {
            defaultLogger.setMessageQueueSize(maxsize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(InternalAPILogListener listener) {
        List list = this.logListeners;
        synchronized (list) {
            if (!this.logListeners.contains(listener)) {
                this.logListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(InternalAPILogListener listener) {
        List list = this.logListeners;
        synchronized (list) {
            this.logListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLogListeners() {
        List list = this.logListeners;
        synchronized (list) {
            return new ArrayList(this.logListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(Class klass, Object obj, String category, int level, String message) {
        if (message == null) {
            this.logMessage(null, null, ERROR, 0, "Logger.logMessage called with null error message from: " + StackTrace.getStackTrace());
            return;
        }
        if (this.logListeners.isEmpty()) {
            return;
        }
        if (category == null) {
            category = GENERAL;
        }
        Object threadData = this.defaultThreadData();
        Queue queue = this.messageQueue;
        synchronized (queue) {
            if (this.maxQueueSize != 0 && this.messageQueue.size() >= this.maxQueueSize) {
                this.processNextMessage(false);
            }
            this.messageQueue.enqueue(new LogMessage(klass, obj, category, level, threadData, message));
            this.messageQueue.notify();
        }
    }

    public Object defaultThreadData() {
        Object data = threadData.get();
        if (data != null) {
            return data;
        }
        Thread t = Thread.currentThread();
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            return t.getName();
        }
        return this.getName(subject) + "[" + t.getName() + "]";
    }

    private String getName(Subject s) {
        Iterator<Principal> i;
        if (s != null && (i = s.getPrincipals().iterator()).hasNext()) {
            Principal p = i.next();
            return p.getName();
        }
        return "unknown";
    }

    public boolean logMessageCheck(String category, int level) {
        try {
            Iterator i = this.logListeners.iterator();
            while (i.hasNext()) {
                InternalAPILogListener listener = (InternalAPILogListener)i.next();
                if (!listener.willLogMessage(category, level)) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException e) {
            return this.logMessageCheck(category, level);
        }
        return false;
    }

    public static void message(Class klass, Object obj, String category, int level, String message) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logMessage(klass, obj, category, level, message);
    }

    public void logMessage(Class klass, String category, int level, String message) {
        this.logMessage(klass, null, category, level, message);
    }

    public static void message(Class klass, String category, int level, String message) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logMessage(klass, category, level, message);
    }

    public void logMessage(Object obj, String category, int level, String message) {
        this.logMessage(obj == null ? null : obj.getClass(), obj, category, level, message);
    }

    public static void message(Object obj, String category, int level, String message) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logMessage(obj, category, level, message);
    }

    public static boolean messageCheck(String category, int level) {
        if (defaultLogger == null) {
            return false;
        }
        return defaultLogger.logMessageCheck(category, level);
    }

    public void logMessage(String category, int level, String message) {
        this.logMessage(null, null, category, level, message);
    }

    public static void message(String category, int level, String message) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logMessage(category, level, message);
    }

    public static void multiLineMessage(String category, int level, String message) {
        if (defaultLogger == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(message, "\n");
        while (st.hasMoreTokens()) {
            defaultLogger.logMessage(category, level, st.nextToken());
        }
    }

    public void logMessage(String category, String message) {
        this.logMessage(null, null, category, 0, message);
    }

    public boolean logMessageCheck(String category) {
        return this.logMessageCheck(category, 0);
    }

    public static void message(String category, String message) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logMessage(category, message);
    }

    public static boolean messageCheck(String category) {
        if (defaultLogger == null) {
            return false;
        }
        return defaultLogger.logMessageCheck(category);
    }

    public void logMessage(String message) {
        this.logMessage(null, null, null, 0, message);
    }

    public boolean logMessageCheck() {
        return this.logMessageCheck(null, 0);
    }

    public static void message(String message) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logMessage(message);
    }

    public static boolean messageCheck() {
        if (defaultLogger == null) {
            return false;
        }
        return defaultLogger.logMessageCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logException(Class klass, Object obj, String category, int level, Throwable exception) {
        if (exception == null) {
            this.logMessage(null, null, ERROR, 0, "Logger.logException called with null exception from: " + StackTrace.getStackTrace());
            return;
        }
        if (this.logListeners.isEmpty()) {
            return;
        }
        if (category == null) {
            category = GENERAL;
        }
        Object threadData = this.defaultThreadData();
        Queue queue = this.messageQueue;
        synchronized (queue) {
            if (this.maxQueueSize != 0 && this.messageQueue.size() >= this.maxQueueSize) {
                this.processNextMessage(false);
            }
            this.messageQueue.enqueue(new LogException(klass, obj, category, level, threadData, exception));
            this.messageQueue.notify();
        }
    }

    public boolean logExceptionCheck(String category, int level) {
        try {
            Iterator i = this.logListeners.iterator();
            while (i.hasNext()) {
                InternalAPILogListener listener = (InternalAPILogListener)i.next();
                if (!listener.willLogException(category, level)) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException e) {
            return this.logMessageCheck(category, level);
        }
        return false;
    }

    public static void exception(Class klass, Object obj, String category, int level, Throwable exception) {
        if (defaultLogger == null) {
            return;
        }
        try {
            defaultLogger.logException(klass, obj, category, level, exception);
        }
        catch (OutOfMemoryError oom) {
            try {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public static boolean exceptionCheck(String category, int level) {
        if (defaultLogger == null) {
            return false;
        }
        return defaultLogger.logExceptionCheck(category, level);
    }

    public void logException(Class klass, String category, int level, Throwable exception) {
        this.logException(klass, null, category, level, exception);
    }

    public static void exception(Class klass, String category, int level, Throwable exception) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logException(klass, category, level, exception);
    }

    public void logException(Object obj, String category, int level, Throwable exception) {
        this.logException(obj == null ? null : obj.getClass(), obj, category, level, exception);
    }

    public static void exception(Object obj, String category, int level, Throwable exception) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logException(obj, category, level, exception);
    }

    public void logException(String category, int level, Throwable exception) {
        this.logException(null, null, category, level, exception);
    }

    public static void exception(String category, int level, Throwable exception) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logException(category, level, exception);
    }

    public void logException(String category, Throwable exception) {
        this.logException(null, null, category, 0, exception);
    }

    public boolean logExceptionCheck(String category) {
        return this.logExceptionCheck(category, 0);
    }

    public static void exception(String category, Throwable exception) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logException(category, exception);
    }

    public boolean exceptionCheck(String category) {
        if (defaultLogger == null) {
            return false;
        }
        return defaultLogger.logExceptionCheck(category);
    }

    public void logException(Throwable exception) {
        this.logException(null, null, null, 0, exception);
    }

    public boolean logExceptionCheck() {
        return this.logExceptionCheck(null, 0);
    }

    public static void exception(Throwable exception) {
        if (defaultLogger == null) {
            return;
        }
        defaultLogger.logException(exception);
    }

    public boolean exceptionCheck() {
        if (defaultLogger == null) {
            return false;
        }
        return defaultLogger.logExceptionCheck();
    }

    public int updateCategoryLevel(String category, int level) {
        List logList = this.getLogListeners();
        int n = 0;
        Iterator i = logList.iterator();
        while (i.hasNext()) {
            InternalAPILogListener ll = (InternalAPILogListener)i.next();
            ll.removeCategoryIncludeFilter(0, category);
            ll.removeCategoryIncludeFilter(1, category);
            ll.removeCategoryExcludeFilter(0, category);
            ll.removeCategoryExcludeFilter(1, category);
            ll.addCategoryIncludeFilter(0, category, level);
            ll.addCategoryIncludeFilter(1, category, level);
            ++n;
        }
        return n;
    }

    public int getCategoryLevel(String category) {
        try {
            Iterator i = this.logListeners.iterator();
            int max = -1;
            block2: while (i.hasNext()) {
                InternalAPILogListener ll = (InternalAPILogListener)i.next();
                for (int level = 20; level >= 0; --level) {
                    if (!ll.willLogMessage(category, level) && !ll.willLogException(category, level)) continue;
                    if (level == 20) {
                        return 20;
                    }
                    if (level <= max) continue;
                    max = level;
                    continue block2;
                }
            }
            return max;
        }
        catch (ConcurrentModificationException e) {
            return this.getCategoryLevel(category);
        }
    }

    public static int getDefaultCategoryLevel(String category) {
        Logger logger = defaultLogger;
        if (logger == null) {
            return -1;
        }
        return logger.getCategoryLevel(category);
    }

    public void logAddThreadData(Object obj) {
        threadData.set(obj);
    }

    public static void addThreadData(Object obj) {
        if (defaultLogger != null) {
            defaultLogger.logAddThreadData(obj);
        }
    }

    public Object logGetThreadData() {
        return threadData.get();
    }

    public static Object getThreadData() {
        return defaultLogger == null ? null : defaultLogger.logGetThreadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.runLogger) {
                try {
                    this.processNextMessage(true);
                }
                catch (Throwable th) {
                    th.printStackTrace(System.out);
                }
            }
            Object var3_2 = null;
            if (this == defaultLogger) {
                System.out.println(new Date() + " - Cleaning up default logger!!!, runLogger is: " + this.runLogger);
                defaultLogger = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this == defaultLogger) {
                System.out.println(new Date() + " - Cleaning up default logger!!!, runLogger is: " + this.runLogger);
                defaultLogger = null;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextMessage(boolean wait) {
        LogObject obj;
        Queue queue = this.messageQueue;
        synchronized (queue) {
            if (this.messageQueue.isEmpty()) {
                if (wait) {
                    try {
                        this.messageQueue.wait();
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
                return;
            }
            obj = (LogObject)this.messageQueue.dequeue();
        }
        boolean done = false;
        while (!done) {
            try {
                Iterator i = this.logListeners.iterator();
                while (i.hasNext()) {
                    obj.log((InternalAPILogListener)i.next());
                }
                done = true;
            }
            catch (ConcurrentModificationException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        LogFlush semaphore;
        LogFlush logFlush = semaphore = new LogFlush();
        synchronized (logFlush) {
            Queue queue = this.messageQueue;
            synchronized (queue) {
                this.messageQueue.enqueue(semaphore);
                this.messageQueue.notify();
            }
            try {
                semaphore.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        threadData = new ThreadLocal();
    }

    private static class LogFlush
    extends LogObject {
        private boolean notified = false;

        private LogFlush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(InternalAPILogListener listener) {
            if (!this.notified) {
                LogFlush logFlush = this;
                synchronized (logFlush) {
                    this.notify();
                }
                this.notified = true;
            }
        }
    }

    private static class LogException
    extends LogObject {
        private Throwable exception;

        public LogException(Class klass, Object obj, String category, int level, Object threadData, Throwable exception) {
            this.klass = klass;
            this.obj = obj;
            this.category = category;
            this.level = level;
            this.threadData = threadData;
            this.exception = exception;
        }

        public void log(InternalAPILogListener listener) {
            listener.logException(this.klass, this.obj, this.category, this.level, this.threadData, this.exception);
        }
    }

    private static class LogMessage
    extends LogObject {
        private String message;

        public LogMessage(Class klass, Object obj, String category, int level, Object threadData, String message) {
            this.klass = klass;
            this.obj = obj;
            this.category = category;
            this.level = level;
            this.threadData = threadData;
            this.message = message;
        }

        public void log(InternalAPILogListener listener) {
            listener.logMessage(this.klass, this.obj, this.category, this.level, this.threadData, this.message);
        }
    }

    private static abstract class LogObject {
        protected Class klass;
        protected Object obj;
        protected String category;
        protected int level;
        protected Object threadData;

        private LogObject() {
        }

        public abstract void log(InternalAPILogListener var1);
    }
}

