/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.connector;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.connector.InteractionImplementor;
import com.mockrunner.mock.connector.cci.MockMappedRecord;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;

public class MappedRecordInteraction
implements InteractionImplementor {
    private boolean enabled;
    private Map expectedRequest;
    private Map responseData;
    private Class responseClass;
    private Record responseRecord;

    public MappedRecordInteraction() {
        this(null, null, MockMappedRecord.class);
    }

    public MappedRecordInteraction(Map responseMap) {
        this(null, responseMap, MockMappedRecord.class);
    }

    public MappedRecordInteraction(Map expectedRequest, Map responseMap) {
        this(expectedRequest, responseMap, MockMappedRecord.class);
    }

    public MappedRecordInteraction(Map responseMap, Class responseClass) {
        this(null, responseMap, responseClass);
    }

    public MappedRecordInteraction(Map expectedRequest, Map responseMap, Class responseClass) {
        this.setExpectedRequest(expectedRequest);
        this.setResponse(responseMap, responseClass);
        this.enabled = true;
    }

    public MappedRecordInteraction(Map expectedRequest, Record responseRecord) {
        this.setExpectedRequest(expectedRequest);
        this.setResponse(responseRecord);
        this.enabled = true;
    }

    public MappedRecordInteraction(Record responseRecord) {
        this(null, responseRecord);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void setExpectedRequest(Map expectedRequest) {
        this.expectedRequest = null == expectedRequest ? null : new HashMap(expectedRequest);
    }

    public void setResponse(Map responseMap) {
        this.setResponse(responseMap, MockMappedRecord.class);
    }

    public void setResponse(Map responseMap, Class responseClass) {
        if (!this.isResponseClassAcceptable(responseClass)) {
            throw new IllegalArgumentException("responseClass must implement " + MappedRecord.class.getName());
        }
        this.responseData = null == responseMap ? null : new HashMap(responseMap);
        this.responseClass = responseClass;
    }

    public void setResponse(Record responseRecord) {
        this.responseRecord = responseRecord;
    }

    public boolean canHandle(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) {
        if (!this.enabled) {
            return false;
        }
        if (!this.isResponseAcceptable(actualResponse)) {
            return false;
        }
        return this.doesRequestMatch(actualRequest);
    }

    private boolean doesRequestMatch(Record request) {
        if (null == this.expectedRequest) {
            return true;
        }
        if (null == request) {
            return false;
        }
        if (request instanceof MappedRecord) {
            try {
                MappedRecord mappedRequest = (MappedRecord)request;
                if (mappedRequest.size() != this.expectedRequest.size()) {
                    return false;
                }
                for (Object nextKey : mappedRequest.keySet()) {
                    Object expectedValue;
                    Object actualValue = mappedRequest.get(nextKey);
                    if (this.areObjectsEquals(actualValue, expectedValue = this.expectedRequest.get(nextKey))) continue;
                    return false;
                }
                return true;
            }
            catch (Exception exc) {
                throw new NestedApplicationException(exc);
            }
        }
        return false;
    }

    private boolean areObjectsEquals(Object object1, Object object2) {
        if (null == object1 && null == object2) {
            return true;
        }
        if (null == object1) {
            return false;
        }
        return object1.equals(object2);
    }

    private boolean isResponseAcceptable(Record response) {
        return null == response || response instanceof MappedRecord;
    }

    private boolean isResponseClassAcceptable(Class responseClass) {
        return null == responseClass || MappedRecord.class.isAssignableFrom(responseClass);
    }

    public Record execute(InteractionSpec interactionSpec, Record actualRequest) throws ResourceException {
        if (!this.canHandle(interactionSpec, actualRequest, null)) {
            return null;
        }
        if (null != this.responseRecord) {
            return this.responseRecord;
        }
        MockMappedRecord response = null;
        try {
            response = null == this.responseClass ? new MockMappedRecord() : (MappedRecord)this.responseClass.newInstance();
            if (null != this.responseData) {
                response.putAll(this.responseData);
            }
        }
        catch (Exception exc) {
            ResourceException resExc = new ResourceException("execute() failed");
            resExc.setLinkedException(exc);
            throw resExc;
        }
        return response;
    }

    public boolean execute(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) throws ResourceException {
        if (!this.canHandle(interactionSpec, actualRequest, actualResponse)) {
            return false;
        }
        try {
            if (null != this.responseData && null != actualResponse) {
                ((MappedRecord)actualResponse).clear();
                ((MappedRecord)actualResponse).putAll(this.responseData);
            }
        }
        catch (Exception exc) {
            ResourceException resExc = new ResourceException("execute() failed");
            resExc.setLinkedException(exc);
            throw resExc;
        }
        return true;
    }
}

