/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.connector;

import com.mockrunner.connector.InteractionImplementor;
import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;

public class WSIFInteraction
implements InteractionImplementor {
    private boolean enabled;
    private String isClassName;
    private String requestPartName;
    private Object requestPart;
    private String responsePartName;
    private Object responsePart;

    public WSIFInteraction(String isClassName, String requestPartName, Object requestPart, String responsePartName, Object responsePart) {
        this.isClassName = isClassName;
        this.requestPartName = requestPartName;
        this.requestPart = requestPart;
        this.responsePartName = responsePartName;
        this.responsePart = responsePart;
        this.enabled = true;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean canHandle(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) {
        if (!this.enabled) {
            return false;
        }
        Class specClass = this.getClassNamed(interactionSpec.getClass(), this.isClassName);
        if (specClass != null) {
            try {
                Object map2;
                Object[] elementsArgs;
                Object map1;
                Class[] elementsParams;
                Method elements;
                Object[] gopArgs;
                Object o1;
                Class[] gopParams;
                Method gop;
                Class wsifMessageClass = this.getClassNamed(actualRequest.getClass(), "org.apache.wsif.base.WSIFDefaultMessage");
                Class wsifFormatPartClass = this.getClassNamed(this.requestPart.getClass(), "com.ibm.wsif.format.jca.WSIFFormatPartImpl");
                if (wsifMessageClass != null && wsifFormatPartClass != null && (gop = wsifMessageClass.getMethod("getObjectPart", gopParams = new Class[]{String.class})) != null && (o1 = gop.invoke((Object)actualRequest, gopArgs = new Object[]{this.requestPartName})) != null && (elements = wsifFormatPartClass.getMethod("elements", elementsParams = new Class[0])) != null && (map1 = elements.invoke(this.requestPart, elementsArgs = new Object[0])).equals(map2 = elements.invoke(o1, elementsArgs))) {
                    return true;
                }
            }
            catch (Exception exc) {
                return false;
            }
        }
        return false;
    }

    public Record execute(InteractionSpec interactionSpec, Record actualRequest) throws ResourceException {
        throw new RuntimeException(this.getClass().getName() + " does not implement public Record execute(InteractionSpec, Record)");
    }

    public boolean execute(InteractionSpec interactionSpec, Record actualRequest, Record actualResponse) throws ResourceException {
        if (!this.canHandle(interactionSpec, actualRequest, actualResponse)) {
            return false;
        }
        try {
            Class wsifMessageClass = this.getClassNamed(actualRequest.getClass(), "org.apache.wsif.base.WSIFDefaultMessage");
            Class[] sopParams = new Class[]{String.class, Object.class};
            Method sop = wsifMessageClass.getMethod("setObjectPart", sopParams);
            if (sop != null) {
                Object[] sopArgs = new Object[]{this.responsePartName, this.responsePart};
                sop.invoke((Object)actualResponse, sopArgs);
                return true;
            }
        }
        catch (Exception exc) {
            ResourceException resExc = new ResourceException("execute() failed");
            resExc.setLinkedException(exc);
            throw resExc;
        }
        return false;
    }

    private Class getClassNamed(Class cl, String className) {
        if (cl == null) {
            return null;
        }
        if (cl.getName().equals(className)) {
            return cl;
        }
        Class<?>[] classes = cl.getDeclaredClasses();
        for (int current = 0; current < classes.length; ++current) {
            Class<?> c = classes[current];
            if (!className.equals(c.getName())) continue;
            return c;
        }
        return this.getClassNamed(cl.getSuperclass(), className);
    }
}

