/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.connector;

import com.mockrunner.example.connector.Person;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;

public class PersonSearchDAO {
    private ConnectionFactory connectionFactory;

    public PersonSearchDAO() {
        try {
            InitialContext context = new InitialContext();
            this.connectionFactory = (ConnectionFactory)context.lookup("java:ra/cics/ConnectionFactory");
        }
        catch (NamingException exc) {
            throw new RuntimeException("Failed to create ConnectionFactory " + exc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Person findPersonById(String id) {
        Connection connection = null;
        Person request = new Person();
        request.setId(id);
        Person response = new Person();
        try {
            connection = this.connectionFactory.getConnection();
            Interaction interaction = connection.createInteraction();
            ECIInteractionSpec interactionSpec = new ECIInteractionSpec();
            interactionSpec.setFunctionName("PER3AC");
            interactionSpec.setInteractionVerb(1);
            interactionSpec.setCommareaLength(32);
            interaction.execute((InteractionSpec)interactionSpec, (Record)request, (Record)response);
        }
        catch (ResourceException exc) {
            exc.printStackTrace();
        }
        finally {
            try {
                if (null != connection) {
                    connection.close();
                }
            }
            catch (ResourceException exc) {
                exc.printStackTrace();
            }
        }
        return response;
    }

    private class ECIInteractionSpec
    implements InteractionSpec {
        private String functionName;
        private int commareaLength;
        private int interactionVerb;

        private ECIInteractionSpec() {
        }

        public int getCommareaLength() {
            return this.commareaLength;
        }

        public void setCommareaLength(int commareaLength) {
            this.commareaLength = commareaLength;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public int getInteractionVerb() {
            return this.interactionVerb;
        }

        public void setInteractionVerb(int interactionVerb) {
            this.interactionVerb = interactionVerb;
        }
    }
}

