/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen;

import com.mockrunner.gen.proc.GeneratorUtil;
import com.mockrunner.gen.proc.JavaLineProcessor;
import com.mockrunner.util.common.StreamUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class VersionGenerator {
    private Map processorMap;
    private String generatorName;
    private String rootTargetDir;
    private String rootSourceDir;
    private String[] processedPackages;

    public VersionGenerator(Map processorMap, String generatorName, String rootTargetDir, String rootSourceDir, String[] processedPackages) {
        this.processorMap = processorMap;
        this.generatorName = generatorName;
        this.rootTargetDir = rootTargetDir;
        this.rootSourceDir = rootSourceDir;
        this.processedPackages = processedPackages;
    }

    public void doSynchronize() throws Exception {
        System.out.println("Start processing for " + this.generatorName);
        GeneratorUtil util = new GeneratorUtil();
        this.deleteContent(new File(this.rootTargetDir));
        HashMap srcMap = new HashMap();
        for (int ii = 0; ii < this.processedPackages.length; ++ii) {
            File currentFile = new File(this.rootSourceDir + "/" + this.processedPackages[ii]);
            util.addJavaSrcFiles(this.rootSourceDir, currentFile, srcMap);
        }
        this.processFiles(this.processorMap, srcMap, this.rootTargetDir);
        System.out.println("Sucessfully finished processing for " + this.generatorName);
    }

    private void deleteContent(File file) {
        if (!file.isDirectory()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            for (int ii = 0; ii < files.length; ++ii) {
                this.deleteContent(files[ii]);
            }
            file.delete();
        }
    }

    private void processFiles(Map procMap, Map map, String targetDir) throws FileNotFoundException, IOException {
        for (String currentFileName : map.keySet()) {
            File currentSourceFile = (File)map.get(currentFileName);
            File currentDestFile = new File(targetDir + currentFileName);
            String sourceFileContent = StreamUtil.getReaderAsString(new FileReader(currentSourceFile));
            System.out.println("Processing file " + currentSourceFile);
            String processedFileContent = this.processFile(currentFileName, sourceFileContent, procMap);
            if (null == processedFileContent) continue;
            this.writeFileContent(processedFileContent, currentDestFile);
        }
    }

    private String processFile(String currentFileName, String fileContent, Map jdbcProcMap) {
        currentFileName = currentFileName.replace('\\', '.');
        currentFileName = currentFileName.replace('/', '.');
        currentFileName = currentFileName.substring(1);
        Object currentObject = jdbcProcMap.get(currentFileName = currentFileName.substring(0, currentFileName.length() - 5));
        if (null == currentObject) {
            return fileContent;
        }
        if (currentObject instanceof JavaLineProcessor) {
            return ((JavaLineProcessor)currentObject).process(fileContent);
        }
        if (currentObject instanceof Boolean) {
            if (!((Boolean)currentObject).booleanValue()) {
                return null;
            }
            return fileContent;
        }
        return null;
    }

    private void writeFileContent(String fileContent, File currentDestFile) throws FileNotFoundException, IOException {
        if (!currentDestFile.getParentFile().exists()) {
            currentDestFile.getParentFile().mkdirs();
        }
        System.out.println("Writing file " + currentDestFile);
        FileWriter currentDestFileWriter = new FileWriter(currentDestFile);
        currentDestFileWriter.write(fileContent);
        currentDestFileWriter.flush();
        currentDestFileWriter.close();
    }
}

