/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.connector.cci;

import com.mockrunner.mock.connector.cci.MockIndexedRecord;
import com.mockrunner.mock.connector.cci.MockMappedRecord;
import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;

public class MockRecordFactory
implements RecordFactory {
    private List indexedRecords = new ArrayList();
    private List mappedRecords = new ArrayList();

    public void resetIndexedRecords() {
        this.indexedRecords.clear();
    }

    public void resetMappedRecords() {
        this.mappedRecords.clear();
    }

    public int getNumberCreatedIndexedRecords() {
        return this.indexedRecords.size();
    }

    public int getNumberCreatedMappedRecords() {
        return this.mappedRecords.size();
    }

    public List getCreatedIndexedRecords() {
        return this.getCreatedRecords(null, false, this.indexedRecords);
    }

    public List getCreatedIndexedRecords(String recordName) {
        return this.getCreatedRecords(recordName, true, this.indexedRecords);
    }

    public List getCreatedMappedRecords() {
        return this.getCreatedRecords(null, false, this.mappedRecords);
    }

    public List getCreatedMappedRecords(String recordName) {
        return this.getCreatedRecords(recordName, true, this.mappedRecords);
    }

    private List getCreatedRecords(String recordName, boolean recognizeRecordName, List recordWrapperList) {
        ArrayList<Record> result = new ArrayList<Record>();
        for (int ii = 0; ii < recordWrapperList.size(); ++ii) {
            RecordWrapper currentWrapper = (RecordWrapper)recordWrapperList.get(ii);
            if (!recognizeRecordName) {
                result.add(currentWrapper.getRecord());
                continue;
            }
            this.addRecordIfMatching(recordName, result, currentWrapper);
        }
        return result;
    }

    private void addRecordIfMatching(String recordName, List result, RecordWrapper currentWrapper) {
        if (null == recordName) {
            if (null == currentWrapper.getRecordName()) {
                result.add(currentWrapper.getRecord());
            }
        } else if (recordName.equals(currentWrapper.getRecordName())) {
            result.add(currentWrapper.getRecord());
        }
    }

    public IndexedRecord createIndexedRecord(String recordName) throws ResourceException {
        MockIndexedRecord record = new MockIndexedRecord(recordName);
        this.indexedRecords.add(new RecordWrapper(recordName, record));
        return record;
    }

    public MappedRecord createMappedRecord(String recordName) throws ResourceException {
        MockMappedRecord record = new MockMappedRecord(recordName);
        this.mappedRecords.add(new RecordWrapper(recordName, record));
        return record;
    }

    private class RecordWrapper {
        private String recordName;
        private Record record;

        public RecordWrapper(String recordName, Record record) {
            this.recordName = recordName;
            this.record = record;
        }

        public String getRecordName() {
            return this.recordName;
        }

        public Record getRecord() {
            return this.record;
        }
    }
}

