/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.connector.ConnectorTestModule;
import com.mockrunner.mock.connector.cci.ConnectorMockObjectFactory;
import java.util.List;
import javax.resource.cci.Interaction;
import javax.resource.cci.Record;
import junit.framework.TestCase;

public class ConnectorTestModuleTest
extends TestCase {
    private ConnectorMockObjectFactory mockFactory;
    private ConnectorTestModule module;

    protected void setUp() throws Exception {
        this.mockFactory = new ConnectorMockObjectFactory();
        this.module = new ConnectorTestModule(this.mockFactory);
    }

    protected void tearDown() throws Exception {
        this.mockFactory = null;
        this.module = null;
    }

    private void createIndexedRecord(String name) throws Exception {
        this.mockFactory.getMockConnectionFactory().getRecordFactory().createIndexedRecord(name);
    }

    private void createMappedRecord(String name) throws Exception {
        this.mockFactory.getMockConnectionFactory().getRecordFactory().createMappedRecord(name);
    }

    public void testGetInteractionList() throws Exception {
        Interaction interaction1 = this.mockFactory.getMockConnection().createInteraction();
        Interaction interaction2 = this.mockFactory.getMockConnection().createInteraction();
        List interactionList = this.module.getInteractionList();
        ConnectorTestModuleTest.assertEquals((int)2, (int)interactionList.size());
        ConnectorTestModuleTest.assertEquals((Object)interaction1, interactionList.get(0));
        ConnectorTestModuleTest.assertEquals((Object)interaction2, interactionList.get(1));
    }

    public void testVerifyConnectionClosed() throws Exception {
        try {
            this.module.verifyConnectionClosed();
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
        this.mockFactory.getMockConnection().close();
        this.module.verifyConnectionClosed();
    }

    public void testVerifyInteractionClosed() throws Exception {
        Interaction interaction1 = this.mockFactory.getMockConnection().createInteraction();
        Interaction interaction2 = this.mockFactory.getMockConnection().createInteraction();
        Interaction interaction3 = this.mockFactory.getMockConnection().createInteraction();
        try {
            this.module.verifyAllInteractionsClosed();
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyInteractionClosed(3);
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyInteractionClosed(2);
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        interaction3.close();
        this.module.verifyInteractionClosed(2);
        try {
            this.module.verifyAllInteractionsClosed();
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        interaction1.close();
        interaction2.close();
        this.module.verifyInteractionClosed(0);
        this.module.verifyInteractionClosed(1);
        this.module.verifyAllInteractionsClosed();
    }

    public void testGetCreatedIndexedRecords() throws Exception {
        this.createIndexedRecord("indexedRecord");
        this.createIndexedRecord("indexedRecord");
        this.createIndexedRecord("anotherIndexedRecord");
        List list = this.module.getCreatedIndexedRecords();
        ConnectorTestModuleTest.assertEquals((int)3, (int)list.size());
        ConnectorTestModuleTest.assertEquals((String)"indexedRecord", (String)((Record)list.get(0)).getRecordName());
        ConnectorTestModuleTest.assertEquals((String)"indexedRecord", (String)((Record)list.get(1)).getRecordName());
        ConnectorTestModuleTest.assertEquals((String)"anotherIndexedRecord", (String)((Record)list.get(2)).getRecordName());
        list = this.module.getCreatedIndexedRecords("indexedRecord");
        ConnectorTestModuleTest.assertEquals((int)2, (int)list.size());
        ConnectorTestModuleTest.assertEquals((String)"indexedRecord", (String)((Record)list.get(0)).getRecordName());
        ConnectorTestModuleTest.assertEquals((String)"indexedRecord", (String)((Record)list.get(1)).getRecordName());
        list = this.module.getCreatedIndexedRecords("anotherIndexedRecord");
        ConnectorTestModuleTest.assertEquals((int)1, (int)list.size());
        ConnectorTestModuleTest.assertEquals((String)"anotherIndexedRecord", (String)((Record)list.get(0)).getRecordName());
        list = this.module.getCreatedIndexedRecords("xyz");
        ConnectorTestModuleTest.assertEquals((int)0, (int)list.size());
    }

    public void testGetCreatedMappedRecords() throws Exception {
        this.createMappedRecord("mappedRecord");
        this.createMappedRecord("mappedRecord");
        this.createMappedRecord("anotherMappedRecord");
        List list = this.module.getCreatedMappedRecords();
        ConnectorTestModuleTest.assertEquals((int)3, (int)list.size());
        ConnectorTestModuleTest.assertEquals((String)"mappedRecord", (String)((Record)list.get(0)).getRecordName());
        ConnectorTestModuleTest.assertEquals((String)"mappedRecord", (String)((Record)list.get(1)).getRecordName());
        ConnectorTestModuleTest.assertEquals((String)"anotherMappedRecord", (String)((Record)list.get(2)).getRecordName());
        list = this.module.getCreatedMappedRecords("mappedRecord");
        ConnectorTestModuleTest.assertEquals((int)2, (int)list.size());
        ConnectorTestModuleTest.assertEquals((String)"mappedRecord", (String)((Record)list.get(0)).getRecordName());
        ConnectorTestModuleTest.assertEquals((String)"mappedRecord", (String)((Record)list.get(1)).getRecordName());
        list = this.module.getCreatedMappedRecords("anotherMappedRecord");
        ConnectorTestModuleTest.assertEquals((int)1, (int)list.size());
        ConnectorTestModuleTest.assertEquals((String)"anotherMappedRecord", (String)((Record)list.get(0)).getRecordName());
        list = this.module.getCreatedMappedRecords("xyz");
        ConnectorTestModuleTest.assertEquals((int)0, (int)list.size());
    }

    public void testVerifyCreatedIndexedRecords() throws Exception {
        this.createIndexedRecord("indexedRecord");
        this.createIndexedRecord("indexedRecord");
        this.createIndexedRecord("anotherIndexedRecord");
        this.module.verifyNumberCreatedIndexedRecords(3);
        this.module.verifyNumberCreatedIndexedRecords("indexedRecord", 2);
        this.module.verifyNumberCreatedIndexedRecords("anotherIndexedRecord", 1);
        this.module.verifyNumberCreatedMappedRecords("xyz", 0);
        try {
            this.module.verifyNumberCreatedIndexedRecords("indexedRecord", 3);
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyNumberCreatedIndexedRecords(1);
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }

    public void testVerifyNumberCreatedMappedRecords() throws Exception {
        this.createMappedRecord("mappedRecord");
        this.createMappedRecord("anotherMappedRecord");
        this.createMappedRecord("anotherMappedRecord");
        this.createMappedRecord("anotherMappedRecord");
        this.module.verifyNumberCreatedMappedRecords(4);
        this.module.verifyNumberCreatedMappedRecords("mappedRecord", 1);
        this.module.verifyNumberCreatedMappedRecords("anotherMappedRecord", 3);
        this.module.verifyNumberCreatedMappedRecords("xyz", 0);
        try {
            this.module.verifyNumberCreatedMappedRecords("xyz", 1);
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyNumberCreatedMappedRecords(3);
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }

    public void testVerifyLocalTransaction() throws Exception {
        this.module.verifyLocalTransactionNotCommitted();
        this.module.verifyLocalTransactionNotRolledBack();
        try {
            this.module.verifyLocalTransactionCommitted();
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        try {
            this.module.verifyLocalTransactionRolledBack();
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        this.mockFactory.getMockConnection().getLocalTransaction().begin();
        this.mockFactory.getMockConnection().getLocalTransaction().commit();
        this.module.verifyLocalTransactionCommitted();
        this.module.verifyLocalTransactionNotRolledBack();
        try {
            this.module.verifyLocalTransactionNotCommitted();
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException exc) {
            // empty catch block
        }
        this.mockFactory.getMockConnection().getLocalTransaction().begin();
        this.mockFactory.getMockConnection().getLocalTransaction().rollback();
        this.module.verifyLocalTransactionNotCommitted();
        this.module.verifyLocalTransactionRolledBack();
        try {
            this.module.verifyLocalTransactionCommitted();
            ConnectorTestModuleTest.fail();
        }
        catch (VerifyFailedException verifyFailedException) {
            // empty catch block
        }
    }
}

