/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.connector.GenericFailureInteraction;
import com.mockrunner.connector.InteractionHandler;
import javax.resource.ResourceException;
import junit.framework.TestCase;

public class GenericFailureInteractionTest
extends TestCase {
    private InteractionHandler interactionHandler;

    protected void setUp() throws Exception {
        this.interactionHandler = new InteractionHandler();
    }

    protected void tearDown() throws Exception {
        this.interactionHandler = null;
    }

    public void testEnableAndDisable() throws Exception {
        GenericFailureInteraction interaction = new GenericFailureInteraction();
        GenericFailureInteractionTest.assertTrue((boolean)interaction.canHandle(null, null, null));
        interaction.disable();
        GenericFailureInteractionTest.assertFalse((boolean)interaction.canHandle(null, null, null));
        interaction.enable();
        GenericFailureInteractionTest.assertTrue((boolean)interaction.canHandle(null, null, null));
        this.interactionHandler.addImplementor(interaction);
        try {
            this.interactionHandler.execute(null, null);
            GenericFailureInteractionTest.fail();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        interaction.disable();
        this.interactionHandler.execute(null, null, null);
    }

    public void testThrowsException() throws Exception {
        GenericFailureInteraction interaction = new GenericFailureInteraction();
        this.interactionHandler.addImplementor(interaction);
        try {
            this.interactionHandler.execute(null, null, null);
            GenericFailureInteractionTest.fail();
        }
        catch (ResourceException exc) {
            // empty catch block
        }
        interaction.setThrowException(false);
        GenericFailureInteractionTest.assertFalse((boolean)this.interactionHandler.execute(null, null, null));
        GenericFailureInteractionTest.assertNull((Object)this.interactionHandler.execute(null, null));
        interaction.setThrowException(true);
        try {
            this.interactionHandler.execute(null, null);
            GenericFailureInteractionTest.fail();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public void testExceptionType() throws Exception {
        ResourceException setExc = new ResourceException();
        Exception nested = new Exception();
        setExc.setLinkedException(nested);
        GenericFailureInteraction interaction = new GenericFailureInteraction(true, setExc);
        this.interactionHandler.addImplementor(interaction);
        try {
            this.interactionHandler.execute(null, null, null);
            GenericFailureInteractionTest.fail();
        }
        catch (ResourceException exc) {
            GenericFailureInteractionTest.assertSame((Object)((Object)setExc), (Object)((Object)exc));
            GenericFailureInteractionTest.assertSame((Object)nested, (Object)exc.getLinkedException());
        }
    }
}

