/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.connector;

import com.mockrunner.mock.connector.cci.MockConnection;
import com.mockrunner.mock.connector.cci.MockConnectionMetaData;
import com.mockrunner.mock.connector.cci.MockInteraction;
import com.mockrunner.mock.connector.cci.MockLocalTransaction;
import com.mockrunner.mock.connector.cci.MockResultSetInfo;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import junit.framework.TestCase;

public class MockConnectionTest
extends TestCase {
    private MockConnection connection;

    protected void setUp() throws Exception {
        this.connection = new MockConnection();
    }

    protected void tearDown() throws Exception {
        this.connection = null;
    }

    public void testGetInteractionList() throws Exception {
        Interaction interaction1 = this.connection.createInteraction();
        Interaction interaction2 = this.connection.createInteraction();
        Interaction interaction3 = this.connection.createInteraction();
        List interactionList = this.connection.getInteractionList();
        MockConnectionTest.assertEquals((int)3, (int)interactionList.size());
        MockConnectionTest.assertEquals((Object)interaction1, interactionList.get(0));
        MockConnectionTest.assertEquals((Object)interaction2, interactionList.get(1));
        MockConnectionTest.assertEquals((Object)interaction3, interactionList.get(2));
        try {
            interactionList.add(new MockInteraction(this.connection));
            MockConnectionTest.fail();
        }
        catch (RuntimeException exc) {
            // empty catch block
        }
    }

    public void testClose() throws Exception {
        MockInteraction interaction1 = (MockInteraction)this.connection.createInteraction();
        MockInteraction interaction2 = (MockInteraction)this.connection.createInteraction();
        MockInteraction interaction3 = (MockInteraction)this.connection.createInteraction();
        this.connection.close();
        MockConnectionTest.assertTrue((boolean)this.connection.isClosed());
        MockConnectionTest.assertTrue((boolean)interaction1.isClosed());
        MockConnectionTest.assertTrue((boolean)interaction2.isClosed());
        MockConnectionTest.assertTrue((boolean)interaction3.isClosed());
    }

    public void testGetMetaData() throws Exception {
        MockConnectionTest.assertTrue((boolean)(this.connection.getMetaData() instanceof MockConnectionMetaData));
        MockConnectionMetaData metaData = new MockConnectionMetaData(){};
        this.connection.setMetaData(metaData);
        MockConnectionTest.assertSame((Object)metaData, (Object)this.connection.getMetaData());
    }

    public void testGetResultSetInfo() throws Exception {
        MockConnectionTest.assertTrue((boolean)(this.connection.getResultSetInfo() instanceof MockResultSetInfo));
        MockResultSetInfo resultSetInfo = new MockResultSetInfo(){};
        this.connection.setResultSetInfo(resultSetInfo);
        MockConnectionTest.assertSame((Object)resultSetInfo, (Object)this.connection.getResultSetInfo());
    }

    public void testGetLocalTransaction() throws Exception {
        MockConnectionTest.assertTrue((boolean)(this.connection.getLocalTransaction() instanceof MockLocalTransaction));
        MockLocalTransaction localTransaction = new MockLocalTransaction(){};
        this.connection.setLocalTransaction(localTransaction);
        MockConnectionTest.assertSame((Object)localTransaction, (Object)this.connection.getLocalTransaction());
        MockConnectionTest.assertSame((Object)localTransaction, (Object)this.connection.getMockLocalTransaction());
        TestLocalTransaction otherLocalTransaction = new TestLocalTransaction(){};
        this.connection.setLocalTransaction(otherLocalTransaction);
        MockConnectionTest.assertSame((Object)otherLocalTransaction, (Object)this.connection.getLocalTransaction());
        MockConnectionTest.assertNull((Object)this.connection.getMockLocalTransaction());
    }

    private class TestLocalTransaction
    implements LocalTransaction {
        private TestLocalTransaction() {
        }

        public void begin() throws ResourceException {
        }

        public void commit() throws ResourceException {
        }

        public void rollback() throws ResourceException {
        }
    }
}

