/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.gen;

import com.mockrunner.gen.proc.JavaClassGenerator;
import com.mockrunner.util.common.ClassUtil;
import com.mockrunner.util.common.CollectionUtil;
import com.mockrunner.util.web.XmlUtil;
import java.beans.IntrospectionException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import junit.framework.TestCase;

public class JavaClassGeneratorTest
extends TestCase {
    private static final String NL = System.getProperty("line.separator");
    private JavaClassGenerator generator;

    protected void setUp() throws Exception {
        super.setUp();
        this.generator = new JavaClassGenerator();
    }

    public void testGenerate() {
        this.generator.setClassName("MyClass");
        this.generator.setAbstract(true);
        String[] commentLines = new String[]{"This is", "a comment"};
        this.generator.setClassComment(commentLines);
        this.generator.setPackage(((Object)((Object)this)).getClass().getPackage());
        this.generator.setSuperClass(ClassUtil.class);
        this.generator.addInterfaceImplementation(Map.class);
        this.generator.addInterfaceImplementation(List.class);
        this.generator.addImport(XmlUtil.class);
        this.generator.addImport(HttpServlet.class);
        this.generator.addImport(TestCase.class);
        this.generator.addMemberDeclaration(XmlUtil.class, "util");
        this.generator.addMemberDeclaration(String.class, "name");
        this.generator.addConstructorDeclaration();
        JavaClassGenerator.ConstructorDeclaration constructor = new JavaClassGenerator.ConstructorDeclaration();
        constructor.setCommentLines(new String[]{"A", "comment"});
        constructor.setArguments(new Class[]{String.class, JavaClassGeneratorTest.class});
        constructor.setArgumentNames(new String[]{"string1"});
        constructor.setExceptions(new Class[]{Exception.class});
        constructor.setCodeLines(new String[]{"Line1", "Line2"});
        this.generator.addConstructorDeclaration(constructor);
        JavaClassGenerator.MethodDeclaration method1 = new JavaClassGenerator.MethodDeclaration();
        method1.setName("aMethod");
        method1.setCommentLines(new String[]{"Another", "comment"});
        method1.setCodeLines(new String[]{"Line1"});
        this.generator.addMethodDeclaration(method1);
        JavaClassGenerator.MethodDeclaration method2 = new JavaClassGenerator.MethodDeclaration();
        method2.setName("anotherMethod");
        method2.setReturnType(CollectionUtil.class);
        method2.setArguments(new Class[]{String.class, Double.TYPE});
        method2.setArgumentNames(new String[]{"string1"});
        this.generator.addMethodDeclaration(method2);
        JavaClassGenerator.MethodDeclaration method3 = new JavaClassGenerator.MethodDeclaration();
        method3.setName("thirdMethod");
        method3.setReturnType(Integer.TYPE);
        method3.setCommentLines(new String[]{"Comment"});
        method3.setExceptions(new Class[]{IntrospectionException.class, RuntimeException.class});
        method3.setCodeLines(new String[]{"Line1", "Line2"});
        this.generator.addMethodDeclaration(method3);
        JavaClassGenerator.MethodDeclaration method4 = new JavaClassGenerator.MethodDeclaration();
        method4.setName("fourthMethod");
        method4.setReturnType(int[].class);
        method4.setArguments(new Class[]{String.class, URL[][].class, Double[].class, boolean[].class});
        this.generator.addMethodDeclaration(method4);
        JavaClassGeneratorTest.assertEquals((String)this.getExpected(), (String)this.generator.generate());
    }

    private String getExpected() {
        return "package com.mockrunner.test.gen;" + NL + NL + "import java.beans.IntrospectionException;" + NL + "import java.net.URL;" + NL + "import java.util.List;" + NL + "import java.util.Map;" + NL + NL + "import javax.servlet.http.HttpServlet;" + NL + NL + "import junit.framework.TestCase;" + NL + NL + "import com.mockrunner.util.common.ClassUtil;" + NL + "import com.mockrunner.util.common.CollectionUtil;" + NL + "import com.mockrunner.util.web.XmlUtil;" + NL + NL + "/**" + NL + " * This is" + NL + " * a comment" + NL + " */" + NL + "public abstract class MyClass extends ClassUtil implements Map, List" + NL + "{" + NL + "    private XmlUtil util;" + NL + "    private String name;" + NL + NL + "    public MyClass()" + NL + "    {" + NL + NL + "    }" + NL + NL + "    /**" + NL + "     * A" + NL + "     * comment" + NL + "     */" + NL + "    public MyClass(String string1, JavaClassGeneratorTest javaClassGeneratorTest) throws Exception" + NL + "    {" + NL + "        Line1" + NL + "        Line2" + NL + "    }" + NL + NL + "    /**" + NL + "     * Another" + NL + "     * comment" + NL + "     */" + NL + "    public void aMethod()" + NL + "    {" + NL + "        Line1" + NL + "    }" + NL + NL + "    public CollectionUtil anotherMethod(String string1, double doubleValue)" + NL + "    {" + NL + NL + "    }" + NL + NL + "    /**" + NL + "     * Comment" + NL + "     */" + NL + "    public int thirdMethod() throws IntrospectionException, RuntimeException" + NL + "    {" + NL + "        Line1" + NL + "        Line2" + NL + "    }" + NL + NL + "    public int[] fourthMethod(String string, URL[][] urls, Double[] doubleValues, boolean[] booleanValues)" + NL + "    {" + NL + NL + "    }" + NL + "}";
    }
}

