/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockJspWriter;
import java.io.IOException;
import java.io.StringWriter;
import junit.framework.TestCase;

public class MockJspWriterTest
extends TestCase {
    public void testWithDefaultWriter() throws Exception {
        MockJspWriter writer = new MockJspWriter();
        writer.print("test1");
        writer.clear();
        writer.print("test2");
        writer.clearBuffer();
        writer.print("test3");
        MockJspWriterTest.assertEquals((String)"test3", (String)writer.getOutputAsString());
    }

    public void testWithProvidedWriter() throws Exception {
        StringWriter providedWriter = new StringWriter();
        MockJspWriter writer = new MockJspWriter(providedWriter);
        writer.print("test1");
        try {
            writer.clear();
            MockJspWriterTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        writer.print("test2");
        writer.clearBuffer();
        writer.print("test3");
        MockJspWriterTest.assertEquals((String)"", (String)writer.getOutputAsString());
        writer.flush();
        MockJspWriterTest.assertEquals((String)"test1test2test3", (String)providedWriter.toString());
    }

    public void testWithProvidedResponse() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockJspWriter writer = new MockJspWriter(response);
        writer.print("test1");
        MockJspWriterTest.assertEquals((String)"test1", (String)writer.getOutputAsString());
        MockJspWriterTest.assertEquals((String)"test1", (String)response.getOutputStreamContent());
        response.getWriter().print("test2");
        MockJspWriterTest.assertEquals((String)"test1test2", (String)writer.getOutputAsString());
        MockJspWriterTest.assertEquals((String)"test1test2", (String)response.getOutputStreamContent());
        writer.clear();
        MockJspWriterTest.assertEquals((String)"", (String)writer.getOutputAsString());
        MockJspWriterTest.assertEquals((String)"", (String)response.getOutputStreamContent());
        writer.print("test1");
        writer.clearBuffer();
        MockJspWriterTest.assertEquals((String)"", (String)writer.getOutputAsString());
        MockJspWriterTest.assertEquals((String)"", (String)response.getOutputStreamContent());
    }
}

