/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockFilterChain;
import com.mockrunner.mock.web.MockFilterConfig;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockJspFactory;
import com.mockrunner.mock.web.MockPageContext;
import com.mockrunner.mock.web.MockServletConfig;
import com.mockrunner.mock.web.MockServletContext;
import com.mockrunner.mock.web.WebMockObjectFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import junit.framework.TestCase;

public class WebMockObjectFactoryTest
extends TestCase {
    public void testDifferentMockObjects() {
        WebMockObjectFactory factory1 = new WebMockObjectFactory();
        WebMockObjectFactory factory2 = new WebMockObjectFactory();
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockRequest(), (Object)factory2.getMockRequest());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockResponse(), (Object)factory2.getMockResponse());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockSession(), (Object)factory2.getMockSession());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockServletConfig(), (Object)factory2.getMockServletConfig());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockServletContext(), (Object)factory2.getMockServletContext());
    }

    public void testMockObjectsWithSameContext() {
        WebMockObjectFactory factory1 = new WebMockObjectFactory();
        WebMockObjectFactory factory2 = new WebMockObjectFactory(factory1);
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockRequest(), (Object)factory2.getMockRequest());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockResponse(), (Object)factory2.getMockResponse());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockSession(), (Object)factory2.getMockSession());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockServletConfig(), (Object)factory2.getMockServletConfig());
        WebMockObjectFactoryTest.assertSame((Object)factory1.getMockServletContext(), (Object)factory2.getMockServletContext());
    }

    public void testMockObjectsWithSameSessionAndContext() {
        WebMockObjectFactory factory1 = new WebMockObjectFactory();
        WebMockObjectFactory factory2 = new WebMockObjectFactory(factory1, false);
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockRequest(), (Object)factory2.getMockRequest());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockResponse(), (Object)factory2.getMockResponse());
        WebMockObjectFactoryTest.assertSame((Object)factory1.getMockSession(), (Object)factory2.getMockSession());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockServletConfig(), (Object)factory2.getMockServletConfig());
        WebMockObjectFactoryTest.assertSame((Object)factory1.getMockServletContext(), (Object)factory2.getMockServletContext());
        factory2 = new WebMockObjectFactory(factory1, true);
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockRequest(), (Object)factory2.getMockRequest());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockResponse(), (Object)factory2.getMockResponse());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockSession(), (Object)factory2.getMockSession());
        WebMockObjectFactoryTest.assertNotSame((Object)factory1.getMockServletConfig(), (Object)factory2.getMockServletConfig());
        WebMockObjectFactoryTest.assertSame((Object)factory1.getMockServletContext(), (Object)factory2.getMockServletContext());
    }

    public void testSetDefaultJspFactory() {
        WebMockObjectFactory factory = new WebMockObjectFactory();
        WebMockObjectFactoryTest.assertSame((Object)((Object)factory.getMockJspFactory()), (Object)JspFactory.getDefaultFactory());
        WebMockObjectFactoryTest.assertSame((Object)factory.getJspFactory(), (Object)JspFactory.getDefaultFactory());
        WebMockObjectFactoryTest.assertSame((Object)((Object)factory.getMockPageContext()), (Object)factory.getMockJspFactory().getPageContext());
        TestJspFactory testJspFactory = new TestJspFactory();
        factory.setDefaultJspFactory(testJspFactory);
        WebMockObjectFactoryTest.assertNull((Object)((Object)factory.getMockJspFactory()));
        WebMockObjectFactoryTest.assertSame((Object)((Object)testJspFactory), (Object)JspFactory.getDefaultFactory());
        WebMockObjectFactoryTest.assertSame((Object)factory.getJspFactory(), (Object)JspFactory.getDefaultFactory());
        MockJspFactory testMockJspFactory = new MockJspFactory(){};
        factory.setDefaultJspFactory(testMockJspFactory);
        WebMockObjectFactoryTest.assertSame((Object)((Object)testMockJspFactory), (Object)JspFactory.getDefaultFactory());
        WebMockObjectFactoryTest.assertSame((Object)((Object)factory.getMockJspFactory()), (Object)JspFactory.getDefaultFactory());
        WebMockObjectFactoryTest.assertSame((Object)factory.getJspFactory(), (Object)JspFactory.getDefaultFactory());
        WebMockObjectFactoryTest.assertSame((Object)((Object)factory.getMockPageContext()), (Object)factory.getMockJspFactory().getPageContext());
        factory.setDefaultJspFactory(null);
        WebMockObjectFactoryTest.assertNull((Object)((Object)factory.getMockJspFactory()));
        WebMockObjectFactoryTest.assertNull((Object)factory.getJspFactory());
    }

    public void testAddRequestWrapper() {
        WebMockObjectFactory factory = new WebMockObjectFactory();
        factory.getMockRequest().setupAddParameter("test", "test");
        factory.addRequestWrapper(HttpServletRequestWrapper.class);
        HttpServletRequest request = factory.getWrappedRequest();
        WebMockObjectFactoryTest.assertTrue((boolean)(request instanceof HttpServletRequestWrapper));
        WebMockObjectFactoryTest.assertEquals((String)"test", (String)request.getParameter("test"));
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)factory.getWrappedRequest();
        WebMockObjectFactoryTest.assertSame((Object)factory.getMockRequest(), (Object)requestWrapper.getRequest());
    }

    public void testAddResponseWrapper() throws Exception {
        WebMockObjectFactory factory = new WebMockObjectFactory();
        factory.addResponseWrapper(HttpServletResponseWrapper.class);
        HttpServletResponse response = factory.getWrappedResponse();
        WebMockObjectFactoryTest.assertTrue((boolean)(response instanceof HttpServletResponseWrapper));
        response.getWriter().print("test");
        response.getWriter().flush();
        WebMockObjectFactoryTest.assertEquals((String)"test", (String)factory.getMockResponse().getOutputStreamContent());
        HttpServletResponseWrapper responseWrapper = (HttpServletResponseWrapper)factory.getWrappedResponse();
        WebMockObjectFactoryTest.assertSame((Object)factory.getMockResponse(), (Object)responseWrapper.getResponse());
    }

    public void testAddRequestAndResponseWrapperClasses() {
        WebMockObjectFactory factory = new WebMockObjectFactory();
        factory.addRequestWrapper(TestRequestWrapper.class);
        WebMockObjectFactoryTest.assertTrue((boolean)(factory.getWrappedRequest() instanceof TestRequestWrapper));
        WebMockObjectFactoryTest.assertSame((Object)factory.getMockRequest(), (Object)((TestRequestWrapper)factory.getWrappedRequest()).getRequest());
        factory.addResponseWrapper(TestResponseWrapper.class);
        WebMockObjectFactoryTest.assertTrue((boolean)(factory.getWrappedResponse() instanceof TestResponseWrapper));
        WebMockObjectFactoryTest.assertSame((Object)factory.getMockResponse(), (Object)((TestResponseWrapper)factory.getWrappedResponse()).getResponse());
    }

    public void testRefresh() throws Exception {
        WebMockObjectFactory factory = new WebMockObjectFactory();
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper((HttpServletRequest)factory.getMockRequest());
        HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper((HttpServletResponse)factory.getMockResponse());
        factory.addRequestWrapper((HttpServletRequest)requestWrapper);
        factory.addResponseWrapper((HttpServletResponse)responseWrapper);
        MockPageContext pageContext = factory.getMockPageContext();
        WebMockObjectFactoryTest.assertSame((Object)factory.getMockRequest(), (Object)pageContext.getRequest());
        WebMockObjectFactoryTest.assertSame((Object)factory.getMockResponse(), (Object)pageContext.getResponse());
        factory.refresh();
        pageContext = factory.getMockPageContext();
        WebMockObjectFactoryTest.assertSame((Object)requestWrapper, (Object)pageContext.getRequest());
        WebMockObjectFactoryTest.assertSame((Object)responseWrapper, (Object)pageContext.getResponse());
        WebMockObjectFactoryTest.assertSame((Object)((Object)pageContext), (Object)factory.getMockJspFactory().getPageContext());
    }

    public void testOverrideCreate() {
        TestWebMockObjectFactory factory = new TestWebMockObjectFactory();
        WebMockObjectFactoryTest.assertNotSame(factory.getMockRequest().getClass(), MockHttpServletRequest.class);
        WebMockObjectFactoryTest.assertNotSame(factory.getMockResponse().getClass(), MockHttpServletResponse.class);
        WebMockObjectFactoryTest.assertNotSame(factory.getMockFilterChain().getClass(), MockFilterChain.class);
        WebMockObjectFactoryTest.assertNotSame(factory.getMockFilterConfig().getClass(), MockFilterConfig.class);
        WebMockObjectFactoryTest.assertNotSame(((Object)((Object)factory.getMockPageContext())).getClass(), MockPageContext.class);
        WebMockObjectFactoryTest.assertNotSame(factory.getMockServletConfig().getClass(), MockServletConfig.class);
        WebMockObjectFactoryTest.assertNotSame(factory.getMockServletContext().getClass(), MockServletContext.class);
        WebMockObjectFactoryTest.assertNotSame(factory.getMockSession().getClass(), MockHttpSession.class);
    }

    public static class TestJspFactory
    extends JspFactory {
        public JspEngineInfo getEngineInfo() {
            return null;
        }

        public JspApplicationContext getJspApplicationContext(ServletContext context) {
            return null;
        }

        public PageContext getPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int buffer, boolean autoflush) {
            return null;
        }

        public void releasePageContext(PageContext pageContext) {
        }
    }

    public static class TestWebMockObjectFactory
    extends WebMockObjectFactory {
        public MockFilterChain createMockFilterChain() {
            return new MockFilterChain(){};
        }

        public MockFilterConfig createMockFilterConfig() {
            return new MockFilterConfig(){};
        }

        public MockPageContext createMockPageContext() {
            return new MockPageContext(){};
        }

        public MockHttpServletRequest createMockRequest() {
            return new MockHttpServletRequest(){};
        }

        public MockHttpServletResponse createMockResponse() {
            return new MockHttpServletResponse(){};
        }

        public MockServletConfig createMockServletConfig() {
            return new MockServletConfig(){};
        }

        public MockServletContext createMockServletContext() {
            return new MockServletContext(){};
        }

        public MockHttpSession createMockSession() {
            return new MockHttpSession(){};
        }
    }

    public static class TestResponseWrapper
    extends MockHttpServletResponse {
        private HttpServletResponse response;

        public TestResponseWrapper(HttpServletResponse response) {
            this.response = response;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }
    }

    public static class TestRequestWrapper
    extends MockHttpServletRequest {
        private HttpServletRequest request;

        public TestRequestWrapper(HttpServletRequest request) {
            this.request = request;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }
    }
}

