/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.MethodUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import junit.framework.TestCase;

public class MethodUtilTest
extends TestCase {
    public void testInvoke() {
        TestObject testObject = new TestObject();
        MethodUtilTest.assertNull((Object)MethodUtil.invoke(testObject, "testMethod1"));
        MethodUtilTest.assertEquals((Object)"testMethod2", (Object)MethodUtil.invoke(testObject, "testMethod2"));
        try {
            MethodUtil.invoke(testObject, "testMethod3");
            MethodUtilTest.fail();
        }
        catch (NestedApplicationException exc) {
            // empty catch block
        }
        try {
            MethodUtil.invoke(testObject, "testMethod4");
            MethodUtilTest.fail();
        }
        catch (NestedApplicationException nestedApplicationException) {
            // empty catch block
        }
        MethodUtilTest.assertTrue((boolean)testObject.wasMethod1Called());
        MethodUtilTest.assertTrue((boolean)testObject.wasMethod2Called());
        MethodUtilTest.assertFalse((boolean)testObject.wasMethod3Called());
        MethodUtilTest.assertFalse((boolean)testObject.wasMethod4Called());
    }

    public void testInvokeWithParameter() {
        TestObject testObject = new TestObject();
        try {
            MethodUtil.invoke(testObject, "testMethod1", null);
            MethodUtilTest.fail();
        }
        catch (NestedApplicationException exc) {
            // empty catch block
        }
        try {
            MethodUtil.invoke(testObject, "testMethod1", "test");
            MethodUtilTest.fail();
        }
        catch (NestedApplicationException nestedApplicationException) {
            // empty catch block
        }
        MethodUtilTest.assertNull((Object)MethodUtil.invoke(testObject, "testMethod4", "test"));
        MethodUtilTest.assertEquals((Object)new Integer(3), (Object)MethodUtil.invoke(testObject, "testMethod5", new Integer[]{new Integer(3)}));
        MethodUtilTest.assertFalse((boolean)testObject.wasMethod1Called());
        MethodUtilTest.assertTrue((boolean)testObject.wasMethod4Called());
        MethodUtilTest.assertTrue((boolean)testObject.wasMethod5Called());
    }

    public void testAreMethodEqual() throws Exception {
        Method method1 = TestObject.class.getMethod("testMethod1", null);
        Method method2 = TestObject.class.getMethod("testMethod2", null);
        Method method4 = TestObject.class.getMethod("testMethod4", String.class);
        Method method5 = TestObject.class.getMethod("testMethod5", Integer[].class);
        Method anotherMethod2 = AnotherTestObject.class.getMethod("testMethod2", null);
        Method anotherMethod4 = AnotherTestObject.class.getMethod("testMethod4", Integer.class);
        Method anotherMethod5 = AnotherTestObject.class.getMethod("testMethod5", Integer[].class);
        try {
            MethodUtil.areMethodsEqual(null, method1);
            MethodUtilTest.fail();
        }
        catch (NullPointerException exc) {
            // empty catch block
        }
        try {
            MethodUtil.areMethodsEqual(method2, null);
            MethodUtilTest.fail();
        }
        catch (NullPointerException exc) {
            // empty catch block
        }
        MethodUtilTest.assertTrue((boolean)MethodUtil.areMethodsEqual(method1, method1));
        MethodUtilTest.assertFalse((boolean)MethodUtil.areMethodsEqual(method1, method2));
        MethodUtilTest.assertFalse((boolean)MethodUtil.areMethodsEqual(method2, anotherMethod2));
        MethodUtilTest.assertFalse((boolean)MethodUtil.areMethodsEqual(method2, anotherMethod4));
        MethodUtilTest.assertFalse((boolean)MethodUtil.areMethodsEqual(method4, anotherMethod4));
        MethodUtilTest.assertTrue((boolean)MethodUtil.areMethodsEqual(method5, anotherMethod5));
    }

    public void testGetMatchingDeclaredMethods() throws Exception {
        int ii;
        Method[] methods = MethodUtil.getMatchingDeclaredMethods(TestObject.class, "test.*");
        MethodUtilTest.assertEquals((int)5, (int)methods.length);
        ArrayList<String> methodNames = new ArrayList<String>();
        for (ii = 0; ii < methods.length; ++ii) {
            methodNames.add(methods[ii].getName());
        }
        MethodUtilTest.assertTrue((boolean)methodNames.contains("testMethod1"));
        MethodUtilTest.assertTrue((boolean)methodNames.contains("testMethod2"));
        MethodUtilTest.assertTrue((boolean)methodNames.contains("testMethod3"));
        MethodUtilTest.assertTrue((boolean)methodNames.contains("testMethod4"));
        MethodUtilTest.assertTrue((boolean)methodNames.contains("testMethod5"));
        methods = MethodUtil.getMatchingDeclaredMethods(TestObject.class, "wasMethod.Called");
        MethodUtilTest.assertEquals((int)5, (int)methods.length);
        methodNames = new ArrayList();
        for (ii = 0; ii < methods.length; ++ii) {
            methodNames.add(methods[ii].getName());
        }
        MethodUtilTest.assertTrue((boolean)methodNames.contains("wasMethod1Called"));
        MethodUtilTest.assertTrue((boolean)methodNames.contains("wasMethod2Called"));
        MethodUtilTest.assertTrue((boolean)methodNames.contains("wasMethod3Called"));
        MethodUtilTest.assertTrue((boolean)methodNames.contains("wasMethod4Called"));
        MethodUtilTest.assertTrue((boolean)methodNames.contains("wasMethod5Called"));
        methods = MethodUtil.getMatchingDeclaredMethods(TestObject.class, "wasMethod5Called");
        MethodUtilTest.assertEquals((int)1, (int)methods.length);
    }

    public void testOverrides() throws Exception {
        Method method1Super = TestSuper.class.getDeclaredMethod("testMethod1", null);
        Method method2Super = TestSuper.class.getDeclaredMethod("testMethod2", int[].class, String.class);
        Method method4Super = TestSuper.class.getDeclaredMethod("testMethod4", null);
        Method method1SubOverride = TestSub.class.getDeclaredMethod("testMethod1", null);
        Method method2SubOverride = TestSub.class.getDeclaredMethod("testMethod2", int[].class, String.class);
        Method method1SubNotOverride = TestSub.class.getDeclaredMethod("testMethod1", String.class);
        Method method2SubNotOverride = TestSub.class.getDeclaredMethod("testMethod2", int[].class);
        Method method4SubNotOverride = TestSub.class.getDeclaredMethod("testMethod4", null);
        Method methodInterface = TestInterface.class.getDeclaredMethod("testInterface", null);
        Method methodSubInterface = TestSub.class.getDeclaredMethod("testInterface", null);
        MethodUtilTest.assertFalse((boolean)MethodUtil.overrides(method1Super, method1Super));
        MethodUtilTest.assertFalse((boolean)MethodUtil.overrides(method1Super, method2Super));
        MethodUtilTest.assertFalse((boolean)MethodUtil.overrides(method1Super, method1SubNotOverride));
        MethodUtilTest.assertFalse((boolean)MethodUtil.overrides(method2Super, method2SubNotOverride));
        MethodUtilTest.assertFalse((boolean)MethodUtil.overrides(method1SubOverride, method1Super));
        MethodUtilTest.assertFalse((boolean)MethodUtil.overrides(method4Super, method4SubNotOverride));
        MethodUtilTest.assertFalse((boolean)MethodUtil.overrides(method4SubNotOverride, method4Super));
        MethodUtilTest.assertFalse((boolean)MethodUtil.overrides(methodInterface, methodSubInterface));
        MethodUtilTest.assertTrue((boolean)MethodUtil.overrides(method1Super, method1SubOverride));
        MethodUtilTest.assertTrue((boolean)MethodUtil.overrides(method2Super, method2SubOverride));
    }

    public void testGetMethodsSortedByInheritanceHierarchy() throws Exception {
        Method[][] methods = MethodUtil.getMethodsSortedByInheritanceHierarchy(TestSub3.class);
        MethodUtilTest.assertEquals((int)5, (int)methods.length);
        MethodUtilTest.assertEquals((int)3, (int)methods[1].length);
        MethodUtilTest.assertEquals((int)7, (int)methods[2].length);
        MethodUtilTest.assertEquals((int)3, (int)methods[3].length);
        Method method1Super = TestSuper.class.getDeclaredMethod("testMethod1", null);
        Method method2Super = TestSuper.class.getDeclaredMethod("testMethod2", int[].class, String.class);
        Method method1SubOverride = TestSub.class.getDeclaredMethod("testMethod1", null);
        Method method2SubOverride = TestSub.class.getDeclaredMethod("testMethod2", int[].class, String.class);
        Method method1SubNotOverride = TestSub.class.getDeclaredMethod("testMethod1", String.class);
        Method method2SubNotOverride = TestSub.class.getDeclaredMethod("testMethod2", int[].class);
        Method methodSubInterface = TestSub.class.getDeclaredMethod("testInterface", null);
        Method methodSubtoString = TestSub.class.getDeclaredMethod("toString", null);
        Method methodSub2another = TestSub2.class.getDeclaredMethod("anotherMethod", null);
        Method methodSub2anotherProtected = TestSub2.class.getDeclaredMethod("anotherProtectedMethod", null);
        Method methodSub2toString = TestSub2.class.getDeclaredMethod("toString", null);
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[1]).contains(method1Super));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[1]).contains(method2Super));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[2]).contains(method1SubOverride));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[2]).contains(method2SubOverride));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[2]).contains(method1SubNotOverride));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[2]).contains(method2SubNotOverride));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[2]).contains(methodSubInterface));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[2]).contains(methodSubtoString));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[3]).contains(methodSub2another));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[3]).contains(methodSub2anotherProtected));
        MethodUtilTest.assertTrue((boolean)Arrays.asList(methods[3]).contains(methodSub2toString));
        MethodUtilTest.assertEquals((int)0, (int)methods[4].length);
    }

    public void testGetOverriddenMethods() throws Exception {
        Method method2Super = TestSuper.class.getDeclaredMethod("testMethod2", int[].class, String.class);
        Method method1SubOverride = TestSub.class.getDeclaredMethod("testMethod1", null);
        Method method2SubOverride = TestSub.class.getDeclaredMethod("testMethod2", int[].class, String.class);
        Method method2SubNotOverride = TestSub.class.getDeclaredMethod("testMethod2", int[].class);
        Method methodSubtoString = TestSub.class.getDeclaredMethod("toString", null);
        Method methodSub2another = TestSub2.class.getDeclaredMethod("anotherMethod", null);
        Method methodSub2toString = TestSub2.class.getDeclaredMethod("toString", null);
        Method toString = Object.class.getDeclaredMethod("toString", null);
        Set methods = MethodUtil.getOverriddenMethods(TestSub2.class, new Method[]{method1SubOverride, method2Super, methodSub2another, method2SubNotOverride, toString});
        MethodUtilTest.assertEquals((int)5, (int)methods.size());
        MethodUtilTest.assertTrue((boolean)methods.contains(method2Super));
        MethodUtilTest.assertTrue((boolean)methods.contains(method2SubOverride));
        MethodUtilTest.assertTrue((boolean)methods.contains(toString));
        MethodUtilTest.assertTrue((boolean)methods.contains(methodSubtoString));
        MethodUtilTest.assertTrue((boolean)methods.contains(methodSub2toString));
    }

    public class TestSub3
    extends TestSub2 {
    }

    public static class TestSub2
    extends TestSub {
        @Override
        public String toString() {
            return super.toString();
        }

        public static void anotherStaticMethod() {
        }

        protected void anotherProtectedMethod() {
        }

        public void anotherMethod() {
        }
    }

    public static class TestSub
    extends TestSuper
    implements TestInterface {
        @Override
        public Integer testInterface() {
            return null;
        }

        public String testMethod1(String param) {
            return super.testMethod1();
        }

        @Override
        protected String testMethod1() {
            return super.testMethod1();
        }

        public void testMethod2(int[] param) {
            super.testMethod2(param, null);
        }

        @Override
        public void testMethod2(int[] param, String param2) {
            super.testMethod2(param, param2);
        }

        public static void testMethod3(String param) {
        }

        private void testMethod4() {
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class TestSuper {
        String testMethod1() {
            return null;
        }

        public void testMethod2(int[] param, String param2) {
        }

        private void testMethod4() {
        }
    }

    public static interface TestInterface {
        public Integer testInterface();
    }

    public class AnotherTestObject {
        public int testMethod2() {
            return 0;
        }

        public void testMethod4(Integer arg) {
        }

        public int testMethod5(Integer[] arg) {
            return 0;
        }
    }

    public class TestObject
    extends Super {
        private boolean method1Called;
        private boolean method2Called;
        private boolean method3Called;
        private boolean method4Called;
        private boolean method5Called;

        public TestObject() {
            this.method1Called = false;
            this.method2Called = false;
            this.method3Called = false;
            this.method4Called = false;
            this.method5Called = false;
        }

        public void testMethod1() {
            this.method1Called = true;
        }

        public String testMethod2() {
            this.method2Called = true;
            return "testMethod2";
        }

        protected void testMethod3() {
            this.method3Called = true;
        }

        public void testMethod4(String arg) {
            this.method4Called = true;
        }

        public int testMethod5(Integer[] arg) {
            this.method5Called = true;
            return arg[0];
        }

        public boolean wasMethod1Called() {
            return this.method1Called;
        }

        public boolean wasMethod2Called() {
            return this.method2Called;
        }

        public boolean wasMethod3Called() {
            return this.method3Called;
        }

        public boolean wasMethod4Called() {
            return this.method4Called;
        }

        public boolean wasMethod5Called() {
            return this.method5Called;
        }
    }

    public class Super {
        public void testSuperMethod() {
        }
    }
}

