/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.CallableStatementResultSetHandler;
import com.mockrunner.jdbc.JDBCTestModule;
import com.mockrunner.jdbc.ParameterSets;
import com.mockrunner.jdbc.PreparedStatementResultSetHandler;
import com.mockrunner.jdbc.StatementResultSetHandler;
import com.mockrunner.mock.jdbc.JDBCMockObjectFactory;
import com.mockrunner.mock.jdbc.MockCallableStatement;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockSavepoint;
import com.mockrunner.mock.jdbc.MockStatement;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public abstract class BasicJDBCTestCaseAdapter
extends TestCase {
    private JDBCTestModule jdbcTestModule;
    private JDBCMockObjectFactory jdbcMockObjectFactory;

    public BasicJDBCTestCaseAdapter() {
    }

    public BasicJDBCTestCaseAdapter(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (null != this.jdbcMockObjectFactory) {
            this.jdbcMockObjectFactory.restoreDrivers();
        }
        this.jdbcTestModule = null;
        this.jdbcMockObjectFactory = null;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jdbcTestModule = this.createJDBCTestModule(this.getJDBCMockObjectFactory());
    }

    protected JDBCMockObjectFactory createJDBCMockObjectFactory() {
        return new JDBCMockObjectFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JDBCMockObjectFactory getJDBCMockObjectFactory() {
        Class<JDBCMockObjectFactory> clazz = JDBCMockObjectFactory.class;
        synchronized (JDBCMockObjectFactory.class) {
            if (this.jdbcMockObjectFactory == null) {
                this.jdbcMockObjectFactory = this.createJDBCMockObjectFactory();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.jdbcMockObjectFactory;
        }
    }

    protected void setJDBCMockObjectFactory(JDBCMockObjectFactory jdbcMockObjectFactory) {
        this.jdbcMockObjectFactory = jdbcMockObjectFactory;
    }

    protected JDBCTestModule createJDBCTestModule() {
        return new JDBCTestModule(this.getJDBCMockObjectFactory());
    }

    protected JDBCTestModule createJDBCTestModule(JDBCMockObjectFactory mockFactory) {
        return new JDBCTestModule(mockFactory);
    }

    protected JDBCTestModule getJDBCTestModule() {
        return this.jdbcTestModule;
    }

    protected void setJDBCTestModule(JDBCTestModule jdbcTestModule) {
        this.jdbcTestModule = jdbcTestModule;
    }

    protected void setCaseSensitive(boolean caseSensitive) {
        this.jdbcTestModule.setCaseSensitive(caseSensitive);
    }

    protected void verifyCommitted() {
        this.jdbcTestModule.verifyCommitted();
    }

    protected void verifyNotCommitted() {
        this.jdbcTestModule.verifyNotCommitted();
    }

    protected void verifyRolledBack() {
        this.jdbcTestModule.verifyRolledBack();
    }

    protected void verifyNotRolledBack() {
        this.jdbcTestModule.verifyNotRolledBack();
    }

    protected void setExactMatch(boolean exactMatch) {
        this.jdbcTestModule.setExactMatch(exactMatch);
    }

    protected void setUseRegularExpressions(boolean useRegularExpressions) {
        this.jdbcTestModule.setUseRegularExpressions(useRegularExpressions);
    }

    protected StatementResultSetHandler getStatementResultSetHandler() {
        return this.jdbcTestModule.getStatementResultSetHandler();
    }

    protected PreparedStatementResultSetHandler getPreparedStatementResultSetHandler() {
        return this.jdbcTestModule.getPreparedStatementResultSetHandler();
    }

    protected CallableStatementResultSetHandler getCallableStatementResultSetHandler() {
        return this.jdbcTestModule.getCallableStatementResultSetHandler();
    }

    protected MockStatement getStatement(int index) {
        return this.jdbcTestModule.getStatement(index);
    }

    protected List getStatements() {
        return this.jdbcTestModule.getStatements();
    }

    protected List getExecutedSQLStatements() {
        return this.jdbcTestModule.getExecutedSQLStatements();
    }

    protected Map getExecutedSQLStatementParameter() {
        return this.jdbcTestModule.getExecutedSQLStatementParameter();
    }

    protected Map getExecutedSQLStatementParameterMap() {
        return this.jdbcTestModule.getExecutedSQLStatementParameterMap();
    }

    protected ParameterSets getExecutedSQLStatementParameterSets(String sql) {
        return this.jdbcTestModule.getExecutedSQLStatementParameterSets(sql);
    }

    protected MockResultSet getReturnedResultSet(String id) {
        return this.jdbcTestModule.getReturnedResultSet(id);
    }

    protected List getReturnedResultSets(String id) {
        return this.jdbcTestModule.getReturnedResultSets(id);
    }

    protected List getReturnedResultSets() {
        return this.jdbcTestModule.getReturnedResultSets();
    }

    protected MockPreparedStatement getPreparedStatement(String sql) {
        return this.jdbcTestModule.getPreparedStatement(sql);
    }

    protected MockPreparedStatement getPreparedStatement(int index) {
        return this.jdbcTestModule.getPreparedStatement(index);
    }

    protected List getPreparedStatements(String sql) {
        return this.jdbcTestModule.getPreparedStatements(sql);
    }

    protected List getPreparedStatements() {
        return this.jdbcTestModule.getPreparedStatements();
    }

    protected MockCallableStatement getCallableStatement(String sql) {
        return this.jdbcTestModule.getCallableStatement(sql);
    }

    protected MockCallableStatement getCallableStatement(int index) {
        return this.jdbcTestModule.getCallableStatement(index);
    }

    protected List getCallableStatements(String sql) {
        return this.jdbcTestModule.getCallableStatements(sql);
    }

    protected List getCallableStatements() {
        return this.jdbcTestModule.getCallableStatements();
    }

    protected Object getPreparedStatementParameter(String sql, int indexOfParameter) {
        return this.jdbcTestModule.getPreparedStatementParameter(sql, indexOfParameter);
    }

    protected Object getPreparedStatementParameter(int indexOfStatement, int indexOfParameter) {
        return this.jdbcTestModule.getPreparedStatementParameter(indexOfStatement, indexOfParameter);
    }

    protected Object getPreparedStatementParameter(PreparedStatement statement, int indexOfParameter) {
        return this.jdbcTestModule.getPreparedStatementParameter(statement, indexOfParameter);
    }

    protected Object getCallableStatementParameter(String sql, String nameOfParameter) {
        return this.jdbcTestModule.getCallableStatementParameter(sql, nameOfParameter);
    }

    protected Object getCallableStatementParameter(int indexOfStatement, String nameOfParameter) {
        return this.jdbcTestModule.getCallableStatementParameter(indexOfStatement, nameOfParameter);
    }

    protected Object getCallableStatementParameter(CallableStatement statement, String nameOfParameter) {
        return this.jdbcTestModule.getCallableStatementParameter(statement, nameOfParameter);
    }

    protected Object getCallableStatementParameter(String sql, int indexOfParameter) {
        return this.jdbcTestModule.getCallableStatementParameter(sql, indexOfParameter);
    }

    protected Object getCallableStatementParameter(CallableStatement statement, int indexOfParameter) {
        return this.jdbcTestModule.getCallableStatementParameter(statement, indexOfParameter);
    }

    protected Object getCallableStatementParameter(int indexOfStatement, int indexOfParameter) {
        return this.jdbcTestModule.getCallableStatementParameter(indexOfStatement, indexOfParameter);
    }

    protected List getSavepoints() {
        return this.jdbcTestModule.getSavepoints();
    }

    protected MockSavepoint getSavepoint(int index) {
        return this.jdbcTestModule.getSavepoint(index);
    }

    protected MockSavepoint getSavepoint(String name) {
        return this.jdbcTestModule.getSavepoint(name);
    }

    protected void verifySQLStatementExecuted(String sql) {
        this.jdbcTestModule.verifySQLStatementExecuted(sql);
    }

    protected void verifySQLStatementNotExecuted(String sql) {
        this.jdbcTestModule.verifySQLStatementNotExecuted(sql);
    }

    protected void verifySQLStatementParameterNumber(String sql, int indexOfParameterSet, int number) {
        this.jdbcTestModule.verifySQLStatementParameterNumber(sql, indexOfParameterSet, number);
    }

    protected void verifySQLStatementParameter(String sql, int indexOfParameterSet, String nameOfParameter, Object expectedParameter) {
        this.jdbcTestModule.verifySQLStatementParameter(sql, indexOfParameterSet, nameOfParameter, expectedParameter);
    }

    protected void verifySQLStatementParameter(String sql, int indexOfParameterSet, int indexOfParameter, Object expectedParameter) {
        this.jdbcTestModule.verifySQLStatementParameter(sql, indexOfParameterSet, indexOfParameter, expectedParameter);
    }

    protected void verifySQLStatementParameter(String sql, int indexOfParameterSet, Map parameterMap) {
        this.jdbcTestModule.verifySQLStatementParameter(sql, indexOfParameterSet, parameterMap);
    }

    protected void verifyConnectionClosed() {
        this.jdbcTestModule.verifyConnectionClosed();
    }

    protected void verifyAllStatementsClosed() {
        this.jdbcTestModule.verifyAllStatementsClosed();
    }

    protected void verifyResultSetClosed(String id) {
        this.jdbcTestModule.verifyResultSetClosed(id);
    }

    protected void verifyResultSetRowInserted(MockResultSet resultSet, int number) {
        this.jdbcTestModule.verifyResultSetRowInserted(resultSet, number);
    }

    protected void verifyResultSetRowInserted(String id, int number) {
        this.jdbcTestModule.verifyResultSetRowInserted(id, number);
    }

    protected void verifyResultSetRowNotInserted(MockResultSet resultSet, int number) {
        this.jdbcTestModule.verifyResultSetRowNotInserted(resultSet, number);
    }

    protected void verifyResultSetRowNotInserted(String id, int number) {
        this.jdbcTestModule.verifyResultSetRowNotInserted(id, number);
    }

    protected void verifyResultSetRowUpdated(MockResultSet resultSet, int number) {
        this.jdbcTestModule.verifyResultSetRowUpdated(resultSet, number);
    }

    protected void verifyResultSetRowUpdated(String id, int number) {
        this.jdbcTestModule.verifyResultSetRowUpdated(id, number);
    }

    protected void verifyResultSetRowNotUpdated(String id, int number) {
        this.jdbcTestModule.verifyResultSetRowNotUpdated(id, number);
    }

    protected void verifyResultSetRowNotUpdated(MockResultSet resultSet, int number) {
        this.jdbcTestModule.verifyResultSetRowNotUpdated(resultSet, number);
    }

    protected void verifyResultSetRowDeleted(MockResultSet resultSet, int number) {
        this.jdbcTestModule.verifyResultSetRowDeleted(resultSet, number);
    }

    protected void verifyResultSetRowDeleted(String id, int number) {
        this.jdbcTestModule.verifyResultSetRowDeleted(id, number);
    }

    protected void verifyResultSetRowNotDeleted(String id, int number) {
        this.jdbcTestModule.verifyResultSetRowNotDeleted(id, number);
    }

    protected void verifyResultSetRowNotDeleted(MockResultSet resultSet, int number) {
        this.jdbcTestModule.verifyResultSetRowNotDeleted(resultSet, number);
    }

    protected void verifyAllResultSetsClosed() {
        this.jdbcTestModule.verifyAllResultSetsClosed();
    }

    protected void verifyNumberCommits(int number) {
        this.jdbcTestModule.verifyNumberCommits(number);
    }

    protected void verifyNumberRollbacks(int number) {
        this.jdbcTestModule.verifyNumberRollbacks(number);
    }

    protected void verifyNumberStatements(int number) {
        this.jdbcTestModule.verifyNumberStatements(number);
    }

    protected void verifyNumberPreparedStatements(int number, String sql) {
        this.jdbcTestModule.verifyNumberPreparedStatements(number, sql);
    }

    protected void verifyNumberPreparedStatements(int number) {
        this.jdbcTestModule.verifyNumberPreparedStatements(number);
    }

    protected void verifyNumberCallableStatements(int number, String sql) {
        this.jdbcTestModule.verifyNumberCallableStatements(number, sql);
    }

    protected void verifyNumberCallableStatements(int number) {
        this.jdbcTestModule.verifyNumberCallableStatements(number);
    }

    protected void verifyStatementClosed(int index) {
        this.jdbcTestModule.verifyStatementClosed(index);
    }

    protected void verifyPreparedStatementClosed(String sql) {
        this.jdbcTestModule.verifyPreparedStatementClosed(sql);
    }

    protected void verifyPreparedStatementClosed(int index) {
        this.jdbcTestModule.verifyPreparedStatementClosed(index);
    }

    protected void verifyCallableStatementClosed(int index) {
        this.jdbcTestModule.verifyCallableStatementClosed(index);
    }

    protected void verifyCallableStatementClosed(String sql) {
        this.jdbcTestModule.verifyCallableStatementClosed(sql);
    }

    protected void verifyResultSetRow(MockResultSet resultSet, int number, List rowData) {
        this.jdbcTestModule.verifyResultSetRow(resultSet, number, rowData);
    }

    protected void verifyResultSetRow(MockResultSet resultSet, int number, Object[] rowData) {
        this.jdbcTestModule.verifyResultSetRow(resultSet, number, rowData);
    }

    protected void verifyResultSetRow(String id, int number, List rowData) {
        this.jdbcTestModule.verifyResultSetRow(id, number, rowData);
    }

    protected void verifyResultSetRow(String id, int number, Object[] rowData) {
        this.jdbcTestModule.verifyResultSetRow(id, number, rowData);
    }

    protected void verifyResultSetColumn(String id, String name, List columnData) {
        this.jdbcTestModule.verifyResultSetColumn(id, name, columnData);
    }

    protected void verifyResultSetColumn(MockResultSet resultSet, int number, List columnData) {
        this.jdbcTestModule.verifyResultSetColumn(resultSet, number, columnData);
    }

    protected void verifyResultSetColumn(MockResultSet resultSet, int number, Object[] columnData) {
        this.jdbcTestModule.verifyResultSetColumn(resultSet, number, columnData);
    }

    protected void verifyResultSetColumn(String id, int number, List columnData) {
        this.jdbcTestModule.verifyResultSetColumn(id, number, columnData);
    }

    protected void verifyResultSetColumn(String id, int number, Object[] columnData) {
        this.jdbcTestModule.verifyResultSetColumn(id, number, columnData);
    }

    protected void verifyResultSetColumn(MockResultSet resultSet, String name, List columnData) {
        this.jdbcTestModule.verifyResultSetColumn(resultSet, name, columnData);
    }

    protected void verifyResultSetColumn(MockResultSet resultSet, String name, Object[] columnData) {
        this.jdbcTestModule.verifyResultSetColumn(resultSet, name, columnData);
    }

    protected void verifyResultSetColumn(String id, String name, Object[] columnData) {
        this.jdbcTestModule.verifyResultSetColumn(id, name, columnData);
    }

    protected void verifyResultSetEquals(String id, MockResultSet target) {
        this.jdbcTestModule.verifyResultSetEquals(id, target);
    }

    protected void verifyResultSetEquals(MockResultSet source, MockResultSet target) {
        this.jdbcTestModule.verifyResultSetEquals(source, target);
    }

    protected void verifyPreparedStatementPresent(String sql) {
        this.jdbcTestModule.verifyPreparedStatementPresent(sql);
    }

    protected void verifyPreparedStatementNotPresent(String sql) {
        this.jdbcTestModule.verifyPreparedStatementNotPresent(sql);
    }

    protected void verifyCallableStatementPresent(String sql) {
        this.jdbcTestModule.verifyCallableStatementPresent(sql);
    }

    protected void verifyCallableStatementNotPresent(String sql) {
        this.jdbcTestModule.verifyCallableStatementNotPresent(sql);
    }

    protected void verifyPreparedStatementParameterPresent(PreparedStatement statement, int indexOfParameter) {
        this.jdbcTestModule.verifyPreparedStatementParameterPresent(statement, indexOfParameter);
    }

    protected void verifyPreparedStatementParameterPresent(String sql, int indexOfParameter) {
        this.jdbcTestModule.verifyPreparedStatementParameterPresent(sql, indexOfParameter);
    }

    protected void verifyPreparedStatementParameterPresent(int indexOfStatement, int indexOfParameter) {
        this.jdbcTestModule.verifyPreparedStatementParameterPresent(indexOfStatement, indexOfParameter);
    }

    protected void verifyPreparedStatementParameterNotPresent(String sql, int indexOfParameter) {
        this.jdbcTestModule.verifyPreparedStatementParameterNotPresent(sql, indexOfParameter);
    }

    protected void verifyPreparedStatementParameterNotPresent(PreparedStatement statement, int indexOfParameter) {
        this.jdbcTestModule.verifyPreparedStatementParameterNotPresent(statement, indexOfParameter);
    }

    protected void verifyPreparedStatementParameterNotPresent(int indexOfStatement, int indexOfParameter) {
        this.jdbcTestModule.verifyPreparedStatementParameterNotPresent(indexOfStatement, indexOfParameter);
    }

    protected void verifyCallableStatementParameterPresent(int indexOfStatement, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterPresent(indexOfStatement, nameOfParameter);
    }

    protected void verifyCallableStatementParameterPresent(CallableStatement statement, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterPresent(statement, indexOfParameter);
    }

    protected void verifyCallableStatementParameterPresent(String sql, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterPresent(sql, indexOfParameter);
    }

    protected void verifyCallableStatementParameterPresent(int indexOfStatement, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterPresent(indexOfStatement, indexOfParameter);
    }

    protected void verifyCallableStatementParameterPresent(String sql, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterPresent(sql, nameOfParameter);
    }

    protected void verifyCallableStatementParameterPresent(CallableStatement statement, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterPresent(statement, nameOfParameter);
    }

    protected void verifyCallableStatementParameterNotPresent(CallableStatement statement, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterNotPresent(statement, nameOfParameter);
    }

    protected void verifyCallableStatementParameterNotPresent(int indexOfStatement, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterNotPresent(indexOfStatement, indexOfParameter);
    }

    protected void verifyCallableStatementParameterNotPresent(CallableStatement statement, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterNotPresent(statement, indexOfParameter);
    }

    protected void verifyCallableStatementParameterNotPresent(String sql, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterNotPresent(sql, indexOfParameter);
    }

    protected void verifyCallableStatementParameterNotPresent(int indexOfStatement, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterNotPresent(indexOfStatement, nameOfParameter);
    }

    protected void verifyCallableStatementParameterNotPresent(String sql, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementParameterNotPresent(sql, nameOfParameter);
    }

    protected void verifyPreparedStatementParameter(PreparedStatement statement, int indexOfParameter, Object object) {
        this.jdbcTestModule.verifyPreparedStatementParameter(statement, indexOfParameter, object);
    }

    protected void verifyPreparedStatementParameter(String sql, int indexOfParameter, Object object) {
        this.jdbcTestModule.verifyPreparedStatementParameter(sql, indexOfParameter, object);
    }

    protected void verifyPreparedStatementParameter(int indexOfStatement, int indexOfParameter, Object object) {
        this.jdbcTestModule.verifyPreparedStatementParameter(indexOfStatement, indexOfParameter, object);
    }

    protected void verifyCallableStatementParameter(int indexOfStatement, String nameOfParameter, Object object) {
        this.jdbcTestModule.verifyCallableStatementParameter(indexOfStatement, nameOfParameter, object);
    }

    protected void verifyCallableStatementParameter(CallableStatement statement, int indexOfParameter, Object object) {
        this.jdbcTestModule.verifyCallableStatementParameter(statement, indexOfParameter, object);
    }

    protected void verifyCallableStatementParameter(String sql, int indexOfParameter, Object object) {
        this.jdbcTestModule.verifyCallableStatementParameter(sql, indexOfParameter, object);
    }

    protected void verifyCallableStatementParameter(int indexOfStatement, int indexOfParameter, Object object) {
        this.jdbcTestModule.verifyCallableStatementParameter(indexOfStatement, indexOfParameter, object);
    }

    protected void verifyCallableStatementParameter(CallableStatement statement, String nameOfParameter, Object object) {
        this.jdbcTestModule.verifyCallableStatementParameter(statement, nameOfParameter, object);
    }

    protected void verifyCallableStatementParameter(String sql, String nameOfParameter, Object object) {
        this.jdbcTestModule.verifyCallableStatementParameter(sql, nameOfParameter, object);
    }

    protected void verifyCallableStatementOutParameterRegistered(CallableStatement statement, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementOutParameterRegistered(statement, indexOfParameter);
    }

    protected void verifyCallableStatementOutParameterRegistered(String sql, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementOutParameterRegistered(sql, indexOfParameter);
    }

    protected void verifyCallableStatementOutParameterRegistered(int indexOfStatement, int indexOfParameter) {
        this.jdbcTestModule.verifyCallableStatementOutParameterRegistered(indexOfStatement, indexOfParameter);
    }

    protected void verifyCallableStatementOutParameterRegistered(CallableStatement statement, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementOutParameterRegistered(statement, nameOfParameter);
    }

    protected void verifyCallableStatementOutParameterRegistered(String sql, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementOutParameterRegistered(sql, nameOfParameter);
    }

    protected void verifyCallableStatementOutParameterRegistered(int indexOfStatement, String nameOfParameter) {
        this.jdbcTestModule.verifyCallableStatementOutParameterRegistered(indexOfStatement, nameOfParameter);
    }

    protected void verifySavepointPresent(String name) {
        this.jdbcTestModule.verifySavepointPresent(name);
    }

    protected void verifySavepointPresent(int index) {
        this.jdbcTestModule.verifySavepointPresent(index);
    }

    protected void verifySavepointReleased(int index) {
        this.jdbcTestModule.verifySavepointReleased(index);
    }

    protected void verifySavepointReleased(String name) {
        this.jdbcTestModule.verifySavepointReleased(name);
    }

    protected void verifySavepointNotReleased(int index) {
        this.jdbcTestModule.verifySavepointNotReleased(index);
    }

    protected void verifySavepointNotReleased(String name) {
        this.jdbcTestModule.verifySavepointNotReleased(name);
    }

    protected void verifySavepointRolledBack(int index) {
        this.jdbcTestModule.verifySavepointRolledBack(index);
    }

    protected void verifySavepointRolledBack(String name) {
        this.jdbcTestModule.verifySavepointRolledBack(name);
    }

    protected void verifySavepointNotRolledBack(String name) {
        this.jdbcTestModule.verifySavepointNotRolledBack(name);
    }

    protected void verifySavepointNotRolledBack(int index) {
        this.jdbcTestModule.verifySavepointNotRolledBack(index);
    }

    protected void verifySavepointRollbacked(String name) {
        this.jdbcTestModule.verifySavepointRollbacked(name);
    }

    protected void verifySavepointRollbacked(int index) {
        this.jdbcTestModule.verifySavepointRollbacked(index);
    }

    protected void verifySavepointNotRollbacked(String name) {
        this.jdbcTestModule.verifySavepointNotRollbacked(name);
    }

    protected void verifySavepointNotRollbacked(int index) {
        this.jdbcTestModule.verifySavepointNotRollbacked(index);
    }
}

