/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class StringValuesTable {
    private String name;
    private List columnNames = new ArrayList(0);
    private String[][] stringMatrix;

    public StringValuesTable(String name, String[][] stringMatrix) {
        this(name, null, stringMatrix);
    }

    public StringValuesTable(String name, String[] columnNames, String[][] stringMatrix) {
        if (name != null) {
            if (name.trim().length() > 0) {
                this.name = name;
                this.stringMatrix = StringValuesTable.verifyStringMatrix(stringMatrix);
                if (columnNames != null) {
                    this.columnNames = Arrays.asList(StringValuesTable.verifyColumnNames(columnNames, stringMatrix));
                }
                return;
            }
            throw new IllegalArgumentException("invalid table name given");
        }
        throw new IllegalArgumentException("the table name cannot be null");
    }

    public String[] getColumn(String columnName) {
        if (columnName != null) {
            int index = this.columnNames.indexOf(columnName);
            if (index >= 0) {
                return this.doGetColumn(index);
            }
            throw new IllegalArgumentException(columnName + " is not a valid column name");
        }
        throw new IllegalArgumentException("the column name cannot be null");
    }

    public String[] getColumn(int columnNumber) {
        return this.doGetColumn(--columnNumber);
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public String getItem(int rowNumber, String columnName) {
        if (columnName != null) {
            int index = this.columnNames.indexOf(columnName);
            if (index >= 0) {
                return this.doGetRow(rowNumber)[index];
            }
            throw new IllegalArgumentException(columnName + " is not a valid column index");
        }
        throw new IllegalArgumentException("the column name cannot be null");
    }

    public String getItem(int rowNumber, int columnNumber) {
        if (this.isColumnNumberValid(columnNumber)) {
            return this.doGetRow(rowNumber)[--columnNumber];
        }
        throw new IllegalArgumentException(columnNumber + " is not a valid column index");
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfColumns() {
        return this.stringMatrix[0].length;
    }

    public int getNumberOfRows() {
        return this.stringMatrix.length;
    }

    public String[] getRow(int rowNumber) {
        return this.doGetRow(rowNumber);
    }

    public boolean isValidColumnName(String columnName) {
        return columnName == null ? false : this.isColumnNumberValid(this.columnNames.indexOf(columnName) + 1);
    }

    public boolean isValidColumnNumber(int columnNumber) {
        return this.isColumnNumberValid(columnNumber);
    }

    public boolean isValidRowNumber(int row) {
        return --row >= 0 && row < this.stringMatrix.length;
    }

    public String[][] getStringMatrix() {
        return this.stringMatrix;
    }

    public static synchronized String[] verifyColumnNames(String[] columnNames, String[][] stringMatrix) {
        if (columnNames != null) {
            if (columnNames.length == stringMatrix[0].length) {
                String name = null;
                HashSet<String> names = new HashSet<String>();
                for (int i = 0; i < columnNames.length; ++i) {
                    name = columnNames[i];
                    if (name == null) {
                        throw new IllegalArgumentException("the column names array must not contain null elements");
                    }
                    if (names.contains(name)) {
                        throw new IllegalArgumentException("the column names array must not contain duplicate elements");
                    }
                    names.add(name);
                }
                return columnNames;
            }
            throw new IllegalArgumentException(columnNames.length + " columns were given where " + stringMatrix[0].length + (stringMatrix[0].length == 1 ? " is" : " are") + " required");
        }
        throw new IllegalArgumentException("the column names array cannot be null");
    }

    public static synchronized String[][] verifyStringMatrix(String[][] stringMatrix) {
        if (stringMatrix != null) {
            if (stringMatrix.length > 0) {
                if (stringMatrix[0] != null && stringMatrix[0].length > 0) {
                    for (int ii = 0; ii < stringMatrix.length; ++ii) {
                        if (stringMatrix[ii] == null) {
                            throw new IllegalArgumentException("the string matrix cannot contain any null arrays");
                        }
                        if (stringMatrix[ii].length != stringMatrix[0].length) {
                            throw new IllegalArgumentException("arrays in the string matrix must all contain " + stringMatrix[0].length + " elements");
                        }
                        for (int jj = 0; jj < stringMatrix[ii].length; ++jj) {
                            if (stringMatrix[ii][jj] != null) continue;
                            throw new IllegalArgumentException("arrays in the string matrix must not contain null elements");
                        }
                    }
                    return stringMatrix;
                }
                throw new IllegalArgumentException("the string matrix must contain at least 1 column of items");
            }
            throw new IllegalArgumentException("the string matrix must contain at least 1 row of items");
        }
        throw new IllegalArgumentException("the string matrix cannot be null");
    }

    private String[] doGetColumn(int index) {
        if (index >= 0 && index < this.stringMatrix[0].length) {
            String[] data = new String[this.stringMatrix.length];
            for (int row = 0; row < this.stringMatrix.length; ++row) {
                data[row] = this.stringMatrix[row][index];
            }
            return data;
        }
        throw new IllegalArgumentException(++index + " is not a valid column index");
    }

    private String[] doGetRow(int rowNumber) {
        if (--rowNumber >= 0 && rowNumber < this.stringMatrix.length) {
            return this.stringMatrix[rowNumber];
        }
        throw new IllegalArgumentException(++rowNumber + " is not a valid row number");
    }

    private boolean isColumnNumberValid(int columnNumber) {
        return --columnNumber >= 0 && columnNumber < this.stringMatrix[0].length;
    }
}

