/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import java.sql.SQLException;
import junit.framework.TestCase;

public class MockResultSetMetaDataTest
extends TestCase {
    private MockResultSetMetaData metaData;

    protected void setUp() throws Exception {
        this.metaData = new MockResultSetMetaData();
    }

    protected void tearDown() throws Exception {
        this.metaData = null;
    }

    private void prepareMetaData() {
        this.metaData.setColumnClassName(1, "ClassName");
        this.metaData.setColumnCount(4);
        this.metaData.setColumnTypeName(2, "TypeName");
        this.metaData.setColumnDisplaySize(3, 7);
        this.metaData.setSearchable(2, false);
        this.metaData.setReadOnly(5, true);
        this.metaData.setScale(1, 2);
        this.metaData.setNullable(2, 3);
    }

    private void verifyMetaData(MockResultSetMetaData metaData) throws SQLException {
        MockResultSetMetaDataTest.assertEquals((String)"ClassName", (String)metaData.getColumnClassName(1));
        MockResultSetMetaDataTest.assertEquals((String)Object.class.getName(), (String)metaData.getColumnClassName(2));
        MockResultSetMetaDataTest.assertEquals((int)4, (int)metaData.getColumnCount());
        MockResultSetMetaDataTest.assertEquals((String)"TypeName", (String)metaData.getColumnTypeName(2));
        MockResultSetMetaDataTest.assertEquals((String)"", (String)metaData.getColumnTypeName(1));
        MockResultSetMetaDataTest.assertEquals((int)7, (int)metaData.getColumnDisplaySize(3));
        MockResultSetMetaDataTest.assertEquals((int)4, (int)metaData.getColumnDisplaySize(5));
        MockResultSetMetaDataTest.assertFalse((boolean)metaData.isSearchable(2));
        MockResultSetMetaDataTest.assertTrue((boolean)metaData.isSearchable(1));
        MockResultSetMetaDataTest.assertTrue((boolean)metaData.isReadOnly(5));
        MockResultSetMetaDataTest.assertFalse((boolean)metaData.isReadOnly(1));
        MockResultSetMetaDataTest.assertEquals((int)2, (int)metaData.getScale(1));
        MockResultSetMetaDataTest.assertEquals((int)3, (int)metaData.isNullable(2));
    }

    public void testSetAndClone() throws Exception {
        this.prepareMetaData();
        this.verifyMetaData(this.metaData);
        MockResultSetMetaData clonedMetaData = (MockResultSetMetaData)this.metaData.clone();
        MockResultSetMetaDataTest.assertNotSame((Object)this.metaData, (Object)clonedMetaData);
        this.verifyMetaData(clonedMetaData);
    }
}

