/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import com.mockrunner.mock.jdbc.MockRowId;
import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.mock.jdbc.MockStruct;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class MockResultSetTest
extends TestCase {
    private MockResultSet resultSet;

    protected void setUp() throws Exception {
        super.setUp();
        this.resultSet = new MockResultSet("");
    }

    public void testGetColumnCountMetaData() throws Exception {
        MockResultSetTest.assertEquals((int)0, (int)this.resultSet.getMetaData().getColumnCount());
        this.resultSet.addColumn("firstColumn");
        this.resultSet.addColumn("secondColumn");
        this.resultSet.addColumn("thirdColumn");
        MockResultSetTest.assertEquals((int)3, (int)this.resultSet.getMetaData().getColumnCount());
        MockResultSetTest.assertEquals((String)"firstColumn", (String)this.resultSet.getMetaData().getColumnName(1));
        MockResultSetTest.assertEquals((String)"secondColumn", (String)this.resultSet.getMetaData().getColumnName(2));
        MockResultSetTest.assertEquals((String)"thirdColumn", (String)this.resultSet.getMetaData().getColumnName(3));
    }

    public void testAddRow() throws Exception {
        this.resultSet.addColumn("firstColumn");
        this.resultSet.addColumn("secondColumn");
        this.resultSet.addColumn("thirdColumn");
        ArrayList<String> row = new ArrayList<String>();
        row.add("value1");
        row.add("value2");
        row.add("value3");
        row.add("value4");
        this.resultSet.addRow(row);
        this.resultSet.addRow(new String[]{"test1", "test2"});
        MockResultSetTest.assertTrue((this.resultSet.getRowCount() == 2 ? 1 : 0) != 0);
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertEquals((String)"value1", (String)this.resultSet.getString(1));
        MockResultSetTest.assertEquals((String)"value2", (String)this.resultSet.getString(2));
        MockResultSetTest.assertEquals((String)"value3", (String)this.resultSet.getString(3));
        MockResultSetTest.assertEquals((String)"value4", (String)this.resultSet.getString(4));
        MockResultSetTest.assertEquals((String)"value1", (String)this.resultSet.getString("firstColumn"));
        MockResultSetTest.assertEquals((String)"value2", (String)this.resultSet.getString("secondColumn"));
        MockResultSetTest.assertEquals((String)"value3", (String)this.resultSet.getString("thirdColumn"));
        MockResultSetTest.assertEquals((String)"value4", (String)this.resultSet.getString("Column4"));
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertEquals((String)"test1", (String)this.resultSet.getString(1));
        MockResultSetTest.assertEquals((String)"test2", (String)this.resultSet.getString(2));
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString(3));
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString(4));
        MockResultSetTest.assertEquals((String)"test1", (String)this.resultSet.getString("firstColumn"));
        MockResultSetTest.assertEquals((String)"test2", (String)this.resultSet.getString("secondColumn"));
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString("thirdColumn"));
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString("Column4"));
    }

    public void testAddColumn() throws Exception {
        this.resultSet.addColumn("intColumn", new Integer[]{new Integer(1), new Integer(2), new Integer(3)});
        ArrayList<String> column = new ArrayList<String>();
        column.add("value1");
        column.add("value2");
        column.add("value3");
        column.add("value4");
        this.resultSet.addColumn("stringColumn", column);
        this.resultSet.addColumn();
        MockResultSetTest.assertTrue((this.resultSet.getRowCount() == 4 ? 1 : 0) != 0);
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertEquals((int)1, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((String)"value1", (String)this.resultSet.getString(2));
        MockResultSetTest.assertEquals(null, (Object)this.resultSet.getObject(3));
        MockResultSetTest.assertEquals((int)1, (int)this.resultSet.getInt("intColumn"));
        MockResultSetTest.assertEquals((String)"value1", (String)this.resultSet.getString("stringColumn"));
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString("Column3"));
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertEquals((int)2, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((String)"value2", (String)this.resultSet.getString(2));
        MockResultSetTest.assertEquals(null, (Object)this.resultSet.getObject(3));
        MockResultSetTest.assertEquals((int)2, (int)this.resultSet.getInt("intColumn"));
        MockResultSetTest.assertEquals((String)"value2", (String)this.resultSet.getString("stringColumn"));
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString("Column3"));
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertEquals((int)3, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((String)"value3", (String)this.resultSet.getString(2));
        MockResultSetTest.assertEquals(null, (Object)this.resultSet.getObject(3, (Class)String.class));
        MockResultSetTest.assertEquals((int)3, (int)this.resultSet.getInt("intColumn"));
        MockResultSetTest.assertEquals((String)"value3", (String)this.resultSet.getString("stringColumn"));
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString("Column3"));
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertEquals((int)0, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((String)"value4", (String)this.resultSet.getString(2));
        MockResultSetTest.assertEquals(null, (Object)this.resultSet.getObject(3));
        MockResultSetTest.assertEquals((int)0, (int)this.resultSet.getInt("intColumn"));
        MockResultSetTest.assertEquals((String)"value4", (String)this.resultSet.getString("stringColumn"));
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString("Column3"));
    }

    public void testGetValues() throws Exception {
        ArrayList<Object> column = new ArrayList<Object>();
        column.add("1.2");
        column.add(new Double(3.4));
        column.add("1900-12-12");
        column.add("value");
        column.add(null);
        column.add("value");
        column.add(new BigDecimal(new BigInteger("234"), 2));
        this.resultSet.addColumn("column", column);
        try {
            this.resultSet.getObject(1);
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        this.resultSet.next();
        MockResultSetTest.assertEquals((double)1.2f, (double)this.resultSet.getFloat(1), (double)0.0);
        MockResultSetTest.assertEquals((Object)new BigDecimal("1.2"), (Object)this.resultSet.getBigDecimal(1));
        MockResultSetTest.assertEquals((Object)new BigDecimal(new BigInteger("120000"), 5), (Object)this.resultSet.getBigDecimal(1, 5));
        MockResultSetTest.assertEquals((Object)new BigDecimal("1.2"), (Object)this.resultSet.getBigDecimal("column"));
        MockResultSetTest.assertEquals((Object)new BigDecimal(new BigInteger("120000"), 5), (Object)this.resultSet.getBigDecimal("column", 5));
        MockResultSetTest.assertFalse((boolean)this.resultSet.wasNull());
        MockResultSetTest.assertEquals((double)1.2, (double)this.resultSet.getDouble("column"), (double)0.0);
        MockResultSetTest.assertTrue((boolean)Arrays.equals(new byte[]{49, 46, 50}, this.resultSet.getBytes(1)));
        MockResultSetTest.assertFalse((boolean)this.resultSet.wasNull());
        this.resultSet.next();
        MockResultSetTest.assertEquals((String)"3.4", (String)this.resultSet.getNString("column"));
        MockResultSetTest.assertEquals((double)3.4, (double)this.resultSet.getDouble(1), (double)0.0);
        MockResultSetTest.assertEquals((int)3, (int)this.resultSet.getInt(1));
        this.resultSet.next();
        MockResultSetTest.assertEquals((String)"1900-12-12", (String)this.resultSet.getDate(1).toString());
        char[] charData = new char[10];
        this.resultSet.getCharacterStream(1).read(charData);
        MockResultSetTest.assertEquals((String)"1900-12-12", (String)new String(charData));
        MockResultSetTest.assertFalse((boolean)this.resultSet.wasNull());
        this.resultSet.next();
        byte[] byteData = new byte[5];
        this.resultSet.getBinaryStream("column").read(byteData);
        MockResultSetTest.assertEquals((String)"value", (String)new String(byteData, "ISO-8859-1"));
        MockResultSetTest.assertFalse((boolean)this.resultSet.wasNull());
        this.resultSet.next();
        MockResultSetTest.assertEquals((int)0, (int)this.resultSet.getShort(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.wasNull());
        MockResultSetTest.assertEquals(null, (String)this.resultSet.getString(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.wasNull());
        this.resultSet.next();
        MockResultSetTest.assertEquals((Object)"value", (Object)this.resultSet.getObject("column", (Class)Integer.class));
        MockResultSetTest.assertEquals((String)"value", (String)this.resultSet.getNString("column"));
        Clob clob = this.resultSet.getClob("column");
        MockResultSetTest.assertEquals((String)"value", (String)clob.getSubString(1L, 5));
        MockResultSetTest.assertFalse((boolean)this.resultSet.wasNull());
        this.resultSet.next();
        MockResultSetTest.assertEquals((Object)new BigDecimal(new BigInteger("234"), 2), (Object)this.resultSet.getBigDecimal("column"));
        MockResultSetTest.assertEquals((Object)new BigDecimal(new BigInteger("234"), 2), (Object)this.resultSet.getBigDecimal(1));
        this.resultSet.next();
        try {
            this.resultSet.getObject(1);
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
    }

    public void testUpdateValues() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        ArrayList<Object> column = new ArrayList<Object>();
        column.add(null);
        column.add(new Double(3.4));
        column.add("value");
        this.resultSet.addColumn("column1", column);
        column = new ArrayList();
        column.add(new Integer(2));
        column.add("test");
        this.resultSet.addColumn("column2", column);
        try {
            this.resultSet.updateObject(1, (Object)"value");
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        this.resultSet.next();
        this.resultSet.updateNull(2);
        MockResultSetTest.assertNull((Object)this.resultSet.getObject(1));
        MockResultSetTest.assertNull((Object)this.resultSet.getObject(2));
        this.resultSet.updateInt(1, 3);
        MockResultSetTest.assertEquals((Object)new Integer(3), (Object)this.resultSet.getObject(1));
        MockResultSetTest.assertNull((Object)this.resultSet.getObject(2));
        this.resultSet.next();
        this.resultSet.updateBytes(2, new byte[]{1, 2, 3});
        MockResultSetTest.assertEquals((Object)new Double(3.4), (Object)this.resultSet.getObject(1));
        MockResultSetTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, this.resultSet.getBlob("column2").getBytes(1L, 3)));
        this.resultSet.next();
        this.resultSet.updateObject(1, (Object)"3");
        MockResultSetTest.assertEquals((long)3L, (long)this.resultSet.getLong(1));
        this.resultSet.updateNString(1, "1");
        MockResultSetTest.assertEquals((long)1L, (long)this.resultSet.getLong(1));
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        this.resultSet.updateBinaryStream(1, (InputStream)stream, 3);
        InputStream inputStream = this.resultSet.getBinaryStream(1);
        MockResultSetTest.assertEquals((int)1, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)2, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)3, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)-1, (int)inputStream.read());
        this.resultSet.updateRowId(1, (RowId)new MockRowId(new byte[]{1, 2, 3}));
        MockResultSetTest.assertEquals((Object)new MockRowId(new byte[]{1, 2, 3}), (Object)this.resultSet.getRowId(1));
    }

    public void testUpdateStreams() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.addColumn("column", new Object[]{"value"});
        this.resultSet.next();
        ByteArrayInputStream updateStream = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        this.resultSet.updateAsciiStream(1, (InputStream)updateStream, 2L);
        InputStream inputStream = this.resultSet.getAsciiStream("column");
        MockResultSetTest.assertEquals((int)1, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)2, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)-1, (int)inputStream.read());
        updateStream = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        this.resultSet.updateAsciiStream(1, (InputStream)updateStream);
        inputStream = this.resultSet.getAsciiStream(1);
        MockResultSetTest.assertEquals((int)1, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)2, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)3, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)4, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)5, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)-1, (int)inputStream.read());
        updateStream = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        this.resultSet.updateBinaryStream("column", (InputStream)updateStream, 3L);
        inputStream = this.resultSet.getBinaryStream("column");
        MockResultSetTest.assertEquals((int)1, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)2, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)3, (int)inputStream.read());
        MockResultSetTest.assertEquals((int)-1, (int)inputStream.read());
        StringReader updateReader = new StringReader("test");
        this.resultSet.updateCharacterStream(1, (Reader)updateReader);
        Reader inputReader = this.resultSet.getCharacterStream("column");
        MockResultSetTest.assertEquals((char)'t', (char)((char)inputReader.read()));
        MockResultSetTest.assertEquals((char)'e', (char)((char)inputReader.read()));
        MockResultSetTest.assertEquals((char)'s', (char)((char)inputReader.read()));
        MockResultSetTest.assertEquals((char)'t', (char)((char)inputReader.read()));
        MockResultSetTest.assertEquals((int)-1, (int)inputReader.read());
        updateReader = new StringReader("test");
        this.resultSet.updateCharacterStream(1, (Reader)updateReader, 1);
        inputReader = this.resultSet.getNCharacterStream(1);
        MockResultSetTest.assertEquals((char)'t', (char)((char)inputReader.read()));
        MockResultSetTest.assertEquals((int)-1, (int)inputReader.read());
        updateReader = new StringReader("test");
        this.resultSet.updateNCharacterStream(1, (Reader)updateReader, 2L);
        inputReader = this.resultSet.getCharacterStream(1);
        MockResultSetTest.assertEquals((char)'t', (char)((char)inputReader.read()));
        MockResultSetTest.assertEquals((char)'e', (char)((char)inputReader.read()));
        MockResultSetTest.assertEquals((int)-1, (int)inputReader.read());
    }

    public void testUpdateBlobAndClob() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.addColumn("column", new Object[]{"value"});
        this.resultSet.next();
        this.resultSet.updateBlob(1, (Blob)new MockBlob(new byte[]{1, 2, 3}));
        MockResultSetTest.assertEquals((Object)new MockBlob(new byte[]{1, 2, 3}), (Object)this.resultSet.getBlob("column"));
        this.resultSet.updateBlob("column", (InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        MockResultSetTest.assertEquals((Object)new MockBlob(new byte[]{1, 2, 3}), (Object)this.resultSet.getBlob(1));
        this.resultSet.updateBlob("column", (InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5}), 3L);
        MockResultSetTest.assertEquals((Object)new MockBlob(new byte[]{1, 2, 3}), (Object)this.resultSet.getBlob(1));
        this.resultSet.updateClob(1, (Clob)new MockClob("test"));
        MockResultSetTest.assertEquals((Object)new MockClob("test"), (Object)this.resultSet.getClob("column"));
        this.resultSet.updateClob("column", (Reader)new StringReader("test"));
        MockResultSetTest.assertEquals((Object)new MockClob("test"), (Object)this.resultSet.getClob(1));
        this.resultSet.updateClob("column", (Reader)new StringReader("testxyz"), 4L);
        MockResultSetTest.assertEquals((Object)new MockClob("test"), (Object)this.resultSet.getClob(1));
        this.resultSet.updateNClob("column", (NClob)new MockNClob("test"));
        MockResultSetTest.assertEquals((Object)new MockNClob("test"), (Object)this.resultSet.getNClob("column"));
        this.resultSet.updateClob(1, (Clob)new MockClob("test"));
        MockResultSetTest.assertEquals((Object)new MockNClob("test"), (Object)this.resultSet.getNClob(1));
        this.resultSet.updateNClob("column", (Reader)new StringReader("test"));
        MockResultSetTest.assertEquals((Object)new MockNClob("test"), (Object)this.resultSet.getNClob("column"));
        this.resultSet.updateNClob(1, (Reader)new StringReader("test"), 4L);
        MockResultSetTest.assertEquals((Object)new MockNClob("test"), (Object)this.resultSet.getNClob(1));
    }

    public void testUpdateSQLXML() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.addColumn("column", new Object[]{"value"});
        this.resultSet.next();
        this.resultSet.updateSQLXML(1, (SQLXML)new MockSQLXML("<abc></abc>"));
        MockResultSetTest.assertEquals((Object)new MockSQLXML("<abc></abc>"), (Object)this.resultSet.getSQLXML("column"));
        this.resultSet.updateSQLXML("column", (SQLXML)new MockSQLXML("<abc>abc</abc>"));
        MockResultSetTest.assertEquals((Object)new MockSQLXML("<abc>abc</abc>"), (Object)this.resultSet.getSQLXML(1));
    }

    public void testError() throws Exception {
        this.resultSet.setResultSetType(1003);
        ArrayList<String> column = new ArrayList<String>();
        column.add("test");
        this.resultSet.addColumn("column1", column);
        try {
            this.resultSet.first();
            MockResultSetTest.fail((String)"not scrollable");
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.next();
            this.resultSet.updateInt(1, 1);
            MockResultSetTest.fail((String)"not updatable");
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.updateInt("column2", 1);
            MockResultSetTest.fail((String)"invalid columnname");
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.updateInt(2, 1);
            MockResultSetTest.fail((String)"invalid columnindex");
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.next();
            this.resultSet.updateInt(1, 1);
            MockResultSetTest.fail((String)"row invalid");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testFindColumn() throws Exception {
        this.resultSet.addColumn("test");
        this.resultSet.addColumn("testxy");
        MockResultSetTest.assertEquals((int)1, (int)this.resultSet.findColumn("test"));
        MockResultSetTest.assertEquals((int)2, (int)this.resultSet.findColumn("testxy"));
        try {
            this.resultSet.findColumn("test1");
            MockResultSetTest.fail((String)"column invalid");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testEmptyResultSet() throws Exception {
        this.resultSet.addColumn("test");
        MockResultSetTest.assertFalse((boolean)this.resultSet.isFirst());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isAfterLast());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isBeforeFirst());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isLast());
        MockResultSetTest.assertFalse((boolean)this.resultSet.next());
        MockResultSetTest.assertFalse((boolean)this.resultSet.first());
        MockResultSetTest.assertFalse((boolean)this.resultSet.last());
        MockResultSetTest.assertFalse((boolean)this.resultSet.previous());
        MockResultSetTest.assertFalse((boolean)this.resultSet.absolute(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.relative(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.isFirst());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isAfterLast());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isBeforeFirst());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isLast());
        try {
            this.resultSet.getString("test");
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.getString(1);
            MockResultSetTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testInsertOnEmptyResultSet() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.addColumn("test");
        this.resultSet.moveToInsertRow();
        this.resultSet.updateString("test", "value");
        this.resultSet.insertRow();
        this.resultSet.moveToCurrentRow();
        MockResultSetTest.assertEquals((String)"value", (String)this.resultSet.getString("test"));
        MockResultSetTest.assertEquals((int)1, (int)this.resultSet.getRowCount());
        MockResultSetTest.assertTrue((boolean)this.resultSet.isFirst());
        MockResultSetTest.assertTrue((boolean)this.resultSet.isLast());
    }

    public void testCursorPosition() throws Exception {
        this.resultSet.setResultSetType(1005);
        this.resultSet.addRow(new String[]{"1", "2", "3"});
        this.resultSet.addRow(new String[]{"4", "5", "6"});
        this.resultSet.addRow(new String[]{"7", "8", "9"});
        MockResultSetTest.assertTrue((boolean)this.resultSet.isBeforeFirst());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isAfterLast());
        MockResultSetTest.assertTrue((boolean)this.resultSet.last());
        MockResultSetTest.assertTrue((boolean)this.resultSet.isLast());
        MockResultSetTest.assertTrue((boolean)this.resultSet.first());
        MockResultSetTest.assertTrue((boolean)this.resultSet.isFirst());
        this.resultSet.afterLast();
        MockResultSetTest.assertTrue((boolean)this.resultSet.isAfterLast());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isBeforeFirst());
        this.resultSet.beforeFirst();
        MockResultSetTest.assertTrue((boolean)this.resultSet.isBeforeFirst());
        MockResultSetTest.assertFalse((boolean)this.resultSet.isAfterLast());
        MockResultSetTest.assertTrue((boolean)this.resultSet.next());
        MockResultSetTest.assertTrue((boolean)this.resultSet.isFirst());
        MockResultSetTest.assertFalse((boolean)this.resultSet.previous());
        MockResultSetTest.assertTrue((boolean)this.resultSet.isBeforeFirst());
        MockResultSetTest.assertTrue((boolean)this.resultSet.absolute(3));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isLast());
        MockResultSetTest.assertTrue((boolean)this.resultSet.absolute(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isFirst());
        MockResultSetTest.assertEquals((int)1, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.relative(1));
        MockResultSetTest.assertEquals((int)4, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.relative(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isLast());
        MockResultSetTest.assertEquals((int)7, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.relative(-2));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isFirst());
        MockResultSetTest.assertTrue((boolean)this.resultSet.last());
        MockResultSetTest.assertFalse((boolean)this.resultSet.next());
    }

    public void testCursorNotAllowed() throws Exception {
        this.resultSet.setResultSetType(1003);
        this.resultSet.addRow(new String[]{"1", "2", "3"});
        this.resultSet.addRow(new String[]{"4", "5", "6"});
        MockResultSetTest.assertTrue((boolean)this.resultSet.isBeforeFirst());
        try {
            this.resultSet.first();
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        MockResultSetTest.assertTrue((boolean)this.resultSet.isBeforeFirst());
        this.resultSet.next();
        this.resultSet.next();
        try {
            this.resultSet.previous();
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.last();
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.relative(-1);
            MockResultSetTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testSetFetchDirection() throws Exception {
        try {
            this.resultSet.setFetchDirection(2001);
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        this.resultSet.setResultSetType(1003);
        try {
            this.resultSet.setFetchDirection(1001);
            MockResultSetTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.resultSet.setResultSetType(1005);
        this.resultSet.addRow(new String[]{"1", "2", "3"});
        this.resultSet.addRow(new String[]{"4", "5", "6"});
        this.resultSet.addRow(new String[]{"7", "8", "9"});
        this.resultSet.addRow(new String[]{"10", "11", "12"});
        this.resultSet.last();
        this.resultSet.setFetchDirection(1001);
        MockResultSetTest.assertEquals((int)1001, (int)this.resultSet.getFetchDirection());
        MockResultSetTest.assertTrue((boolean)this.resultSet.isFirst());
        this.resultSet.setFetchDirection(1000);
        MockResultSetTest.assertEquals((int)1000, (int)this.resultSet.getFetchDirection());
        this.resultSet.absolute(3);
        MockResultSetTest.assertEquals((int)7, (int)this.resultSet.getInt(1));
        this.resultSet.setFetchDirection(1001);
        MockResultSetTest.assertEquals((int)1001, (int)this.resultSet.getFetchDirection());
        MockResultSetTest.assertEquals((int)7, (int)this.resultSet.getInt(1));
        this.resultSet.previous();
        MockResultSetTest.assertEquals((int)10, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isFirst());
        this.resultSet.setFetchDirection(1001);
        MockResultSetTest.assertEquals((int)1001, (int)this.resultSet.getFetchDirection());
        this.resultSet.absolute(3);
        MockResultSetTest.assertEquals((int)4, (int)this.resultSet.getInt(1));
        this.resultSet.setFetchDirection(1002);
        MockResultSetTest.assertEquals((int)1002, (int)this.resultSet.getFetchDirection());
        this.resultSet.absolute(3);
        MockResultSetTest.assertEquals((int)4, (int)this.resultSet.getInt(1));
        this.resultSet.setFetchDirection(1001);
        MockResultSetTest.assertEquals((int)1001, (int)this.resultSet.getFetchDirection());
        this.resultSet.absolute(3);
        MockResultSetTest.assertEquals((int)4, (int)this.resultSet.getInt(1));
        this.resultSet.setFetchDirection(1000);
        MockResultSetTest.assertEquals((int)1000, (int)this.resultSet.getFetchDirection());
        this.resultSet.absolute(3);
        MockResultSetTest.assertEquals((int)7, (int)this.resultSet.getInt(1));
    }

    public void testInsertDeleteRows() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.setResultSetType(1005);
        this.resultSet.addRow(new String[]{"1", "2", "3"});
        this.resultSet.addRow(new String[]{"4", "5", "6"});
        this.resultSet.addRow(new String[]{"7", "8", "9"});
        this.resultSet.addRow(new String[]{"10", "11", "12"});
        this.resultSet.absolute(3);
        this.resultSet.moveToInsertRow();
        this.resultSet.updateString(1, "x");
        this.resultSet.updateString(2, "y");
        this.resultSet.updateString(3, "z");
        this.resultSet.insertRow();
        this.resultSet.moveToCurrentRow();
        MockResultSetTest.assertEquals((String)"x", (String)this.resultSet.getString(1));
        MockResultSetTest.assertEquals((String)"y", (String)this.resultSet.getString(2));
        MockResultSetTest.assertEquals((String)"z", (String)this.resultSet.getString(3));
        this.resultSet.refreshRow();
        MockResultSetTest.assertEquals((String)"x", (String)this.resultSet.getString(1));
        MockResultSetTest.assertEquals((String)"y", (String)this.resultSet.getString(2));
        MockResultSetTest.assertEquals((String)"z", (String)this.resultSet.getString(3));
        this.resultSet.next();
        MockResultSetTest.assertEquals((String)"7", (String)this.resultSet.getString(1));
        this.resultSet.previous();
        this.resultSet.previous();
        MockResultSetTest.assertEquals((String)"4", (String)this.resultSet.getString(1));
        this.resultSet.deleteRow();
        try {
            this.resultSet.getString(1);
            MockResultSetTest.fail((String)"was deleted");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.resultSet.first();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowDeleted());
        this.resultSet.next();
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted());
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted());
    }

    public void testInsertRowFailure() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.setResultSetType(1005);
        this.resultSet.addRow(new String[]{"1", "2", "3"});
        this.resultSet.next();
        try {
            this.resultSet.insertRow();
            MockResultSetTest.fail((String)"cursor not in insert row");
        }
        catch (SQLException exc) {
            // empty catch block
        }
        this.resultSet.moveToInsertRow();
        try {
            this.resultSet.deleteRow();
            MockResultSetTest.fail((String)"cursor is in insert row");
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.updateRow();
            MockResultSetTest.fail((String)"cursor is in insert row");
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.cancelRowUpdates();
            MockResultSetTest.fail((String)"cursor is in insert row");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testUpdateDeleteInvalidRow() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.setResultSetType(1005);
        this.resultSet.addRow(new String[]{"1", "2", "3"});
        try {
            this.resultSet.updateRow();
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.rowUpdated();
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        this.resultSet.next();
        this.resultSet.next();
        try {
            this.resultSet.deleteRow();
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.resultSet.rowDeleted();
            MockResultSetTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testCloneOnUpdateRow() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.setResultSetType(1005);
        this.resultSet.addRow(new Object[]{new MockBlob(new byte[]{1, 2, 3}), new MockClob("test")});
        this.resultSet.next();
        Blob blob = this.resultSet.getBlob(1);
        Clob clob = this.resultSet.getClob(2);
        blob.setBytes(1L, new byte[]{4, 5, 6});
        clob.setString(1L, "anothertest");
        MockResultSetTest.assertEquals((Object)new MockBlob(new byte[]{4, 5, 6}), (Object)this.resultSet.getBlob(1));
        MockResultSetTest.assertEquals((Object)new MockClob("anothertest"), (Object)this.resultSet.getClob(2));
        this.resultSet.setDatabaseView(true);
        MockResultSetTest.assertEquals((Object)new MockBlob(new byte[]{1, 2, 3}), (Object)this.resultSet.getBlob(1));
        MockResultSetTest.assertEquals((Object)new MockClob("test"), (Object)this.resultSet.getClob(2));
        this.resultSet.updateRow();
        MockResultSetTest.assertEquals((Object)new MockBlob(new byte[]{4, 5, 6}), (Object)this.resultSet.getBlob(1));
        MockResultSetTest.assertEquals((Object)new MockClob("anothertest"), (Object)this.resultSet.getClob(2));
        this.resultSet.setDatabaseView(false);
        MockResultSetTest.assertEquals((Object)new MockBlob(new byte[]{4, 5, 6}), (Object)this.resultSet.getBlob(1));
        MockResultSetTest.assertEquals((Object)new MockClob("anothertest"), (Object)this.resultSet.getClob(2));
    }

    public void testCloneOnInsertRow() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.setResultSetType(1005);
        this.resultSet.addColumn("column", new Object[]{"1"});
        this.resultSet.next();
        this.resultSet.moveToInsertRow();
        this.resultSet.updateRef("column", (Ref)new MockRef("test"));
        this.resultSet.insertRow();
        this.resultSet.moveToCurrentRow();
        MockResultSetTest.assertEquals((Object)new MockRef("test"), (Object)this.resultSet.getRef("column"));
        this.resultSet.setDatabaseView(true);
        MockResultSetTest.assertEquals((Object)new MockRef("test"), (Object)this.resultSet.getRef("column"));
        this.resultSet.setDatabaseView(false);
        Ref ref = this.resultSet.getRef("column");
        ref.setObject("anothertest");
        MockResultSetTest.assertEquals((Object)new MockRef("anothertest"), (Object)this.resultSet.getRef("column"));
        this.resultSet.setDatabaseView(true);
        MockResultSetTest.assertEquals((Object)new MockRef("test"), (Object)this.resultSet.getRef("column"));
    }

    public void testDatabaseView() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.setResultSetType(1005);
        this.resultSet.addRow(new String[]{"1", "2", "3"});
        this.resultSet.addRow(new String[]{"4", "5", "6"});
        this.resultSet.addRow(new String[]{"7", "8", "9"});
        this.resultSet.addRow(new String[]{"10", "11", "12"});
        this.resultSet.absolute(3);
        this.resultSet.updateInt(1, 3);
        MockResultSetTest.assertEquals((int)3, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((int)8, (int)this.resultSet.getInt(2));
        MockResultSetTest.assertEquals((int)9, (int)this.resultSet.getInt(3));
        this.resultSet.setDatabaseView(true);
        MockResultSetTest.assertEquals((int)7, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((int)8, (int)this.resultSet.getInt(2));
        MockResultSetTest.assertEquals((int)9, (int)this.resultSet.getInt(3));
        this.resultSet.updateRow();
        MockResultSetTest.assertEquals((int)3, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((int)8, (int)this.resultSet.getInt(2));
        MockResultSetTest.assertEquals((int)9, (int)this.resultSet.getInt(3));
        this.resultSet.setDatabaseView(false);
        this.resultSet.first();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        this.resultSet.next();
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowUpdated());
        this.resultSet.next();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
        this.resultSet.updateInt(2, 4);
        this.resultSet.cancelRowUpdates();
        MockResultSetTest.assertEquals((int)10, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((int)11, (int)this.resultSet.getInt(2));
        MockResultSetTest.assertEquals((int)12, (int)this.resultSet.getInt(3));
        this.resultSet.setDatabaseView(true);
        MockResultSetTest.assertEquals((int)10, (int)this.resultSet.getInt(1));
        MockResultSetTest.assertEquals((int)11, (int)this.resultSet.getInt(2));
        MockResultSetTest.assertEquals((int)12, (int)this.resultSet.getInt(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated());
    }

    public void testIsEqual() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.addColumn("col1");
        this.resultSet.addRow(new String[]{"test1", "test2"});
        this.resultSet.addRow(new String[]{"test3", "test4"});
        this.resultSet.addRow(new String[]{"test5", "test6"});
        List row1 = this.resultSet.getRow(1);
        MockResultSetTest.assertEquals((Object)"test1", row1.get(0));
        MockResultSetTest.assertEquals((Object)"test2", row1.get(1));
        List row3 = this.resultSet.getRow(3);
        MockResultSetTest.assertEquals((Object)"test5", row3.get(0));
        MockResultSetTest.assertEquals((Object)"test6", row3.get(1));
        List column2 = this.resultSet.getColumn(2);
        MockResultSetTest.assertEquals((Object)"test2", column2.get(0));
        MockResultSetTest.assertEquals((Object)"test4", column2.get(1));
        MockResultSetTest.assertEquals((Object)"test6", column2.get(2));
        List column1 = this.resultSet.getColumn("col1");
        MockResultSetTest.assertEquals((Object)"test1", column1.get(0));
        MockResultSetTest.assertEquals((Object)"test3", column1.get(1));
        MockResultSetTest.assertEquals((Object)"test5", column1.get(2));
        MockResultSet otherResult = new MockResultSet("");
        otherResult.setResultSetConcurrency(1008);
        otherResult.addRow(new String[]{"test1", "test2"});
        otherResult.addRow(new String[]{"test3", "test4"});
        otherResult.addRow(new String[]{"test5", "test6"});
        MockResultSetTest.assertFalse((boolean)this.resultSet.isEqual(otherResult));
        MockResultSetTest.assertFalse((boolean)otherResult.isEqual(this.resultSet));
        ArrayList<Object> testList = new ArrayList<Object>();
        testList.add("test3");
        testList.add("test4");
        MockResultSetTest.assertTrue((boolean)otherResult.isRowEqual(2, testList));
        MockResultSetTest.assertFalse((boolean)otherResult.isRowEqual(1, testList));
        MockResultSetTest.assertFalse((boolean)otherResult.isColumnEqual(1, testList));
        otherResult.addColumn("col1");
        otherResult = new MockResultSet("");
        otherResult.setResultSetConcurrency(1008);
        otherResult.addColumn("col1");
        otherResult.addRow(new String[]{"test1", "test2"});
        otherResult.addRow(new String[]{"test3", "test4"});
        otherResult.addRow(new String[]{"test5", "test6"});
        MockResultSetTest.assertTrue((boolean)this.resultSet.isEqual(otherResult));
        MockResultSetTest.assertTrue((boolean)otherResult.isEqual(this.resultSet));
        testList = new ArrayList();
        testList.add("test1");
        testList.add("test3");
        testList.add("test5");
        MockResultSetTest.assertTrue((boolean)otherResult.isColumnEqual(1, testList));
        MockResultSetTest.assertTrue((boolean)otherResult.isColumnEqual("col1", testList));
        this.resultSet.next();
        this.resultSet.next();
        this.resultSet.updateClob(1, (Clob)new MockClob("Test"));
        testList = new ArrayList();
        testList.add("test1");
        testList.add(new MockClob("Test"));
        testList.add("test5");
        MockResultSetTest.assertTrue((boolean)this.resultSet.isColumnEqual("col1", testList));
        this.resultSet.setDatabaseView(true);
        MockResultSetTest.assertFalse((boolean)this.resultSet.isColumnEqual("col1", testList));
        this.resultSet.updateRow();
        MockResultSetTest.assertTrue((boolean)this.resultSet.isColumnEqual("col1", testList));
        otherResult.next();
        otherResult.next();
        otherResult.updateClob(1, (Clob)new MockClob("Test"));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isEqual(otherResult));
        MockResultSetTest.assertTrue((boolean)otherResult.isEqual(this.resultSet));
        otherResult.setDatabaseView(true);
        MockResultSetTest.assertFalse((boolean)this.resultSet.isEqual(otherResult));
        MockResultSetTest.assertFalse((boolean)otherResult.isEqual(this.resultSet));
        otherResult.updateRow();
        MockResultSetTest.assertTrue((boolean)this.resultSet.isEqual(otherResult));
        MockResultSetTest.assertTrue((boolean)otherResult.isEqual(this.resultSet));
        otherResult = new MockResultSet("");
        otherResult.addRow(new Integer[]{new Integer(1), new Integer(2), new Integer(3)});
        otherResult.addRow(new Integer[]{new Integer(4), new Integer(5), new Integer(6)});
        otherResult.addRow(new Integer[]{new Integer(7), new Integer(8), new Integer(9)});
        testList = new ArrayList();
        testList.add("1");
        testList.add("4");
        testList.add("7");
        MockResultSetTest.assertTrue((boolean)otherResult.isColumnEqual(1, testList));
        testList = new ArrayList();
        testList.add("7");
        testList.add("8");
        testList.add("9");
        MockResultSetTest.assertTrue((boolean)otherResult.isRowEqual(3, testList));
        otherResult = new MockResultSet("");
        otherResult.addRow(new Object[]{new Integer[]{new Integer(1), new Integer(2)}});
        testList = new ArrayList();
        testList.add(new Integer[]{new Integer(1), new Integer(2)});
        MockResultSetTest.assertTrue((boolean)otherResult.isRowEqual(1, testList));
    }

    public void testIsEqualNotAssignableAndNull() throws Exception {
        this.resultSet.addColumn("col1");
        this.resultSet.addColumn("col2");
        this.resultSet.addRow(new Object[]{new Integer(1), null});
        ArrayList<String> rowList = new ArrayList<String>();
        rowList.add("1");
        rowList.add(null);
        MockResultSetTest.assertTrue((boolean)this.resultSet.isRowEqual(1, rowList));
        ArrayList<String> columnList1 = new ArrayList<String>();
        columnList1.add("1");
        ArrayList<Object> columnList2 = new ArrayList<Object>();
        columnList2.add(null);
        MockResultSetTest.assertTrue((boolean)this.resultSet.isColumnEqual(1, columnList1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isColumnEqual(2, columnList2));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isColumnEqual("col1", columnList1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isColumnEqual("col2", columnList2));
        MockResultSet otherResult = new MockResultSet("");
        otherResult.addColumn("col1");
        otherResult.addColumn("col2");
        otherResult.addRow(new String[]{"1", null});
        MockResultSetTest.assertTrue((boolean)this.resultSet.isEqual(otherResult));
    }

    public void testRowsInsertedDeletedUpdated() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.addRow(new String[]{"test1", "test2"});
        this.resultSet.addRow(new String[]{"test3", "test4"});
        this.resultSet.addRow(new String[]{"test5", "test6"});
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(3));
        this.resultSet.next();
        this.resultSet.next();
        this.resultSet.deleteRow();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowDeleted(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(3));
        this.resultSet.next();
        this.resultSet.updateRow();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowDeleted(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(2));
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowUpdated(3));
        this.resultSet.moveToInsertRow();
        this.resultSet.updateString(1, "xyz");
        this.resultSet.updateString(2, "xyz");
        this.resultSet.insertRow();
        this.resultSet.moveToCurrentRow();
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(2));
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowInserted(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(4));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(1));
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowDeleted(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(3));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(4));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(2));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(3));
        MockResultSetTest.assertTrue((boolean)this.resultSet.rowUpdated(4));
    }

    public void testRowsInsertDeleteUpdateNotAllowed() throws Exception {
        this.resultSet.addRow(new String[]{"test1", "test2"});
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(1));
        this.resultSet.next();
        try {
            this.resultSet.deleteRow();
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(1));
        try {
            this.resultSet.updateRow();
            MockResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(1));
        this.resultSet.moveToInsertRow();
        try {
            this.resultSet.insertRow();
            MockResultSetTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowInserted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowDeleted(1));
        MockResultSetTest.assertFalse((boolean)this.resultSet.rowUpdated(1));
    }

    public void testCloneAndIsEqual() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.addRow(new String[]{"test1", "test2"});
        this.resultSet.addRow(new String[]{"test3", "test4"});
        this.resultSet.addRow(new Object[]{new MockClob("test5"), new MockStruct("test6")});
        MockResultSet cloneResult = (MockResultSet)this.resultSet.clone();
        MockResultSetTest.assertTrue((boolean)this.resultSet.isEqual(cloneResult));
        this.resultSet.next();
        this.resultSet.next();
        this.resultSet.next();
        this.resultSet.updateClob(1, (Clob)new MockClob("test"));
        MockResultSetTest.assertFalse((boolean)this.resultSet.isEqual(cloneResult));
        this.resultSet.setDatabaseView(true);
        MockResultSetTest.assertTrue((boolean)this.resultSet.isEqual(cloneResult));
        this.resultSet.updateRow();
        MockResultSetTest.assertFalse((boolean)this.resultSet.isEqual(cloneResult));
        this.resultSet.setDatabaseView(false);
        MockClob clob = (MockClob)this.resultSet.getClob(1);
        MockResultSetTest.assertEquals((String)"test", (String)clob.getSubString(1L, 4));
        clob.setString(1L, "xyzx");
        MockResultSetTest.assertEquals((String)"xyzx", (String)clob.getSubString(1L, 4));
        ArrayList<Cloneable> list = new ArrayList<Cloneable>();
        list.add(new MockClob("xyzx"));
        list.add(new MockStruct("test6"));
        MockResultSetTest.assertTrue((boolean)this.resultSet.isRowEqual(3, list));
        MockResultSetTest.assertFalse((boolean)cloneResult.isRowEqual(3, list));
        list = new ArrayList();
        list.add(new MockClob("test5"));
        list.add(new MockStruct("test6"));
        MockResultSetTest.assertTrue((boolean)cloneResult.isRowEqual(3, list));
    }

    public void testCloneDeepCopyMetaData() throws Exception {
        MockResultSetMetaData metaData1 = new MockResultSetMetaData();
        this.resultSet.setResultSetMetaData(metaData1);
        MockResultSet cloneResult = (MockResultSet)this.resultSet.clone();
        MockResultSetTest.assertTrue((boolean)this.resultSet.isEqual(cloneResult));
        MockResultSetTest.assertNotSame((Object)metaData1, (Object)cloneResult.getMetaData());
    }

    public void testCaseInsensitiveColumns() throws Exception {
        this.resultSet.setResultSetConcurrency(1008);
        this.resultSet.addColumn("first", new String[]{"1", "2", "3"});
        this.resultSet.addColumn("second", new String[]{"4", "5", "6"});
        this.resultSet.addColumn("third", new String[]{"7", "true", "9"});
        this.resultSet.next();
        MockResultSetTest.assertEquals((String)"1", (String)this.resultSet.getString("FIRST"));
        MockResultSetTest.assertEquals((String)"4", (String)this.resultSet.getString("second"));
        MockResultSetTest.assertEquals((int)7, (int)this.resultSet.getInt("Third"));
        this.resultSet.next();
        MockResultSetTest.assertEquals((Object)"2", (Object)this.resultSet.getObject("FirsT"));
        MockResultSetTest.assertEquals((String)"5", (String)this.resultSet.getString("sEcond"));
        MockResultSetTest.assertEquals((boolean)true, (boolean)this.resultSet.getBoolean("THIRD"));
        this.resultSet.next();
        this.resultSet.setDatabaseView(true);
        MockResultSetTest.assertEquals((String)"3", (String)this.resultSet.getString("FIrST"));
        MockResultSetTest.assertEquals((double)6.0, (double)this.resultSet.getDouble("second"), (double)0.0);
        MockResultSetTest.assertEquals((int)9, (int)this.resultSet.getInt("ThiRd"));
        this.resultSet.moveToInsertRow();
        this.resultSet.updateString("FIRST", "x");
        this.resultSet.insertRow();
        this.resultSet.moveToCurrentRow();
        MockResultSetTest.assertEquals((String)"x", (String)this.resultSet.getString("first"));
    }

    public void testCaseSensitiveColumns() throws Exception {
        this.resultSet.setColumnsCaseSensitive(true);
        this.resultSet.addColumn("first", new String[]{"1"});
        this.resultSet.next();
        MockResultSetTest.assertEquals((String)"1", (String)this.resultSet.getString("first"));
        try {
            this.resultSet.getString("FIRST");
            MockResultSetTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

