/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.PolyResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class PolyResultSetTest
extends TestCase {
    private List getTestResultSetList() {
        ArrayList<MockResultSet> list = new ArrayList<MockResultSet>();
        MockResultSet resultSet1 = new MockResultSet("id1");
        resultSet1.addRow(new String[]{"id1row1column1", "id1row1column2"});
        resultSet1.addRow(new String[]{"id1row2column1", "id1row2column2"});
        MockResultSet resultSet2 = new MockResultSet("id2");
        resultSet1.addRow(new String[]{"id2row1column1", "id2row1column2"});
        MockResultSet resultSet3 = new MockResultSet("id3");
        resultSet1.addRow(new String[]{"id3row1column1", "id3row1column2"});
        resultSet1.addRow(new String[]{"id3row2column1", "id3row2column2"});
        resultSet1.addRow(new String[]{"id3row3column1", "id3row3column2"});
        list.add(resultSet1);
        list.add(resultSet2);
        list.add(resultSet3);
        return list;
    }

    public void testGetUnderlyingResultSetList() {
        PolyResultSet resultSet = new PolyResultSet(this.getTestResultSetList());
        List resultSetList = resultSet.getUnderlyingResultSetList();
        PolyResultSetTest.assertEquals((int)3, (int)resultSetList.size());
        MockResultSet resultSet1 = (MockResultSet)resultSetList.get(0);
        MockResultSet resultSet2 = (MockResultSet)resultSetList.get(1);
        MockResultSet resultSet3 = (MockResultSet)resultSetList.get(2);
        PolyResultSetTest.assertEquals((String)"id1", (String)resultSet1.getId());
        PolyResultSetTest.assertEquals((String)"id2", (String)resultSet2.getId());
        PolyResultSetTest.assertEquals((String)"id3", (String)resultSet3.getId());
    }

    public void testNext() throws Exception {
        PolyResultSet resultSet = new PolyResultSet(new ArrayList());
        PolyResultSetTest.assertFalse((boolean)resultSet.next());
        PolyResultSetTest.assertFalse((boolean)resultSet.next());
        resultSet = new PolyResultSet(this.getTestResultSetList());
        PolyResultSetTest.assertTrue((boolean)resultSet.next());
        PolyResultSetTest.assertEquals((String)"id1row1column1", (String)resultSet.getString(1));
        PolyResultSetTest.assertEquals((String)"id1row1column2", (String)resultSet.getString(2));
        PolyResultSetTest.assertTrue((boolean)resultSet.next());
        PolyResultSetTest.assertEquals((String)"id1row2column1", (String)resultSet.getString(1));
        PolyResultSetTest.assertEquals((String)"id1row2column2", (String)resultSet.getString(2));
        PolyResultSetTest.assertTrue((boolean)resultSet.next());
        PolyResultSetTest.assertEquals((String)"id2row1column1", (String)resultSet.getString(1));
        PolyResultSetTest.assertEquals((String)"id2row1column2", (String)resultSet.getString(2));
        PolyResultSetTest.assertTrue((boolean)resultSet.next());
        PolyResultSetTest.assertEquals((String)"id3row1column1", (String)resultSet.getString(1));
        PolyResultSetTest.assertEquals((String)"id3row1column2", (String)resultSet.getString(2));
        PolyResultSetTest.assertTrue((boolean)resultSet.next());
        PolyResultSetTest.assertEquals((String)"id3row2column1", (String)resultSet.getString(1));
        PolyResultSetTest.assertEquals((String)"id3row2column2", (String)resultSet.getString(2));
        PolyResultSetTest.assertTrue((boolean)resultSet.next());
        PolyResultSetTest.assertEquals((String)"id3row3column1", (String)resultSet.getString(1));
        PolyResultSetTest.assertEquals((String)"id3row3column2", (String)resultSet.getString(2));
        PolyResultSetTest.assertFalse((boolean)resultSet.next());
        PolyResultSetTest.assertFalse((boolean)resultSet.next());
    }

    public void testIllegalMethods() throws Exception {
        PolyResultSet resultSet = new PolyResultSet(this.getTestResultSetList());
        resultSet.next();
        try {
            resultSet.updateLong(1, 123L);
            PolyResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            resultSet.first();
            PolyResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            resultSet.setFetchDirection(1000);
            PolyResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            resultSet.updateString(2, "abc");
            PolyResultSetTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            resultSet.refreshRow();
            PolyResultSetTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

