/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.jdbc.SQLStatementMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;

public class SQLStatementMatcherTest
extends TestCase {
    public void testGetMatchingObjects() {
        HashMap<String, Object> testMap = new HashMap<String, Object>();
        testMap.put("Test1", "TestObject1");
        testMap.put("Test2", "TestObject2");
        ArrayList<String> testList = new ArrayList<String>();
        testList.add("TestList1");
        testList.add("TestList2");
        testList.add("TestList3");
        testMap.put("Test4", testList);
        SQLStatementMatcher matcher = new SQLStatementMatcher(true, false);
        List resultList = matcher.getMatchingObjects(testMap, "Test", false, false);
        SQLStatementMatcherTest.assertEquals((int)3, (int)resultList.size());
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject1"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject2"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains(testList));
    }

    public void testGetMatchingObjectsRegEx() {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("Test1", "TestObject1");
        testMap.put("Test2", "TestObject2");
        SQLStatementMatcher matcher = new SQLStatementMatcher(true, false, true);
        List resultList = matcher.getMatchingObjects(testMap, "Test.*", false, false);
        SQLStatementMatcherTest.assertEquals((int)2, (int)resultList.size());
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject1"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject2"));
        resultList = matcher.getMatchingObjects(testMap, "test.*", false, false);
        SQLStatementMatcherTest.assertEquals((int)0, (int)resultList.size());
    }

    public void testGetMatchingObjectsResolveCollection() {
        HashMap<String, Object> testMap = new HashMap<String, Object>();
        testMap.put("Test1", "TestObject1");
        testMap.put("Test2", "TestObject2");
        testMap.put("Test3", "TestObject3");
        testMap.put("Test", "TestObject");
        SQLStatementMatcher matcher = new SQLStatementMatcher(true, true);
        List resultList = matcher.getMatchingObjects(testMap, "Test", true, false);
        SQLStatementMatcherTest.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject"));
        SQLStatementMatcherTest.assertFalse((boolean)resultList.contains("TestObject1"));
        SQLStatementMatcherTest.assertFalse((boolean)resultList.contains("TestObject2"));
        SQLStatementMatcherTest.assertFalse((boolean)resultList.contains("TestObject3"));
        matcher = new SQLStatementMatcher(true, false);
        resultList = matcher.getMatchingObjects(testMap, "Test", true, false);
        SQLStatementMatcherTest.assertTrue((resultList.size() == 4 ? 1 : 0) != 0);
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject1"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject2"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject3"));
        matcher = new SQLStatementMatcher(true, false);
        resultList = matcher.getMatchingObjects(testMap, "test", true, false);
        SQLStatementMatcherTest.assertTrue((boolean)resultList.isEmpty());
        matcher = new SQLStatementMatcher(false, false);
        resultList = matcher.getMatchingObjects(testMap, "test", true, false);
        SQLStatementMatcherTest.assertTrue((resultList.size() == 4 ? 1 : 0) != 0);
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject1"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject2"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject3"));
        ArrayList<String> testList = new ArrayList<String>();
        testList.add("TestList1");
        testList.add("TestList2");
        testList.add("TestList3");
        testMap.put("Test4", testList);
        matcher = new SQLStatementMatcher(true, false);
        resultList = matcher.getMatchingObjects(testMap, "", true, false);
        SQLStatementMatcherTest.assertTrue((resultList.size() == 7 ? 1 : 0) != 0);
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject1"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject2"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject3"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestList1"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestList2"));
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestList3"));
        matcher = new SQLStatementMatcher(true, false);
        resultList = matcher.getMatchingObjects(testMap, "", true, true);
        SQLStatementMatcherTest.assertTrue((boolean)resultList.isEmpty());
        matcher = new SQLStatementMatcher(true, false);
        resultList = matcher.getMatchingObjects(testMap, "TestObjectObject", true, true);
        SQLStatementMatcherTest.assertTrue((resultList.size() == 1 ? 1 : 0) != 0);
        SQLStatementMatcherTest.assertTrue((boolean)resultList.contains("TestObject"));
    }

    public void testGetMatchingObjectsResolveCollectionRegEx() {
        HashMap<String, Object> testMap = new HashMap<String, Object>();
        testMap.put("Test1", "TestObject1");
        testMap.put("Test2", "TestObject2");
        ArrayList<String> testList = new ArrayList<String>();
        testList.add("TestList1");
        testList.add("TestList2");
        testList.add("TestList3");
        testMap.put("Test3", testList);
        SQLStatementMatcher matcher = new SQLStatementMatcher(true, false, true);
        List resultList = matcher.getMatchingObjects(testMap, "[T].*", true, false);
        SQLStatementMatcherTest.assertEquals((int)5, (int)resultList.size());
    }

    public void testContains() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("TestString1");
        list.add("TestString2");
        list.add("TestString3");
        SQLStatementMatcher matcher = new SQLStatementMatcher(false, false);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.contains(list, "TESTSTRING", false));
        matcher = new SQLStatementMatcher(true, false);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.contains(list, "TESTSTRING", false));
        matcher = new SQLStatementMatcher(false, true);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.contains(list, "TESTSTRING", false));
        matcher = new SQLStatementMatcher(true, true);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.contains(list, "TestString3", false));
        matcher = new SQLStatementMatcher(true, true);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.contains(list, "TestString4", false));
        matcher = new SQLStatementMatcher(false, false);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.contains(list, "TestString4", false));
        matcher = new SQLStatementMatcher(false, false);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.contains(list, "TESTSTRING1XYZ", false));
        matcher = new SQLStatementMatcher(false, false);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.contains(list, "TESTSTRING1XYZ", true));
        matcher = new SQLStatementMatcher(true, false);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.contains(list, "TEstString3Test", true));
        matcher = new SQLStatementMatcher(false, false);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.contains(list, "TEstString3Test", true));
    }

    public void testContainsRegEx() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("TestString1");
        list.add("TestString2");
        list.add("TestString3");
        SQLStatementMatcher matcher = new SQLStatementMatcher(false, false, true);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.contains(list, "TESTSTRING.", false));
        SQLStatementMatcherTest.assertTrue((boolean)matcher.contains(list, ".*", false));
        SQLStatementMatcherTest.assertFalse((boolean)matcher.contains(list, "...", false));
        list = new ArrayList();
        list.add("TestString..");
        SQLStatementMatcherTest.assertTrue((boolean)matcher.contains(list, "TESTSTRING11", true));
        SQLStatementMatcherTest.assertFalse((boolean)matcher.contains(list, "TESTSTRING1", true));
    }

    public void testDoStringsMatch() {
        SQLStatementMatcher matcher = new SQLStatementMatcher(true, false);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.doStringsMatch("X", "x"));
        matcher = new SQLStatementMatcher(false, true);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch("X", "x"));
        matcher = new SQLStatementMatcher(false, false);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch("Test", "tes"));
        matcher = new SQLStatementMatcher(true, false);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.doStringsMatch("Test", "tes"));
        matcher = new SQLStatementMatcher(true, false);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch("Test", ""));
        matcher = new SQLStatementMatcher(true, false);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch("Test", null));
        matcher = new SQLStatementMatcher(false, true);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.doStringsMatch("Test", null));
        matcher = new SQLStatementMatcher(true, true);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch(null, null));
        matcher = new SQLStatementMatcher(true, true);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch("ThisIsATest", "ThisIsATest"));
    }

    public void testDoStringsMatchRegEx() {
        SQLStatementMatcher matcher = new SQLStatementMatcher(true, false, true);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.doStringsMatch("X", "x"));
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch("AbcDef", ".*"));
        SQLStatementMatcherTest.assertFalse((boolean)matcher.doStringsMatch("AbcDef", "a.*"));
        matcher = new SQLStatementMatcher(false, false, true);
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch("AbcDef", "a.*"));
        SQLStatementMatcherTest.assertTrue((boolean)matcher.doStringsMatch("myTest", "[nmg]ytest"));
        SQLStatementMatcherTest.assertFalse((boolean)matcher.doStringsMatch("dyTest", "[nmg]ytest"));
        matcher = new SQLStatementMatcher(true, true, true);
        SQLStatementMatcherTest.assertFalse((boolean)matcher.doStringsMatch("myTest", "[nmg]ytest"));
    }
}

