/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.PropertiesProvider;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.git.GitLookup;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CopyrightAuthorProvider
implements PropertiesProvider {
    public static final String COPYRIGHT_CREATION_AUTHOR_NAME_KEY = "license.git.CreationAuthorName";
    public static final String COPYRIGHT_CREATION_AUTHOR_EMAIL_KEY = "license.git.CreationAuthorEmail";
    private GitLookup gitLookup;

    public void init(AbstractLicenseMojo mojo, Map<String, String> currentProperties) {
        this.gitLookup = GitLookup.create(mojo.defaultBasedir, currentProperties);
        if (mojo.warnIfShallow && this.gitLookup.isShallowRepository()) {
            mojo.warn("Shallow git repository detected. Author property values may not be accurate.", new Object[0]);
        }
    }

    public void close() {
        if (this.gitLookup != null) {
            this.gitLookup.close();
        }
    }

    public Map<String, String> adjustProperties(AbstractLicenseMojo mojo, Map<String, String> properties, Document document) {
        try {
            HashMap<String, String> result = new HashMap<String, String>(3);
            result.put(COPYRIGHT_CREATION_AUTHOR_NAME_KEY, this.gitLookup.getAuthorNameOfCreation(document.getFile()));
            result.put(COPYRIGHT_CREATION_AUTHOR_EMAIL_KEY, this.gitLookup.getAuthorEmailOfCreation(document.getFile()));
            return Collections.unmodifiableMap(result);
        }
        catch (IOException e) {
            throw new UncheckedIOException("CopyrightAuthorProvider error on file: " + document.getFile().getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }
}

