/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.header;

import java.util.regex.Pattern;

public final class HeaderDefinition {
    private final String type;
    private String firstLine = "";
    private String beforeEachLine = "";
    private String endLine = "";
    private String afterEachLine = "";
    private Boolean allowBlankLines;
    private Pattern skipLinePattern;
    private Pattern firstLineDetectionPattern;
    private Pattern lastLineDetectionPattern;
    private Boolean isMultiline;
    private boolean padLines = false;

    public HeaderDefinition(String type, String firstLine, String beforeEachLine, String endLine, String afterEachLine, String skipLinePattern, String firstLineDetectionPattern, String lastLineDetectionPattern, boolean allowBlankLines, boolean isMultiline, boolean padLines) {
        this(type);
        this.firstLine = firstLine;
        this.beforeEachLine = beforeEachLine;
        this.endLine = endLine;
        this.afterEachLine = afterEachLine;
        this.skipLinePattern = this.compile(skipLinePattern);
        this.firstLineDetectionPattern = this.compile(firstLineDetectionPattern);
        this.lastLineDetectionPattern = this.compile(lastLineDetectionPattern);
        this.allowBlankLines = allowBlankLines;
        this.isMultiline = isMultiline;
        this.padLines = padLines;
        if (!"unknown".equals(type)) {
            this.validate();
        }
    }

    public HeaderDefinition(String type) {
        if (type == null) {
            throw new IllegalArgumentException("The type of a header definition cannot be null");
        }
        this.type = type.toLowerCase();
    }

    private Pattern compile(String regexp) {
        return regexp == null ? null : Pattern.compile(regexp);
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public String getBeforeEachLine() {
        return this.beforeEachLine;
    }

    public String getEndLine() {
        return this.endLine;
    }

    public String getAfterEachLine() {
        return this.afterEachLine;
    }

    public String getType() {
        return this.type;
    }

    public boolean allowBlankLines() {
        return this.allowBlankLines;
    }

    public boolean isPadLines() {
        return this.padLines;
    }

    public boolean isSkipLine(String line) {
        return this.skipLinePattern != null && line != null && this.skipLinePattern.matcher(line).matches();
    }

    public boolean isFirstHeaderLine(String line) {
        return this.firstLineDetectionPattern != null && line != null && this.firstLineDetectionPattern.matcher(line).matches();
    }

    public boolean isLastHeaderLine(String line) {
        return this.lastLineDetectionPattern != null && line != null && this.lastLineDetectionPattern.matcher(line).matches();
    }

    protected Pattern getSkipLinePattern() {
        return this.skipLinePattern;
    }

    public void setPropertyFromString(String property, String value) {
        if (this.isEmpty(value)) {
            throw new IllegalArgumentException("The value cannot be empty for XML tag " + property + " for type " + this.type);
        }
        if ("firstLine".equalsIgnoreCase(property)) {
            this.firstLine = value;
        } else if ("allowBlankLines".equalsIgnoreCase(property)) {
            this.allowBlankLines = Boolean.valueOf(value);
        } else if ("isMultiline".equalsIgnoreCase(property)) {
            this.isMultiline = Boolean.valueOf(value);
        } else if ("beforeEachLine".equalsIgnoreCase(property)) {
            this.beforeEachLine = value;
        } else if ("endLine".equalsIgnoreCase(property)) {
            this.endLine = value;
        } else if ("afterEachLine".equalsIgnoreCase(property)) {
            this.afterEachLine = value;
        } else if ("skipLine".equalsIgnoreCase(property)) {
            this.skipLinePattern = this.compile(value);
        } else if ("padLines".equalsIgnoreCase(property)) {
            this.padLines = Boolean.parseBoolean(value);
        } else if ("firstLineDetectionPattern".equalsIgnoreCase(property)) {
            this.firstLineDetectionPattern = this.compile(value);
        } else if ("lastLineDetectionPattern".equalsIgnoreCase(property)) {
            this.lastLineDetectionPattern = this.compile(value);
        }
    }

    public void validate() {
        this.check("firstLine", this.firstLine);
        this.check("beforeEachLine", this.beforeEachLine);
        this.check("endLine", this.endLine);
        this.check("afterEachLine", this.afterEachLine);
        this.check("firstLineDetectionPattern", this.firstLineDetectionPattern);
        this.check("lastLineDetectionPattern", this.lastLineDetectionPattern);
        this.check("isMultiline", this.isMultiline);
        this.check("allowBlankLines", this.allowBlankLines);
    }

    private void check(String name, Boolean value) {
        if (value == null) {
            throw new IllegalStateException(String.format("The property '%s' is missing for header definition '%s'", name, this.type));
        }
    }

    private void check(String name, String value) {
        if (value == null) {
            throw new IllegalStateException(String.format("The property '%s' is missing for header definition '%s'", name, this.type));
        }
    }

    private void check(String name, Pattern value) {
        if (this.isEmpty(value.pattern())) {
            throw new IllegalStateException(String.format("The property '%s' is missing for header definition '%s'", name, this.type));
        }
    }

    private boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeaderDefinition that = (HeaderDefinition)o;
        return !(this.type == null ? that.type != null : !this.type.equals(that.type));
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public String toString() {
        return this.type;
    }

    public boolean isMultiLine() {
        return this.isMultiline;
    }
}

