/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.junit.concurrent;

import com.mycila.junit.concurrent.ConcurrentException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.runners.model.RunnerScheduler;

public final class ConcurrentRunnerScheduler
implements RunnerScheduler {
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    private final ExecutorService executorService;
    private final Queue<Future<Void>> tasks = new LinkedList<Future<Void>>();
    private final CompletionService<Void> completionService;

    public ConcurrentRunnerScheduler(String name, int threads) {
        this(name, Math.min(CPUS, threads), Math.max(CPUS, threads));
    }

    public ConcurrentRunnerScheduler(String name, int nThreadsMin, int nThreadsMax) {
        this.executorService = new ThreadPoolExecutor(nThreadsMin, nThreadsMax, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(name), new ThreadPoolExecutor.CallerRunsPolicy());
        this.completionService = new ExecutorCompletionService<Void>(this.executorService);
    }

    public void schedule(Runnable childStatement) {
        this.tasks.offer(this.completionService.submit(childStatement, null));
    }

    public void finished() throws ConcurrentException {
        try {
            while (!this.tasks.isEmpty()) {
                Future<Void> f = this.completionService.take();
                this.tasks.remove(f);
                f.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw ConcurrentException.wrap(e.getCause());
        }
        finally {
            while (!this.tasks.isEmpty()) {
                this.tasks.poll().cancel(true);
            }
            this.executorService.shutdownNow();
        }
    }

    private static final class NamedThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final ThreadGroup group;

        NamedThreadFactory(String poolName) {
            this.group = new ThreadGroup(poolName + " Group-" + poolNumber.getAndIncrement());
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(this.group, r, this.group.getName() + "-Thread-" + this.threadNumber.getAndIncrement(), 0L);
        }
    }
}

