/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

final class CachedEntityResolver
implements EntityResolver,
EntityResolver2 {
    static final CachedEntityResolver instance = new CachedEntityResolver();
    private Map<String, String> cache = new LinkedHashMap<String, String>();

    private CachedEntityResolver() {
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        return this.resolveEntity(publicId, systemId);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String content = this.cache.get(systemId);
        if (content == null) {
            content = this.read(systemId);
            this.cache.put(systemId, content);
        }
        return new InputSource(new StringReader(content));
    }

    private String read(String url) {
        try {
            int c;
            URL u = new URL(url);
            URLConnection con = u.openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            con.setDefaultUseCaches(true);
            con.setUseCaches(true);
            con.connect();
            StringWriter sw = new StringWriter();
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(con.getInputStream()), con.getContentEncoding() != null ? con.getContentEncoding() : "UTF-8"));
            char[] buffer = new char[8192];
            while ((c = br.read(buffer)) != -1) {
                sw.write(buffer, 0, c);
            }
            return sw.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

