/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import com.mycila.xmltool.CallBack;
import com.mycila.xmltool.IteratorAdapter;
import com.mycila.xmltool.Utils;
import com.mycila.xmltool.ValidationResult;
import com.mycila.xmltool.XMLDocBuilder;
import com.mycila.xmltool.XMLDocDefinition;
import com.mycila.xmltool.XMLDocumentException;
import com.mycila.xmltool.XMLTag;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class XMLDoc
implements XMLTag {
    private final XMLDocDefinition definition;
    Element current;

    XMLDoc(XMLDocDefinition definition) {
        this.definition = definition;
        this.current = definition.getRoot();
    }

    @Override
    public NamespaceContext getContext() {
        return this.definition;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.current.hasAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name, String relativeXpath, Object ... arguments) {
        Element old = this.current;
        try {
            boolean bl = this.gotoTag(relativeXpath, arguments).hasAttribute(name);
            return bl;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public boolean hasTag(String relativeXpath, Object ... arguments) {
        Element old = this.current;
        try {
            this.gotoTag(relativeXpath, arguments);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public XMLTag forEachChild(CallBack callBack) {
        Utils.notNull("Callback", callBack);
        Element old = this.current;
        try {
            Iterator<Element> iterator = this.getChildElement().iterator();
            while (iterator.hasNext()) {
                Element node;
                this.current = node = iterator.next();
                callBack.execute(this);
            }
            XMLDoc xMLDoc = this;
            return xMLDoc;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public XMLTag forEach(CallBack callBack, String relativeXpath, Object ... arguments) {
        Utils.notNull("Callback", callBack);
        Element old = this.current;
        try {
            Node[] nodes = this.definition.getXpath().findNodes(this.current, relativeXpath, arguments);
            ArrayList<Element> els = new ArrayList<Element>(nodes.length);
            Node[] nodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                if (this.isElement(node)) {
                    els.add((Element)node);
                }
                ++n2;
            }
            Iterator iterator = els.iterator();
            while (iterator.hasNext()) {
                Element element;
                this.current = element = (Element)iterator.next();
                callBack.execute(this);
            }
            XMLDoc xMLDoc = this;
            return xMLDoc;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public XMLTag forEach(String xpath, CallBack callBack) {
        return this.forEach(callBack, xpath, new Object[0]);
    }

    @Override
    public String rawXpathString(String relativeXpath, Object ... arguments) {
        return this.definition.getXpath().rawXpathString(this.current, relativeXpath, arguments);
    }

    @Override
    public Number rawXpathNumber(String relativeXpath, Object ... arguments) {
        return this.definition.getXpath().rawXpathNumber(this.current, relativeXpath, arguments);
    }

    @Override
    public Boolean rawXpathBoolean(String relativeXpath, Object ... arguments) {
        return this.definition.getXpath().rawXpathBoolean(this.current, relativeXpath, arguments);
    }

    @Override
    public Node rawXpathNode(String relativeXpath, Object ... arguments) {
        return this.definition.getXpath().rawXpathNode(this.current, relativeXpath, arguments);
    }

    @Override
    public NodeList rawXpathNodeSet(String relativeXpath, Object ... arguments) {
        return this.definition.getXpath().rawXpathNodeSet(this.current, relativeXpath, arguments);
    }

    @Override
    public String getPefix(String namespaceURI) {
        Utils.notNull("namespaceURI", namespaceURI);
        String prefix = this.getContext().getPrefix(namespaceURI);
        return prefix == null ? "" : prefix;
    }

    @Override
    public String[] getPefixes(String namespaceURI) {
        Utils.notNull("namespaceURI", namespaceURI);
        TreeSet<String> prefixes = new TreeSet<String>();
        Iterator<String> i = this.getContext().getPrefixes(namespaceURI);
        while (i.hasNext()) {
            prefixes.add(i.next());
        }
        return prefixes.toArray(new String[prefixes.size()]);
    }

    @Override
    public XMLTag addNamespace(String prefix, String namespaceURI) {
        this.definition.addNamespace(prefix, namespaceURI);
        return this;
    }

    @Override
    public XMLTag addDocument(XMLTag tag) {
        Utils.notNull("XMLTag instance", tag);
        return this.addDocument(tag.toDocument());
    }

    @Override
    public XMLTag addDocument(Document doc) {
        Utils.notNull("DOM Document", doc);
        this.current.appendChild(this.current.getOwnerDocument().importNode(doc.getDocumentElement(), true));
        return this;
    }

    @Override
    public XMLTag addTag(XMLTag tag) {
        Utils.notNull("XMLTag instance", tag);
        return this.addTag(tag.getCurrentTag());
    }

    @Override
    public XMLTag addTag(Element tag) {
        Utils.notNull("DOM Element", tag);
        this.current.appendChild(this.current.getOwnerDocument().importNode(tag, true));
        return this;
    }

    @Override
    public XMLTag addTag(String name) {
        Element el = this.definition.createElement(name);
        this.current.appendChild(el);
        this.current = el;
        return this;
    }

    @Override
    public XMLTag addAttribute(String name, String value) {
        if (this.hasAttribute(name)) {
            throw new XMLDocumentException("Attribute '%s' already exist on tag '%s'", name, this.getCurrentTagName());
        }
        this.definition.createAttribute(this.current, name, value);
        return this;
    }

    @Override
    public XMLTag addAttribute(Attr attr) {
        Utils.notNull("DOM Attribute", attr);
        if (this.hasAttribute(attr.getName())) {
            throw new XMLDocumentException("Attribute '%s' already exist on tag '%s'", attr.getName(), this.getCurrentTagName());
        }
        this.current.setAttributeNodeNS((Attr)this.current.getOwnerDocument().importNode(attr, true));
        return this;
    }

    @Override
    public XMLTag addText(String text) {
        this.current.appendChild(this.definition.createText(text));
        return this.gotoParent();
    }

    @Override
    public XMLTag addText(Text text) {
        Utils.notNull("DOM Text node", text);
        this.current.appendChild(this.current.getOwnerDocument().importNode(text, true));
        return this.gotoParent();
    }

    @Override
    public XMLTag addCDATA(String data) {
        this.current.appendChild(this.definition.createCDATA(data));
        return this.gotoParent();
    }

    @Override
    public XMLTag addCDATA(CDATASection data) {
        Utils.notNull("DOM CDATA node", data);
        this.current.appendChild(this.current.getOwnerDocument().importNode(data, true));
        return this.gotoParent();
    }

    @Override
    public XMLTag delete() {
        if (this.current == this.definition.getRoot()) {
            throw new XMLDocumentException("Cannot delete root node '%s'", this.getCurrentTagName());
        }
        Element toDelete = this.current;
        this.gotoParent();
        this.current.removeChild(toDelete);
        return this;
    }

    @Override
    public XMLTag deleteChilds() {
        List<Element> toDelete = this.getChildElement();
        for (Element node : toDelete) {
            this.current.removeChild(node);
        }
        return this;
    }

    @Override
    public XMLTag deleteAttributes() {
        List<Attr> attrs = this.attr(this.current);
        for (Attr attr : attrs) {
            this.current.removeAttributeNode(attr);
        }
        return this;
    }

    @Override
    public XMLTag deleteAttribute(String name) {
        Utils.notEmpty("Attribute name", name);
        if (!this.hasAttribute(name)) {
            throw new XMLDocumentException("Cannot delete attribute '%s' from element '%s': attribute does noe exist", name, this.getCurrentTagName());
        }
        this.current.removeAttribute(name);
        return this;
    }

    @Override
    public XMLTag deleteAttributeIfExists(String name) {
        Utils.notEmpty("Attribute name", name);
        if (this.hasAttribute(name)) {
            this.current.removeAttribute(name);
        }
        return this;
    }

    @Override
    public XMLTag renameTo(String newNodeName) {
        Utils.notEmpty("Tag name", newNodeName);
        this.current = this.definition.rename(this.current, newNodeName);
        return this;
    }

    @Override
    public XMLTag deletePrefixes() {
        boolean ignoreNS = this.definition.isIgnoreNamespaces();
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(this.current);
        this.definition.resetNamespaces();
        while (!queue.isEmpty()) {
            Element tag = (Element)queue.poll();
            for (Attr attr : this.attr(tag)) {
                String attrName = attr.getNodeName();
                if ("xmlns".equals(attrName) || attrName.startsWith("xmlns:")) {
                    tag.removeAttributeNode(attr);
                    continue;
                }
                int pos = attrName.indexOf(":");
                if (pos == -1) continue;
                if (ignoreNS) {
                    this.definition.renameWithoutNS(attr, attrName.substring(pos + 1));
                    continue;
                }
                attr.setPrefix(null);
            }
            String tagName = tag.getTagName();
            int pos = tagName.indexOf(":");
            if (pos != -1) {
                tagName = tagName.substring(pos + 1);
            }
            if (this.current == tag) {
                this.current = tag = this.definition.renameWithoutNS(tag, tagName);
            } else {
                tag = this.definition.renameWithoutNS(tag, tagName);
            }
            for (Element element : this.childs(tag)) {
                queue.offer(element);
            }
        }
        this.definition.readNamespaces();
        return this;
    }

    @Override
    public XMLTag getInnerDocument() {
        return XMLDoc.fromCurrentTag(this, this.definition.isIgnoreNamespaces());
    }

    @Override
    public String getInnerText() {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("encoding", this.definition.getEncoding());
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            NodeList list = this.current.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                transformer.transform(new DOMSource(list.item(i)), new StreamResult(sw));
                ++i;
            }
            return sw.toString();
        }
        catch (TransformerException e) {
            throw new XMLDocumentException("Transformation error", e);
        }
    }

    @Override
    public XMLTag gotoParent() {
        Node n = this.current.getParentNode();
        if (this.current != this.definition.getRoot() && this.isElement(n)) {
            this.current = (Element)n;
        }
        return this;
    }

    @Override
    public XMLTag gotoRoot() {
        this.current = this.definition.getRoot();
        return this;
    }

    @Override
    public XMLTag gotoChild() {
        List<Element> els = this.childs(this.current);
        switch (els.size()) {
            case 0: {
                throw new XMLDocumentException("Current element '%s' has no child", this.getCurrentTagName());
            }
            case 1: {
                this.current = els.get(0);
                break;
            }
            default: {
                throw new XMLDocumentException("Cannot select child: current element '%s' has '%s' children", this.getCurrentTagName(), els.size());
            }
        }
        return this;
    }

    @Override
    public XMLTag gotoChild(int i) {
        List<Element> els = this.childs(this.current);
        if (i <= 0 || i > els.size()) {
            throw new XMLDocumentException("Cannot acces child '%s' of element '%s' amongst its '%s' childs", i, this.getCurrentTagName(), els.size());
        }
        this.current = els.get(i - 1);
        return this;
    }

    @Override
    public XMLTag gotoChild(String nodeName) {
        Utils.notEmpty("Tag name", nodeName);
        List<Element> els = this.childs(this.current);
        ArrayList<Element> found = new ArrayList<Element>(els.size());
        for (Element el : els) {
            if (!el.getTagName().equals(nodeName)) continue;
            found.add(el);
        }
        switch (found.size()) {
            case 0: {
                throw new XMLDocumentException("Current element '%s' has no child named '%s'", this.getCurrentTagName(), nodeName);
            }
            case 1: {
                this.current = (Element)found.get(0);
                break;
            }
            default: {
                throw new XMLDocumentException("Cannot select child: current element '%s' has '%s' children named '%s'", this.getCurrentTagName(), found.size(), nodeName);
            }
        }
        return this;
    }

    @Override
    public XMLTag gotoFirstChild() throws XMLDocumentException {
        List<Element> els = this.childs(this.current);
        if (els.isEmpty()) {
            throw new XMLDocumentException("Current element '%s' has no child", this.getCurrentTagName());
        }
        this.current = els.get(0);
        return this;
    }

    @Override
    public XMLTag gotoFirstChild(String name) throws XMLDocumentException {
        Utils.notEmpty("Tag name", name);
        List<Element> els = this.childs(this.current);
        if (els.isEmpty()) {
            throw new XMLDocumentException("Current element '%s' has no child", this.getCurrentTagName());
        }
        for (Element el : els) {
            if (!el.getTagName().equals(name)) continue;
            this.current = el;
            return this;
        }
        throw new XMLDocumentException("No child found in current tag '%s' having name '%s'", this.getCurrentTagName(), name);
    }

    @Override
    public XMLTag gotoLastChild() throws XMLDocumentException {
        List<Element> els = this.childs(this.current);
        if (els.isEmpty()) {
            throw new XMLDocumentException("Current element '%s' has no child", this.getCurrentTagName());
        }
        this.current = els.get(els.size() - 1);
        return this;
    }

    @Override
    public XMLTag gotoLastChild(String name) throws XMLDocumentException {
        Utils.notEmpty("Tag name", name);
        List<Element> els = this.childs(this.current);
        if (els.isEmpty()) {
            throw new XMLDocumentException("Current element '%s' has no child", this.getCurrentTagName());
        }
        int i = els.size() - 1;
        while (i >= 0) {
            if (els.get(i).getTagName().equals(name)) {
                this.current = els.get(i);
                return this;
            }
            --i;
        }
        throw new XMLDocumentException("No child found in current tag '%s' having name '%s'", this.getCurrentTagName(), name);
    }

    @Override
    public XMLTag gotoTag(String relativeXpath, Object ... arguments) {
        Node n = this.definition.getXpath().findNode(this.current, relativeXpath, arguments);
        if (!this.isElement(n)) {
            throw new XMLDocumentException("XPath expression '%s' does not target an element. Targeted node is '%s' (node type is '%s')", String.format(relativeXpath, arguments), n.getNodeName(), n.getNodeType());
        }
        this.current = (Element)n;
        return this;
    }

    @Override
    public Element getCurrentTag() {
        return this.current;
    }

    @Override
    public int getChildCount() {
        return this.getChildElement().size();
    }

    @Override
    public Iterable<XMLTag> getChilds() {
        final IteratorAdapter iterator = new IteratorAdapter(this, this.getChildElement().iterator());
        return new Iterable<XMLTag>(){

            @Override
            public Iterator<XMLTag> iterator() {
                return iterator;
            }
        };
    }

    @Override
    public Iterable<XMLTag> getChilds(String relativeXpath, Object ... arguments) {
        Node[] nodes = this.definition.getXpath().findNodes(this.current, relativeXpath, arguments);
        ArrayList<Element> els = new ArrayList<Element>(nodes.length);
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (this.isElement(node)) {
                els.add((Element)node);
            }
            ++n2;
        }
        final IteratorAdapter iterator = new IteratorAdapter(this, els.iterator());
        return new Iterable<XMLTag>(){

            @Override
            public Iterator<XMLTag> iterator() {
                return iterator;
            }
        };
    }

    @Override
    public List<Element> getChildElement() {
        return this.childs(this.current);
    }

    @Override
    public String getCurrentTagName() {
        return this.current.getTagName();
    }

    @Override
    public String getCurrentTagLocation() {
        StringBuilder sb = new StringBuilder();
        Element thisNode = this.current;
        while (thisNode != this.definition.getRoot()) {
            Element parent = (Element)thisNode.getParentNode();
            List<Element> els = this.childs(parent);
            int i = 0;
            while (i < els.size()) {
                if (els.get(i) == thisNode) {
                    sb.insert(0, "/*[" + (i + 1) + "]");
                    break;
                }
                ++i;
            }
            thisNode = parent;
        }
        return sb.length() == 0 ? "." : sb.deleteCharAt(0).toString();
    }

    @Override
    public String getAttribute(String name) {
        Utils.notEmpty("Attribute name", name);
        if (!this.hasAttribute(name)) {
            throw new XMLDocumentException("Element '%s' does not have attribute '%s'", this.getCurrentTagName(), name);
        }
        return this.current.getAttribute(name);
    }

    @Override
    public String findAttribute(String name) {
        Utils.notEmpty("Attribute name", name);
        return this.hasAttribute(name) ? this.current.getAttribute(name) : null;
    }

    @Override
    public String getAttribute(String name, String relativeXpath, Object ... arguments) {
        Element old = this.current;
        try {
            String string = this.gotoTag(relativeXpath, arguments).getAttribute(name);
            return string;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public String findAttribute(String name, String relativeXpath, Object ... arguments) throws XMLDocumentException {
        Element old = this.current;
        try {
            String string = this.gotoTag(relativeXpath, arguments).findAttribute(name);
            return string;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public String[] getAttributeNames() {
        List<Attr> attrs = this.attr(this.current);
        String[] names = new String[attrs.size()];
        int i = 0;
        while (i < attrs.size()) {
            names[i] = attrs.get(i).getName();
            ++i;
        }
        return names;
    }

    @Override
    public String getText(String relativeXpath, Object ... arguments) {
        Element old = this.current;
        try {
            String string = this.gotoTag(relativeXpath, arguments).getText();
            return string;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        List<Node> nodes = this.childs((short)3);
        for (Node node : nodes) {
            String val = node.getNodeValue();
            if (val == null) continue;
            sb.append(val);
        }
        return sb.toString();
    }

    @Override
    public String getTextOrCDATA() {
        String txt = this.getText();
        return "".equals(txt) ? this.getCDATA() : txt;
    }

    @Override
    public String getTextOrCDATA(String relativeXpath, Object ... arguments) throws XMLDocumentException {
        Element old = this.current;
        try {
            String string = this.gotoTag(relativeXpath, arguments).getTextOrCDATA();
            return string;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public String getCDATAorText() {
        String txt = this.getCDATA();
        return "".equals(txt) ? this.getText() : txt;
    }

    @Override
    public String getCDATAorText(String relativeXpath, Object ... arguments) throws XMLDocumentException {
        Element old = this.current;
        try {
            String string = this.gotoTag(relativeXpath, arguments).getCDATAorText();
            return string;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public String getCDATA(String relativeXpath, Object ... arguments) {
        Element old = this.current;
        try {
            String string = this.gotoTag(relativeXpath, arguments).getCDATA();
            return string;
        }
        finally {
            this.current = old;
        }
    }

    @Override
    public String getCDATA() {
        StringBuilder sb = new StringBuilder();
        List<Node> nodes = this.childs((short)4);
        for (Node node : nodes) {
            String val = ((CDATASection)node).getData();
            if (val == null) continue;
            sb.append(val);
        }
        return sb.toString();
    }

    @Override
    public Document toDocument() {
        return this.definition.getDocument();
    }

    @Override
    public Source toSource() {
        return new DOMSource(this.toDocument());
    }

    @Override
    public String toString() {
        return this.toString(this.definition.getEncoding());
    }

    @Override
    public String toString(String encoding) {
        StringWriter out = new StringWriter();
        this.toStream(out, encoding);
        return out.toString();
    }

    @Override
    public byte[] toBytes() {
        return this.toBytes(this.definition.getEncoding());
    }

    @Override
    public byte[] toBytes(String encoding) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toStream(out, encoding);
        return out.toByteArray();
    }

    @Override
    public XMLTag toStream(OutputStream out) {
        return this.toStream(out, this.definition.getEncoding());
    }

    @Override
    public XMLTag toStream(OutputStream out, String encoding) {
        Utils.notEmpty("encoding", encoding);
        try {
            return this.toStream(new BufferedWriter(new OutputStreamWriter(out, encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLDocumentException(e.getMessage(), e);
        }
    }

    @Override
    public XMLTag toStream(Writer out) {
        return this.toStream(out, this.definition.getEncoding());
    }

    @Override
    public XMLTag toStream(Writer out, String encoding) {
        Utils.notEmpty("encoding", encoding);
        return this.toResult(new StreamResult(out), encoding);
    }

    @Override
    public Result toResult() {
        DOMResult r = new DOMResult();
        this.toResult(r);
        return r;
    }

    @Override
    public Result toResult(String encoding) {
        DOMResult r = new DOMResult();
        this.toResult(r, encoding);
        return r;
    }

    @Override
    public OutputStream toOutputStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.toStream(baos);
        return baos;
    }

    @Override
    public OutputStream toOutputStream(String encoding) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.toStream(baos, encoding);
        return baos;
    }

    @Override
    public Writer toWriter() {
        StringWriter w = new StringWriter();
        this.toStream(w);
        return w;
    }

    @Override
    public Writer toWriter(String encoding) {
        StringWriter w = new StringWriter();
        this.toStream(w, encoding);
        return w;
    }

    @Override
    public XMLTag toResult(Result out) {
        return this.toResult(out, this.definition.getEncoding());
    }

    @Override
    public XMLTag toResult(Result out, String encoding) {
        Utils.notEmpty("encoding", encoding);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", 4);
            }
            catch (Exception exception) {}
            Transformer transformer = tf.newTransformer();
            transformer.setParameter("indent-number", 4);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", encoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", this.definition.getDocument().getXmlStandalone() ? "yes" : "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(this.toSource(), out);
            return this;
        }
        catch (TransformerException e) {
            throw new XMLDocumentException("Transformation error", e);
        }
    }

    @Override
    public ValidationResult validate(Source ... schemas) {
        Utils.notNull("schemas", schemas);
        try {
            return Utils.validate(this.toDocument(), schemas);
        }
        catch (Exception e) {
            throw new XMLDocumentException("Validation failed", e);
        }
    }

    @Override
    public ValidationResult validate(URL ... schemaLocations) {
        Utils.notNull("schemaLocations", schemaLocations);
        try {
            return Utils.validate(this.toDocument(), schemaLocations);
        }
        catch (Exception e) {
            throw new XMLDocumentException("Validation failed", e);
        }
    }

    private boolean isElement(Node n) {
        return n != null && n.getNodeType() == 1;
    }

    private List<Element> childs(Element e) {
        NodeList list = e.getChildNodes();
        ArrayList<Element> els = new ArrayList<Element>(list.getLength());
        int i = 0;
        while (i < list.getLength()) {
            if (this.isElement(list.item(i))) {
                els.add((Element)list.item(i));
            }
            ++i;
        }
        return els;
    }

    private List<Attr> attr(Element e) {
        NamedNodeMap list = e.getAttributes();
        ArrayList<Attr> attrs = new ArrayList<Attr>(list.getLength());
        int i = 0;
        while (i < list.getLength()) {
            attrs.add((Attr)list.item(i));
            ++i;
        }
        return attrs;
    }

    private List<Node> childs(short type) {
        NodeList childs = this.current.getChildNodes();
        ArrayList<Node> nodes = new ArrayList<Node>(childs.getLength());
        int i = 0;
        while (i < childs.getLength()) {
            if (childs.item(i).getNodeType() == type) {
                nodes.add(childs.item(i));
            }
            ++i;
        }
        return nodes;
    }

    @Override
    public XMLTag duplicate() {
        return XMLDoc.from(this, this.definition.isIgnoreNamespaces()).gotoRoot().gotoTag(this.getCurrentTagLocation(), new Object[0]);
    }

    @Override
    public XMLTag setText(String text) {
        for (Node node : this.childs((short)4)) {
            this.current.removeChild(node);
        }
        for (Node node : this.childs((short)3)) {
            this.current.removeChild(node);
        }
        return this.addText(text);
    }

    @Override
    public XMLTag setText(String text, String relativeXpath, Object ... arguments) throws XMLDocumentException {
        Element old = this.current;
        try {
            this.gotoTag(relativeXpath, arguments).setText(text);
        }
        finally {
            this.current = old;
        }
        return this;
    }

    @Override
    public XMLTag setTextIfExist(String text, String relativeXpath, Object ... arguments) throws XMLDocumentException {
        return this.hasTag(relativeXpath, arguments) ? this.setText(text, relativeXpath, arguments) : this;
    }

    @Override
    public XMLTag setCDATA(String data) {
        for (Node node : this.childs((short)4)) {
            this.current.removeChild(node);
        }
        for (Node node : this.childs((short)3)) {
            this.current.removeChild(node);
        }
        return this.addCDATA(data);
    }

    @Override
    public XMLTag setCDATA(String data, String relativeXpath, Object ... arguments) throws XMLDocumentException {
        Element old = this.current;
        try {
            this.gotoTag(relativeXpath, arguments).setCDATA(data);
        }
        finally {
            this.current = old;
        }
        return this;
    }

    @Override
    public XMLTag setCDATAIfExist(String data, String relativeXpath, Object ... arguments) throws XMLDocumentException {
        return this.hasTag(relativeXpath, arguments) ? this.setCDATA(data, relativeXpath, arguments) : this;
    }

    @Override
    public XMLTag setAttribute(String name, String value) throws XMLDocumentException {
        Utils.notNull("Attribute name", name);
        Utils.notNull("Attribute value", value);
        if (!this.hasAttribute(name)) {
            throw new XMLDocumentException("Element '%s' does not have attribute '%s'", this.getCurrentTagName(), name);
        }
        this.current.getAttributeNode(name).setValue(value);
        return this;
    }

    @Override
    public XMLTag setAttributeIfExist(String name, String value) {
        Utils.notNull("Attribute name", name);
        Utils.notNull("Attribute value", value);
        if (this.hasAttribute(name)) {
            this.current.getAttributeNode(name).setValue(value);
        }
        return this;
    }

    @Override
    public XMLTag setAttribute(String name, String value, String relativeXpath, Object ... arguments) throws XMLDocumentException {
        Element old = this.current;
        try {
            this.gotoTag(relativeXpath, arguments).setAttribute(name, value);
        }
        finally {
            this.current = old;
        }
        return this;
    }

    @Override
    public XMLTag setAttributeIfExist(String name, String value, String relativeXpath, Object ... arguments) throws XMLDocumentException {
        return this.hasAttribute(name, relativeXpath, arguments) ? this.setAttribute(name, value, relativeXpath, arguments) : this;
    }

    public static XMLDocBuilder newDocument(boolean ignoreNamespaces) {
        return XMLDocBuilder.newDocument(ignoreNamespaces);
    }

    public static XMLTag from(Node node, boolean ignoreNamespaces) {
        Utils.notNull("Node", node);
        return XMLDocBuilder.from(node, ignoreNamespaces);
    }

    public static XMLTag from(InputSource source, boolean ignoreNamespaces) {
        Utils.notNull("InputSource", source);
        return XMLDocBuilder.from(source, ignoreNamespaces);
    }

    public static XMLTag from(Reader reader, boolean ignoreNamespaces) {
        Utils.notNull("Reader", reader);
        return XMLDocBuilder.from(reader, ignoreNamespaces);
    }

    public static XMLTag from(InputStream is, boolean ignoreNamespaces) {
        Utils.notNull("InputStream", is);
        return XMLDocBuilder.from(is, ignoreNamespaces);
    }

    public static XMLTag from(File file, boolean ignoreNamespaces) {
        Utils.notNull("File", file);
        return XMLDocBuilder.from(file, ignoreNamespaces);
    }

    public static XMLTag from(URL xmlLocation, boolean ignoreNamespaces) {
        Utils.notNull("URL", xmlLocation);
        return XMLDocBuilder.from(xmlLocation, ignoreNamespaces);
    }

    public static XMLTag from(String xmlData, boolean ignoreNamespaces) {
        Utils.notEmpty("XML Data", xmlData);
        return XMLDocBuilder.from(xmlData, ignoreNamespaces);
    }

    public static XMLTag from(Source source, boolean ignoreNamespaces) {
        Utils.notNull("Source", source);
        return XMLDocBuilder.from(source, ignoreNamespaces);
    }

    public static XMLTag from(XMLTag tag, boolean ignoreNamespaces) {
        Utils.notNull("XML Tag", tag);
        return XMLDocBuilder.from(tag, ignoreNamespaces);
    }

    public static XMLDocBuilder newDocument() {
        return XMLDoc.newDocument(true);
    }

    public static XMLTag from(Node node) {
        return XMLDoc.from(node, true);
    }

    public static XMLTag from(InputSource source) {
        return XMLDoc.from(source, true);
    }

    public static XMLTag from(Reader reader) {
        return XMLDoc.from(reader, true);
    }

    public static XMLTag from(InputStream is) {
        return XMLDoc.from(is, true);
    }

    public static XMLTag from(File file) {
        return XMLDoc.from(file, true);
    }

    public static XMLTag from(URL xmlLocation) {
        return XMLDoc.from(xmlLocation, true);
    }

    public static XMLTag from(String xmlData) {
        return XMLDoc.from(xmlData, true);
    }

    public static XMLTag from(Source source) {
        return XMLDoc.from(source, true);
    }

    public static XMLTag from(XMLTag tag) {
        return XMLDoc.from(tag, true);
    }

    public static XMLTag fromCurrentTag(XMLTag tag, boolean ignoreNamespaces) {
        Utils.notNull("XML Tag", tag);
        return XMLDocBuilder.fromCurrentTag(tag, ignoreNamespaces);
    }
}

