/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLDocDefinition;
import com.mycila.xmltool.XMLDocumentBuilderFactory;
import com.mycila.xmltool.XMLDocumentException;
import com.mycila.xmltool.XMLTag;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class XMLDocBuilder {
    private final XMLDocDefinition definition;

    private XMLDocBuilder(XMLDocDefinition definition) {
        this.definition = definition;
    }

    public XMLDocBuilder addNamespace(String prefix, String namespaceURI) {
        this.definition.addNamespace(prefix, namespaceURI);
        return this;
    }

    public XMLDocBuilder addDefaultNamespace(String defaultNamespaceURI) {
        this.definition.addDefaultNamespace(defaultNamespaceURI);
        return this;
    }

    public XMLTag addRoot(String tagName) {
        return XMLDocBuilder.create(this.definition.createRoot(tagName));
    }

    private static XMLTag create(final XMLDocDefinition def) {
        def.normalize();
        final XMLDoc doc = new XMLDoc(def);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Object o = method.invoke((Object)doc, args);
                    if (XMLDocBuilder.needsNormalization(method.getName())) {
                        def.normalize();
                    }
                    return o;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        };
        return (XMLTag)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{XMLTag.class}, handler);
    }

    private static boolean needsNormalization(String name) {
        return name.startsWith("add") || name.startsWith("set") || name.startsWith("delete") || name.startsWith("rename");
    }

    static XMLDocBuilder newDocument(boolean ignoreNamespaces) {
        return new XMLDocBuilder(new XMLDocDefinition(XMLDocumentBuilderFactory.newDocumentBuilder(ignoreNamespaces).newDocument(), ignoreNamespaces));
    }

    static XMLTag from(File file, boolean ignoreNamespaces) {
        try {
            return XMLDocBuilder.from(new BufferedInputStream(new FileInputStream(file)), ignoreNamespaces);
        }
        catch (FileNotFoundException e) {
            throw new XMLDocumentException(e.getMessage(), e);
        }
    }

    static XMLTag from(URL xmlLocation, boolean ignoreNamespaces) {
        try {
            return XMLDocBuilder.from(new BufferedInputStream(xmlLocation.openStream()), ignoreNamespaces);
        }
        catch (IOException e) {
            throw new XMLDocumentException(e.getMessage(), e);
        }
    }

    static XMLTag from(String xmlData, boolean ignoreNamespaces) {
        return XMLDocBuilder.from(new StringReader(xmlData), ignoreNamespaces);
    }

    static XMLTag from(Reader reader, boolean ignoreNamespaces) {
        try {
            XMLTag xMLTag = XMLDocBuilder.from(new InputSource(reader), ignoreNamespaces);
            return xMLTag;
        }
        finally {
            XMLDocBuilder.close(reader);
        }
    }

    static XMLTag from(InputStream is, boolean ignoreNamespaces) {
        try {
            XMLTag xMLTag = XMLDocBuilder.from(new InputSource(is), ignoreNamespaces);
            return xMLTag;
        }
        finally {
            XMLDocBuilder.close(is);
        }
    }

    static XMLTag from(InputSource source, boolean ignoreNamespaces) {
        try {
            return XMLDocBuilder.from(XMLDocumentBuilderFactory.newDocumentBuilder(ignoreNamespaces).parse(source), ignoreNamespaces);
        }
        catch (Exception e) {
            throw new XMLDocumentException("Error creating XMLDoc. Please verify that the input source can be read and is well formed", e);
        }
    }

    static XMLTag from(Node node, boolean ignoreNamespaces) {
        return XMLDocBuilder.create(new XMLDocDefinition(node, ignoreNamespaces));
    }

    static XMLTag from(XMLTag tag, boolean ignoreNamespaces) {
        Document newDoc = XMLDocumentBuilderFactory.newDocumentBuilder(ignoreNamespaces).newDocument();
        newDoc.appendChild(newDoc.importNode(tag.toDocument().getDocumentElement(), true));
        return XMLDocBuilder.from(newDoc, ignoreNamespaces);
    }

    static XMLTag fromCurrentTag(XMLTag tag, boolean ignoreNamespaces) {
        Document newDoc = XMLDocumentBuilderFactory.newDocumentBuilder(ignoreNamespaces).newDocument();
        newDoc.appendChild(newDoc.importNode(tag.getCurrentTag(), true));
        return XMLDocBuilder.from(newDoc, ignoreNamespaces);
    }

    static XMLTag from(Source source, boolean ignoreNamespaces) {
        DOMResult result = new DOMResult();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new XMLDocumentException("Error creating XMLDoc. Please verify that the input source can be read and is well formed", e);
        }
        return XMLDocBuilder.from(result.getNode(), ignoreNamespaces);
    }

    private static void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {}
    }
}

