/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.commons.lang;

import com.mysema.commons.lang.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorWrapper<T>
implements CloseableIterator<T> {
    private Iterator<T> iter;

    public IteratorWrapper(Iterator<T> iter) {
        this.iter = iter;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public T next() {
        return this.iter.next();
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    @Override
    public void close() throws IOException {
        if (this.iter instanceof Closeable) {
            ((Closeable)((Object)this.iter)).close();
        }
    }

    public List<T> asList() {
        return IteratorWrapper.asList(this.iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> asList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        finally {
            if (iter instanceof Closeable) {
                try {
                    ((Closeable)((Object)iter)).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return list;
    }
}

