/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.loadbalance;

import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.VersionEntity;
import com.nepxion.discovery.common.entity.VersionFilterEntity;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.AbstractLoadBalanceListener;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class VersionFilterLoadBalanceListener
extends AbstractLoadBalanceListener {
    @Override
    public void onGetServers(String serviceId, List<? extends Server> servers) {
        String consumerServiceId = this.pluginAdapter.getServiceId();
        String consumerServiceVersion = this.pluginAdapter.getVersion();
        this.applyVersionFilter(consumerServiceId, consumerServiceVersion, serviceId, servers);
    }

    private void applyVersionFilter(String consumerServiceId, String consumerServiceVersion, String providerServiceId, List<? extends Server> servers) {
        if (StringUtils.isEmpty((CharSequence)consumerServiceVersion)) {
            return;
        }
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return;
        }
        VersionFilterEntity versionFilterEntity = discoveryEntity.getVersionFilterEntity();
        if (versionFilterEntity == null) {
            return;
        }
        Map versionEntityMap = versionFilterEntity.getVersionEntityMap();
        if (MapUtils.isEmpty((Map)versionEntityMap)) {
            return;
        }
        List versionEntityList = (List)versionEntityMap.get(consumerServiceId);
        if (CollectionUtils.isEmpty((Collection)versionEntityList)) {
            return;
        }
        ArrayList allNoFilterValueList = null;
        boolean providerConditionDefined = false;
        for (VersionEntity versionEntity : versionEntityList) {
            String providerServiceName = versionEntity.getProviderServiceName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)providerServiceName, (CharSequence)providerServiceId)) continue;
            providerConditionDefined = true;
            List consumerVersionValueList = versionEntity.getConsumerVersionValueList();
            List providerVersionValueList = versionEntity.getProviderVersionValueList();
            if (CollectionUtils.isNotEmpty((Collection)consumerVersionValueList)) {
                if (!consumerVersionValueList.contains(consumerServiceVersion)) continue;
                if (allNoFilterValueList == null) {
                    allNoFilterValueList = new ArrayList();
                }
                if (!CollectionUtils.isNotEmpty((Collection)providerVersionValueList)) continue;
                allNoFilterValueList.addAll(providerVersionValueList);
                continue;
            }
            if (allNoFilterValueList == null) {
                allNoFilterValueList = new ArrayList();
            }
            if (!CollectionUtils.isNotEmpty((Collection)providerVersionValueList)) continue;
            allNoFilterValueList.addAll(providerVersionValueList);
        }
        if (allNoFilterValueList != null) {
            if (allNoFilterValueList.isEmpty()) {
                return;
            }
            Iterator<? extends Server> iterator = servers.iterator();
            while (iterator.hasNext()) {
                Server server = iterator.next();
                String metadataVersion = this.pluginAdapter.getServerVersion(server);
                if (allNoFilterValueList.contains(metadataVersion)) continue;
                iterator.remove();
            }
        } else if (providerConditionDefined) {
            servers.clear();
        }
    }

    @Override
    public int getOrder() {
        return -2147483647;
    }
}

