/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.loadbalance;

import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.RegionWeightEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.WeightEntity;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class WeightRandomLoadBalance {
    private PluginAdapter pluginAdapter;

    public WeightFilterEntity getWeightFilterEntity() {
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return null;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return null;
        }
        WeightFilterEntity weightFilterEntity = discoveryEntity.getWeightFilterEntity();
        return weightFilterEntity;
    }

    public Server choose(List<Server> serverList, WeightFilterEntity weightFilterEntity) {
        if (CollectionUtils.isEmpty(serverList)) {
            return null;
        }
        int[] weights = new int[serverList.size()];
        for (int i = 0; i < serverList.size(); ++i) {
            Server server = serverList.get(i);
            int weight = this.getWeight(server, weightFilterEntity);
            if (weight <= 0) continue;
            weights[i] = weight;
        }
        int index = this.getIndex(weights);
        return serverList.get(index);
    }

    private int getIndex(int[] weights) {
        int[][] weightHolder = new int[weights.length][2];
        int totalWeight = 0;
        for (int i = 0; i < weights.length; ++i) {
            if (weights[i] <= 0) continue;
            weightHolder[i][0] = i;
            weightHolder[i][1] = totalWeight += weights[i];
        }
        int hitWeight = ThreadLocalRandom.current().nextInt(totalWeight) + 1;
        for (int i = 0; i < weightHolder.length; ++i) {
            if (hitWeight > weightHolder[i][1]) continue;
            return weightHolder[i][0];
        }
        return weightHolder[0][0];
    }

    private int getWeight(Server server, WeightFilterEntity weightFilterEntity) {
        Map weightEntityMap = weightFilterEntity.getWeightEntityMap();
        RegionWeightEntity regionWeightEntity = weightFilterEntity.getRegionWeightEntity();
        String providerServiceId = server.getMetaInfo().getAppName();
        String providerVersion = this.pluginAdapter.getServerVersion(server);
        String providerRegion = this.pluginAdapter.getServerRegion(server);
        String serviceId = this.pluginAdapter.getServiceId();
        int weight = this.getWeight(serviceId, providerServiceId, providerVersion, weightEntityMap);
        if (weight < 0) {
            weight = this.getWeight("", providerServiceId, providerVersion, weightEntityMap);
        }
        if (weight < 0) {
            weight = this.getWeight(providerRegion, regionWeightEntity);
        }
        if (weight < 0) {
            throw new DiscoveryException("Weight isn't configed for serviceId=" + providerServiceId);
        }
        return weight;
    }

    private int getWeight(String consumerServiceId, String providerServiceId, String providerVersion, Map<String, List<WeightEntity>> weightEntityMap) {
        if (MapUtils.isEmpty(weightEntityMap)) {
            return -1;
        }
        List<WeightEntity> weightEntityList = weightEntityMap.get(consumerServiceId);
        if (CollectionUtils.isEmpty(weightEntityList)) {
            return -1;
        }
        for (WeightEntity weightEntity : weightEntityList) {
            String providerServiceName = weightEntity.getProviderServiceName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)providerServiceName, (CharSequence)providerServiceId)) continue;
            Map weightMap = weightEntity.getWeightMap();
            if (MapUtils.isEmpty((Map)weightMap)) {
                return -1;
            }
            Integer weight = (Integer)weightMap.get(providerVersion);
            if (weight != null) {
                return weight;
            }
            return -1;
        }
        return -1;
    }

    private int getWeight(String providerRegion, RegionWeightEntity regionWeightEntity) {
        if (regionWeightEntity == null) {
            return -1;
        }
        Map weightMap = regionWeightEntity.getWeightMap();
        if (MapUtils.isEmpty((Map)weightMap)) {
            return -1;
        }
        Integer weight = (Integer)weightMap.get(providerRegion);
        if (weight != null) {
            return weight;
        }
        return -1;
    }

    public void setPluginAdapter(PluginAdapter pluginAdapter) {
        this.pluginAdapter = pluginAdapter;
    }
}

