/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.Property;
import com.netflix.config.validation.PropertyChangeValidator;
import com.netflix.config.validation.ValidationException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertyWrapper<V>
implements Property<V> {
    protected final DynamicProperty prop;
    protected final V defaultValue;
    private static final IdentityHashMap<Class<? extends PropertyWrapper>, Object> SUBCLASSES_WITH_NO_CALLBACK = new IdentityHashMap();
    private static final Logger logger = LoggerFactory.getLogger(PropertyWrapper.class);
    private final Set<Runnable> callbacks = new CopyOnWriteArraySet<Runnable>();
    private static final Object DUMMY_VALUE;

    public static final void registerSubClassWithNoCallback(Class<? extends PropertyWrapper> c) {
        SUBCLASSES_WITH_NO_CALLBACK.put(c, DUMMY_VALUE);
    }

    protected PropertyWrapper(String propName, V defaultValue) {
        this.prop = DynamicProperty.getInstance(propName);
        this.defaultValue = defaultValue;
        Class<?> c = this.getClass();
        if (!SUBCLASSES_WITH_NO_CALLBACK.containsKey(c)) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    PropertyWrapper.this.propertyChanged();
                }
            };
            this.prop.addCallback(callback);
            this.callbacks.add(callback);
            this.prop.addValidator(new PropertyChangeValidator(){

                @Override
                public void validate(String newValue) {
                    PropertyWrapper.this.validate(newValue);
                }
            });
            try {
                if (this.prop.getString() != null) {
                    this.validate(this.prop.getString());
                }
            }
            catch (ValidationException e) {
                logger.warn("Error validating property at initialization. Will fallback to default value.", (Throwable)e);
                this.prop.updateValue(defaultValue);
            }
        }
    }

    @Override
    public String getName() {
        return this.prop.getName();
    }

    public void addValidator(PropertyChangeValidator v) {
        if (v != null) {
            this.prop.addValidator(v);
        }
    }

    protected void propertyChanged() {
        this.propertyChanged(this.getValue());
    }

    protected void propertyChanged(V newValue) {
    }

    protected void validate(String newValue) {
    }

    @Override
    public long getChangedTimestamp() {
        return this.prop.getChangedTimestamp();
    }

    @Override
    public void addCallback(Runnable callback) {
        if (callback != null) {
            this.prop.addCallback(callback);
            this.callbacks.add(callback);
        }
    }

    @Override
    public void removeAllCallbacks() {
        HashSet<Runnable> callbacksToRemove = new HashSet<Runnable>(this.callbacks);
        for (Runnable callback : callbacksToRemove) {
            this.prop.removeCallback(callback);
        }
        this.callbacks.removeAll(callbacksToRemove);
    }

    @Override
    public abstract V getValue();

    @Override
    public V getDefaultValue() {
        return this.defaultValue;
    }

    public DynamicProperty getDynamicProperty() {
        return this.prop;
    }

    public String toString() {
        return "DynamicProperty: {name=" + this.prop.getName() + ", current value=" + this.prop.getString(String.valueOf(this.defaultValue)) + "}";
    }

    static {
        PropertyWrapper.registerSubClassWithNoCallback(DynamicIntProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicStringProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicBooleanProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicFloatProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicLongProperty.class);
        PropertyWrapper.registerSubClassWithNoCallback(DynamicDoubleProperty.class);
        DUMMY_VALUE = new Object();
    }
}

