/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.discovery.util.SpectatorUtil;
import java.util.concurrent.atomic.AtomicLong;

public class ThresholdLevelsMetric {
    public static final ThresholdLevelsMetric NO_OP_METRIC = new ThresholdLevelsMetric(){

        @Override
        public void update(long delayMs) {
        }
    };
    private final long[] levels;
    private final AtomicLong[] gauges;

    public ThresholdLevelsMetric() {
        this.levels = null;
        this.gauges = null;
    }

    public ThresholdLevelsMetric(Object owner, String prefix, long[] levels) {
        this.levels = levels;
        this.gauges = new AtomicLong[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            String name = prefix + String.format("%05d", levels[i]);
            this.gauges[i] = SpectatorUtil.monitoredLong(name, owner.getClass());
        }
    }

    public void update(long delayMs) {
        int i;
        long matchedIdx;
        long delaySec = delayMs / 1000L;
        if (this.levels[0] > delaySec) {
            matchedIdx = -1L;
        } else {
            matchedIdx = this.levels.length - 1;
            for (i = 0; i < this.levels.length - 1; ++i) {
                if (this.levels[i] > delaySec || delaySec >= this.levels[i + 1]) continue;
                matchedIdx = i;
                break;
            }
        }
        for (i = 0; i < this.levels.length; ++i) {
            if ((long)i == matchedIdx) {
                this.gauges[i].set(1L);
                continue;
            }
            this.gauges[i].set(0L);
        }
    }
}

