/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.CloudInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.blitz4j.LoggingConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.JsonXStream;
import com.netflix.discovery.converters.XmlXStream;
import com.netflix.eureka.DefaultEurekaServerConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.V1AwareInstanceInfoConverter;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.util.EIPManager;
import com.netflix.eureka.util.EurekaMonitors;
import com.thoughtworks.xstream.converters.Converter;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaBootStrap
implements ServletContextListener {
    private static final String TEST = "test";
    private static final String ARCHAIUS_DEPLOYMENT_ENVIRONMENT = "archaius.deployment.environment";
    private static final String EUREKA_ENVIRONMENT = "eureka.environment";
    private static final String CLOUD = "cloud";
    private static final String DEFAULT = "default";
    private static final String ARCHAIUS_DEPLOYMENT_DATACENTER = "archaius.deployment.datacenter";
    private static final String EUREKA_DATACENTER = "eureka.datacenter";
    private static final Logger logger = LoggerFactory.getLogger(EurekaBootStrap.class);
    private static final int EIP_BIND_SLEEP_TIME_MS = 1000;
    private static final Timer timer = new Timer("Eureka-EIPBinder", true);

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.initEurekaEnvironment();
            JsonXStream.getInstance().registerConverter((Converter)new V1AwareInstanceInfoConverter(), 10000);
            XmlXStream.getInstance().registerConverter((Converter)new V1AwareInstanceInfoConverter(), 10000);
            InstanceInfo info = ApplicationInfoManager.getInstance().getInfo();
            PeerAwareInstanceRegistry registry = PeerAwareInstanceRegistry.getInstance();
            int registryCount = registry.syncUp();
            registry.openForTraffic(registryCount);
            if (DataCenterInfo.Name.Amazon.equals((Object)info.getDataCenterInfo().getName())) {
                this.handleEIPbinding();
            }
            PeerAwareInstanceRegistry.getInstance().initRemoteRegionRegistry();
            EurekaMonitors.registerAllStats();
            for (PeerEurekaNode node : registry.getReplicaNodes()) {
                logger.info("Replica node URL:  " + node.getServiceUrl());
            }
        }
        catch (Throwable e) {
            logger.error("Cannot bootstrap eureka server :", e);
            throw new RuntimeException("Cannot bootstrap eureka server :", e);
        }
    }

    protected void initEurekaEnvironment() {
        logger.info("Setting the eureka configuration..");
        LoggingConfiguration.getInstance().configure();
        DefaultEurekaServerConfig eurekaServerConfig = new DefaultEurekaServerConfig();
        EurekaServerConfigurationManager.getInstance().setConfiguration(eurekaServerConfig);
        String dataCenter = ConfigurationManager.getConfigInstance().getString(EUREKA_DATACENTER);
        if (dataCenter == null) {
            logger.info("Eureka data center value eureka.datacenter is not set, defaulting to default");
            ConfigurationManager.getConfigInstance().setProperty(ARCHAIUS_DEPLOYMENT_DATACENTER, (Object)DEFAULT);
        } else {
            ConfigurationManager.getConfigInstance().setProperty(ARCHAIUS_DEPLOYMENT_DATACENTER, (Object)dataCenter);
        }
        String environment = ConfigurationManager.getConfigInstance().getString(EUREKA_ENVIRONMENT);
        if (environment == null) {
            ConfigurationManager.getConfigInstance().setProperty(ARCHAIUS_DEPLOYMENT_ENVIRONMENT, (Object)TEST);
            logger.info("Eureka environment value eureka.environment is not set, defaulting to test");
        }
        Object config = CLOUD.equals(ConfigurationManager.getDeploymentContext().getDeploymentDatacenter()) ? new CloudInstanceConfig() : new MyDataCenterInstanceConfig();
        logger.info("Initializing the eureka client...");
        DiscoveryManager.getInstance().initComponent((EurekaInstanceConfig)config, (EurekaClientConfig)new DefaultEurekaClientConfig());
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            logger.info(new Date().toString() + " Shutting down Eureka Server..");
            InstanceInfo info = ApplicationInfoManager.getInstance().getInfo();
            EurekaMonitors.shutdown();
            for (int i = 0; i < EurekaServerConfigurationManager.getInstance().getConfiguration().getEIPBindRebindRetries(); ++i) {
                try {
                    if (!DataCenterInfo.Name.Amazon.equals((Object)info.getDataCenterInfo().getName())) break;
                    EIPManager.getInstance().unbindEIP();
                    break;
                }
                catch (Throwable e) {
                    logger.warn("Cannot unbind the EIP from the instance");
                    Thread.sleep(1000L);
                    continue;
                }
            }
            PeerAwareInstanceRegistry.getInstance().shutdown();
            this.destroyEurekaEnvironment();
        }
        catch (Throwable e) {
            logger.error("Error shutting down eureka", e);
        }
        logger.info(new Date().toString() + " Eureka Service is now shutdown...");
    }

    protected void destroyEurekaEnvironment() {
    }

    private void handleEIPbinding() throws InterruptedException {
        EurekaServerConfig eurekaServerConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
        int retries = eurekaServerConfig.getEIPBindRebindRetries();
        for (int i = 0; i < retries && !this.bindEIP(); ++i) {
        }
        this.scheduleEIPBindTask(eurekaServerConfig);
    }

    private void scheduleEIPBindTask(EurekaServerConfig eurekaServerConfig) {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    EurekaBootStrap.this.bindEIP();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, eurekaServerConfig.getEIPBindingRetryIntervalMs(), (long)eurekaServerConfig.getEIPBindingRetryIntervalMs());
    }

    private boolean bindEIP() throws InterruptedException {
        try {
            EIPManager.getInstance().bindToEIP();
            return true;
        }
        catch (Throwable e) {
            logger.error("Cannot bind to EIP", e);
            Thread.sleep(1000L);
            return false;
        }
    }
}

