/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.lease;

public class Lease<T> {
    public static final int DEFAULT_DURATION_IN_SECS = 90;
    private T holder;
    private long evictionTimestamp;
    private long registrationTimestamp;
    private long serviceUpTimestamp;
    private volatile long lastUpdateTimestamp;
    private long duration;

    public Lease(T r, int durationInSecs) {
        this.holder = r;
        this.lastUpdateTimestamp = this.registrationTimestamp = System.currentTimeMillis();
        this.duration = durationInSecs * 1000;
    }

    public void renew() {
        this.lastUpdateTimestamp = System.currentTimeMillis() + this.duration;
    }

    public void cancel() {
        if (this.evictionTimestamp <= 0L) {
            this.evictionTimestamp = System.currentTimeMillis();
        }
    }

    public void serviceUp() {
        if (this.serviceUpTimestamp == 0L) {
            this.serviceUpTimestamp = System.currentTimeMillis();
        }
    }

    public boolean isExpired() {
        return this.evictionTimestamp > 0L || System.currentTimeMillis() > this.lastUpdateTimestamp + this.duration;
    }

    public long getRegistrationTimestamp() {
        return this.registrationTimestamp;
    }

    public long getLastRenewalTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public long getEvictionTimestamp() {
        return this.evictionTimestamp;
    }

    public long getServiceUpTimestamp() {
        return this.serviceUpTimestamp;
    }

    public T getHolder() {
        return this.holder;
    }

    static enum Action {
        Register,
        Cancel,
        Renew;

    }
}

