/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.provider.Serializer;
import com.netflix.discovery.shared.EurekaJerseyClient;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.Version;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.logging.messaging.BatcherFactory;
import com.netflix.logging.messaging.MessageBatcher;
import com.netflix.logging.messaging.MessageProcessor;
import com.netflix.servo.monitor.DynamicCounter;
import com.netflix.servo.monitor.Monitors;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerEurekaNode {
    private static final Logger logger = LoggerFactory.getLogger(PeerEurekaNode.class);
    private static final int RETRY_SLEEP_TIME_MS = 100;
    public static final String HEADER_REPLICATION = "x-netflix-discovery-replication";
    private static final EurekaServerConfig config = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private final String serviceUrl;
    private final String name;
    private volatile EurekaJerseyClient.JerseyClient jerseyClient;
    private volatile ApacheHttpClient4 jerseyApacheClient;
    private MessageBatcher<ReplicationTask> heartBeatBatcher;
    private MessageBatcher<ReplicationTask> statusBatcher;
    private MessageBatcher<ReplicationTask> registerBatcher;
    private MessageBatcher<ReplicationTask> cancelBatcher;
    private MessageBatcher<ReplicationTask> asgStatusBatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerEurekaNode(String serviceUrl) {
        this.serviceUrl = serviceUrl.intern();
        this.name = this.getClass().getSimpleName() + ": " + serviceUrl + "apps/: ";
        this.heartBeatBatcher = this.getBatcher(serviceUrl, PeerAwareInstanceRegistry.Action.Heartbeat.name());
        this.statusBatcher = this.getBatcher(serviceUrl, PeerAwareInstanceRegistry.Action.StatusUpdate.name());
        this.asgStatusBatcher = this.getBatcher(serviceUrl, "ASG_" + PeerAwareInstanceRegistry.Action.StatusUpdate.name());
        this.registerBatcher = this.getBatcher(serviceUrl, PeerAwareInstanceRegistry.Action.Register.name());
        this.cancelBatcher = this.getBatcher(serviceUrl, PeerAwareInstanceRegistry.Action.Cancel.name());
        String string = this.serviceUrl;
        synchronized (string) {
            if (this.jerseyApacheClient == null) {
                try {
                    String hostname;
                    try {
                        hostname = new URL(serviceUrl).getHost();
                    }
                    catch (MalformedURLException e) {
                        hostname = serviceUrl;
                    }
                    String jerseyClientName = "Discovery-PeerNodeClient-" + hostname;
                    this.jerseyClient = EurekaJerseyClient.createJerseyClient((String)jerseyClientName, (int)config.getPeerNodeConnectTimeoutMs(), (int)config.getPeerNodeReadTimeoutMs(), (int)config.getPeerNodeTotalConnections(), (int)config.getPeerNodeTotalConnectionsPerHost(), (int)config.getPeerNodeConnectionIdleTimeoutSeconds());
                    this.jerseyApacheClient = this.jerseyClient.getClient();
                }
                catch (Throwable e) {
                    throw new RuntimeException("Cannot Create new Replica Node :" + this.name);
                }
            }
        }
        try {
            String serviceUrlHost = new URL(serviceUrl).getHost();
            Monitors.registerObject((String)serviceUrlHost, (Object)this);
        }
        catch (Throwable e) {
            logger.error("Cannot register monitors for Peer eureka node :" + serviceUrl, e);
        }
    }

    public void register(final InstanceInfo info) throws Exception {
        ReplicationTask replicationTask = new ReplicationTask(info.getAppName(), info.getId(), PeerAwareInstanceRegistry.Action.Register){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int execute() {
                CurrentRequestVersion.set(Version.V2);
                String urlPath = "apps/" + info.getAppName();
                ClientResponse response = null;
                try {
                    response = (ClientResponse)((WebResource.Builder)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)info);
                    int n = response.getStatus();
                    return n;
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }

            @Override
            public boolean shouldReplicateInstanceInfo() {
                return true;
            }
        };
        replicationTask.setInstanceInfo(info);
        boolean success = this.registerBatcher.process((Object)replicationTask);
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public void cancel(final String appName, final String id) throws Exception {
        boolean success = this.cancelBatcher.process((Object)new ReplicationTask(appName, id, PeerAwareInstanceRegistry.Action.Cancel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int execute() {
                ClientResponse response = null;
                try {
                    String urlPath = "apps/" + appName + "/" + id;
                    response = (ClientResponse)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").delete(ClientResponse.class);
                    int n = response.getStatus();
                    return n;
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }

            @Override
            public void handleFailure(int statusCode) throws Throwable {
                super.handleFailure(statusCode);
                if (statusCode == 404) {
                    logger.warn(PeerEurekaNode.this.name + appName + "/" + id + " : delete: missing entry.");
                }
            }
        });
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public void heartbeat(final String appName, final String id, final InstanceInfo info, final InstanceInfo.InstanceStatus overriddenStatus, boolean primeConnection) throws Throwable {
        if (primeConnection) {
            this.sendHeartBeat(appName, id, info, overriddenStatus, null);
            return;
        }
        ReplicationTask replicationTask = new ReplicationTask(appName, id, PeerAwareInstanceRegistry.Action.Heartbeat){

            @Override
            public int execute() throws Throwable {
                return PeerEurekaNode.this.sendHeartBeat(appName, id, info, overriddenStatus, this);
            }

            @Override
            public void handleFailure(int statusCode) throws Throwable {
                super.handleFailure(statusCode);
                if (statusCode == 404) {
                    logger.warn(PeerEurekaNode.this.name + appName + "/" + id + " : heartbeat: missing entry.");
                    if (info != null) {
                        logger.warn("Cannot find instance id {} and hence replicating the instance with status {}", (Object)info.getId(), (Object)info.getStatus().toString());
                        PeerEurekaNode.this.register(info);
                    }
                } else if (config.shouldSyncWhenTimestampDiffers() && this.getPeerInstanceInfo() != null) {
                    PeerEurekaNode.this.syncInstancesIfTimestampDiffers(id, info, this.getPeerInstanceInfo());
                }
            }
        };
        replicationTask.setInstanceInfo(info);
        replicationTask.setOverriddenStatus(overriddenStatus);
        boolean success = this.heartBeatBatcher.process((Object)replicationTask);
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public void statusUpdate(final String asgName, final ASGResource.ASGStatus newStatus) {
        boolean success = this.asgStatusBatcher.process((Object)new ReplicationTask(asgName, asgName, PeerAwareInstanceRegistry.Action.StatusUpdate){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int execute() {
                ClientResponse response = null;
                try {
                    String urlPath = "asg/" + asgName + "/status";
                    response = (ClientResponse)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").put(ClientResponse.class);
                    int n = response.getStatus();
                    return n;
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }

            @Override
            public boolean isBatchingSupported() {
                return false;
            }
        });
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public void statusUpdate(final String appName, final String id, final InstanceInfo.InstanceStatus newStatus, final InstanceInfo info) {
        boolean success = this.statusBatcher.process((Object)new ReplicationTask(appName, id, PeerAwareInstanceRegistry.Action.StatusUpdate){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int execute() {
                CurrentRequestVersion.set(Version.V2);
                ClientResponse response = null;
                try {
                    String urlPath = "apps/" + appName + "/" + id + "/status";
                    response = (ClientResponse)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString()).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").put(ClientResponse.class);
                    int n = response.getStatus();
                    return n;
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
        });
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerEurekaNode other = (PeerEurekaNode)obj;
        return !(this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl));
    }

    public void destroyResources() {
        if (this.jerseyClient != null) {
            try {
                this.jerseyClient.destroyResources();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void shutDown() {
        if (this.heartBeatBatcher != null) {
            this.heartBeatBatcher.stop();
        }
        if (this.registerBatcher != null) {
            this.registerBatcher.stop();
        }
        if (this.cancelBatcher != null) {
            this.cancelBatcher.stop();
        }
        if (this.statusBatcher != null) {
            this.statusBatcher.stop();
        }
        if (this.asgStatusBatcher != null) {
            this.asgStatusBatcher.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus, ReplicationTask task) throws Throwable {
        ClientResponse response = null;
        try {
            String urlPath = "apps/" + appName + "/" + id;
            WebResource r = this.jerseyApacheClient.resource(this.serviceUrl).path(urlPath).queryParam("status", info.getStatus().toString()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString());
            if (overriddenStatus != null) {
                r = r.queryParam("overriddenstatus", overriddenStatus.name());
            }
            response = (ClientResponse)((WebResource.Builder)r.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(HEADER_REPLICATION, (Object)"true")).put(ClientResponse.class);
            InstanceInfo infoFromPeer = null;
            if (response.getStatus() == Response.Status.OK.getStatusCode() && response.hasEntity()) {
                infoFromPeer = (InstanceInfo)response.getEntity(InstanceInfo.class);
            }
            if (task != null && infoFromPeer != null) {
                task.setPeerInstanceInfo(infoFromPeer);
            }
            int n = response.getStatus();
            return n;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private boolean isNetworkConnectException(Throwable e) {
        while (e.getCause() != null) {
            if (IOException.class.isInstance(e.getCause())) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private void syncInstancesIfTimestampDiffers(String id, InstanceInfo info, InstanceInfo infoFromPeer) {
        try {
            if (infoFromPeer != null) {
                Object[] args = new Object[]{id, info.getLastDirtyTimestamp(), infoFromPeer.getLastDirtyTimestamp()};
                logger.warn("Peer wants us to take the instance information from it, since the timestamp differs,Id : {} My Timestamp : {}, Peer's timestamp: {}", args);
                if (infoFromPeer.getOverriddenStatus() != null && !InstanceInfo.InstanceStatus.UNKNOWN.equals((Object)infoFromPeer.getOverriddenStatus())) {
                    Object[] args1 = new Object[]{id, info.getOverriddenStatus(), infoFromPeer.getOverriddenStatus()};
                    logger.warn("Overridden Status info -id {}, mine {}, peer's {}", args1);
                    PeerAwareInstanceRegistry.getInstance().storeOverriddenStatusIfRequired(id, infoFromPeer.getOverriddenStatus());
                }
                PeerAwareInstanceRegistry.getInstance().register(infoFromPeer, true);
            }
        }
        catch (Throwable e) {
            logger.warn("Exception when trying to get information from peer :", e);
        }
    }

    private MessageBatcher getBatcher(final String serviceUrl, String pBatcherName) {
        String batcherName = null;
        try {
            batcherName = new URL(serviceUrl).getHost();
        }
        catch (MalformedURLException e1) {
            batcherName = serviceUrl;
        }
        String absoluteBatcherName = batcherName + "-" + pBatcherName;
        ConfigurationManager.getConfigInstance().setProperty("batcher." + absoluteBatcherName + ".queue.maxMessages", (Object)config.getMaxElementsInPeerReplicationPool());
        ConfigurationManager.getConfigInstance().setProperty("batcher." + absoluteBatcherName + ".batch.maxMessages", (Object)250);
        ConfigurationManager.getConfigInstance().setProperty("batcher." + absoluteBatcherName + ".keepAliveTime", (Object)(config.getMaxIdleThreadAgeInMinutesForPeerReplication() * 60L));
        ConfigurationManager.getConfigInstance().setProperty("batcher." + absoluteBatcherName + ".maxThreads", (Object)config.getMaxThreadsForPeerReplication());
        return BatcherFactory.createBatcher((String)absoluteBatcherName, (MessageProcessor)new MessageProcessor<ReplicationTask>(){
            private String BATCH_URL_PATH = "peerreplication/batch/";

            public void process(List<ReplicationTask> tasks) {
                if (!tasks.get(0).isBatchingSupported()) {
                    this.executeSingle(tasks);
                } else if (!this.executeBatch(tasks)) {
                    this.executeSingle(tasks);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean executeBatch(List<ReplicationTask> tasks) {
                boolean success = true;
                boolean done = true;
                ReplicationList list = new ReplicationList();
                for (ReplicationTask task : tasks) {
                    if (System.currentTimeMillis() - (long)config.getMaxTimeForReplication() > task.getSubmitTime()) {
                        Object[] args = new Object[]{task.getAppName(), task.getId(), task.getAction(), new Date(System.currentTimeMillis()), new Date(task.getSubmitTime())};
                        logger.warn("Replication events older than the threshold. AppName : {}, Id: {}, Action : {}, Current Time : {}, Submit Time :{}", args);
                        continue;
                    }
                    ReplicationInstance instance = new ReplicationInstance();
                    instance.setAppName(task.getAppName());
                    instance.setId(task.getId());
                    InstanceInfo instanceInfo = task.getInstanceInfo();
                    if (instanceInfo != null) {
                        String overriddenStatus = task.getOverriddenStatus() == null ? null : task.getOverriddenStatus().name();
                        instance.setOverriddenStatus(overriddenStatus);
                        instance.setLastDirtyTimestamp(instanceInfo.getLastDirtyTimestamp());
                        if (task.shouldReplicateInstanceInfo()) {
                            instance.setInstanceInfo(instanceInfo);
                        }
                        String instanceStatus = instanceInfo.getStatus() == null ? null : instanceInfo.getStatus().name();
                        instance.setStatus(instanceStatus);
                    }
                    instance.setAction(task.getAction());
                    list.addReplicationInstance(instance);
                }
                if (list.getList().size() == 0) {
                    return true;
                }
                PeerAwareInstanceRegistry.Action action = list.getList().get(0).action;
                DynamicCounter.increment((String)("Batch_" + (Object)((Object)action) + "_tries"), (String[])new String[0]);
                do {
                    done = true;
                    ClientResponse response = null;
                    try {
                        response = (ClientResponse)((WebResource.Builder)PeerEurekaNode.this.jerseyApacheClient.resource(serviceUrl).path(this.BATCH_URL_PATH).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)list);
                        if (!PeerEurekaNode.this.isSuccess(response.getStatus())) {
                            boolean instance = false;
                            return instance;
                        }
                        DynamicCounter.increment((String)("Batch_" + (Object)((Object)action) + "_success"), (String[])new String[0]);
                        ReplicationListResponse batchResponse = (ReplicationListResponse)response.getEntity(ReplicationListResponse.class);
                        int ctr = 0;
                        for (ReplicationInstanceResponse singleResponse : batchResponse.getResponseList()) {
                            int statusCode = singleResponse.getStatusCode();
                            if (!PeerEurekaNode.this.isSuccess(statusCode) || singleResponse.getResponseEntity() != null) {
                                if (singleResponse.getResponseEntity() != null) {
                                    tasks.get(ctr).setPeerInstanceInfo(singleResponse.getResponseEntity());
                                }
                                tasks.get(ctr).handleFailure(statusCode);
                            }
                            ++ctr;
                        }
                        done = true;
                    }
                    catch (Throwable e) {
                        if (PeerEurekaNode.this.isNetworkConnectException(e)) {
                            DynamicCounter.increment((String)("Batch_" + (Object)((Object)action) + "_retries"), (String[])new String[0]);
                            done = false;
                            continue;
                        }
                        success = false;
                        logger.info("Not re-trying this exception because it does not seem to be a network exception", e);
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                } while (!done);
                return success;
            }

            private void executeSingle(List<ReplicationTask> tasks) {
                for (ReplicationTask task : tasks) {
                    boolean done = true;
                    do {
                        done = true;
                        try {
                            if (System.currentTimeMillis() - (long)config.getMaxTimeForReplication() > task.getSubmitTime()) {
                                Object[] args = new Object[]{task.getAppName(), task.getId(), task.getAction(), new Date(System.currentTimeMillis()), new Date(task.getSubmitTime())};
                                logger.warn("Replication events older than the threshold. AppName : {}, Id: {}, Action : {}, Current Time : {}, Submit Time :{}", args);
                                continue;
                            }
                            DynamicCounter.increment((String)("Single_" + task.getAction().name() + "_tries"), (String[])new String[0]);
                            int statusCode = task.execute();
                            if (!PeerEurekaNode.this.isSuccess(statusCode)) {
                                task.handleFailure(statusCode);
                            }
                            DynamicCounter.increment((String)("Single_" + task.getAction().name() + "_success"), (String[])new String[0]);
                        }
                        catch (Throwable e) {
                            logger.error(PeerEurekaNode.this.name + task.getAppName() + "/" + task.getId() + ":" + (Object)((Object)task.getAction()), e);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e1) {
                                // empty catch block
                            }
                            if (PeerEurekaNode.this.isNetworkConnectException(e)) {
                                DynamicCounter.increment((String)(task.getAction().name() + "_retries"), (String[])new String[0]);
                                done = false;
                                continue;
                            }
                            logger.info("Not re-trying this exception because it does not seem to be a network exception", e);
                        }
                    } while (!done);
                }
            }
        });
    }

    private boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    @Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
    @XStreamAlias(value="replinstance")
    public static class ReplicationInstance {
        private String appName;
        private String id;
        private Long lastDirtyTimestamp;
        private String overriddenStatus;
        private String status;
        private InstanceInfo instanceInfo;
        private PeerAwareInstanceRegistry.Action action;

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Long getLastDirtyTimestamp() {
            return this.lastDirtyTimestamp;
        }

        public void setLastDirtyTimestamp(long lastDirtyTimestamp) {
            this.lastDirtyTimestamp = lastDirtyTimestamp;
        }

        public String getOverriddenStatus() {
            return this.overriddenStatus;
        }

        public void setOverriddenStatus(String overriddenStatus) {
            this.overriddenStatus = overriddenStatus;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public InstanceInfo getInstanceInfo() {
            return this.instanceInfo;
        }

        public void setInstanceInfo(InstanceInfo instanceInfo) {
            this.instanceInfo = instanceInfo;
        }

        public PeerAwareInstanceRegistry.Action getAction() {
            return this.action;
        }

        public void setAction(PeerAwareInstanceRegistry.Action action) {
            this.action = action;
        }
    }

    @Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
    @XStreamAlias(value="instanceresponse")
    public static class ReplicationInstanceResponse {
        private int statusCode;
        private InstanceInfo responseEntity;

        public int getStatusCode() {
            return this.statusCode;
        }

        public InstanceInfo getResponseEntity() {
            return this.responseEntity;
        }

        public static final class Builder {
            private ReplicationInstanceResponse response = new ReplicationInstanceResponse();

            public Builder setStatusCode(int statusCode) {
                this.response.statusCode = statusCode;
                return this;
            }

            public Builder setResponseEntity(InstanceInfo entity) {
                this.response.responseEntity = entity;
                return this;
            }

            public ReplicationInstanceResponse build() {
                return this.response;
            }
        }
    }

    @Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
    @XStreamAlias(value="batchresponse")
    public static class ReplicationListResponse {
        private List<ReplicationInstanceResponse> responseList = new ArrayList<ReplicationInstanceResponse>();

        public List<ReplicationInstanceResponse> getResponseList() {
            return this.responseList;
        }

        public void addResponse(ReplicationInstanceResponse singleResponse) {
            this.responseList.add(singleResponse);
        }
    }

    @Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
    @XStreamAlias(value="repllist")
    public static class ReplicationList {
        private List<ReplicationInstance> replicationList = new ArrayList<ReplicationInstance>();

        public void addReplicationInstance(ReplicationInstance instance) {
            this.replicationList.add(instance);
        }

        public List<ReplicationInstance> getList() {
            return this.replicationList;
        }
    }

    private abstract class ReplicationTask {
        private long submitTime = System.currentTimeMillis();
        private String appName;
        private String id;
        private PeerAwareInstanceRegistry.Action action;
        private InstanceInfo instanceInfo;
        private InstanceInfo peerInstanceInfo;
        private InstanceInfo.InstanceStatus overriddenStatus;

        public String getAppName() {
            return this.appName;
        }

        public String getId() {
            return this.id;
        }

        public PeerAwareInstanceRegistry.Action getAction() {
            return this.action;
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public InstanceInfo getInstanceInfo() {
            return this.instanceInfo;
        }

        public void setInstanceInfo(InstanceInfo instanceInfo) {
            this.instanceInfo = instanceInfo;
        }

        public InstanceInfo.InstanceStatus getOverriddenStatus() {
            return this.overriddenStatus;
        }

        public void setOverriddenStatus(InstanceInfo.InstanceStatus overriddenStatus) {
            this.overriddenStatus = overriddenStatus;
        }

        public InstanceInfo getPeerInstanceInfo() {
            return this.peerInstanceInfo;
        }

        public void setPeerInstanceInfo(InstanceInfo peerInstanceInfo) {
            this.peerInstanceInfo = peerInstanceInfo;
        }

        public ReplicationTask(String appName, String id, PeerAwareInstanceRegistry.Action action) {
            this.appName = appName;
            this.id = id;
            this.action = action;
        }

        public abstract int execute() throws Throwable;

        public void handleFailure(int statusCode) throws Throwable {
            Object[] args = new Object[]{this.appName, this.id, this.action.name(), statusCode};
            logger.warn("The replication of {}/{}/{} failed with response code {}", args);
        }

        public boolean shouldReplicateInstanceInfo() {
            return false;
        }

        public boolean isBatchingSupported() {
            return config.shouldBatchReplication();
        }
    }
}

