/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DisassociateAddressRequest;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.servo.monitor.Monitors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EIPManager {
    private static final String US_EAST_1 = "us-east-1";
    private static final Logger logger = LoggerFactory.getLogger(EIPManager.class);
    private EurekaServerConfig eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private static final EIPManager s_instance = new EIPManager();

    public static EIPManager getInstance() {
        return s_instance;
    }

    private EIPManager() {
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
    }

    public boolean isEIPBound() {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        String myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone);
        String myPublicIP = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicIpv4);
        Collection<String> candidateEIPs = this.getCandidateEIPs(myInstanceId, myZone);
        for (String eipEntry : candidateEIPs) {
            if (!eipEntry.equals(myPublicIP)) continue;
            logger.info("My instance {} seems to be already associated with the public ip {}", (Object)myInstanceId, (Object)myPublicIP);
            return true;
        }
        return false;
    }

    public void bindEIP() {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        String myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone);
        Collection<String> candidateEIPs = this.getCandidateEIPs(myInstanceId, myZone);
        AmazonEC2 ec2Service = this.getEC2Service();
        boolean isMyinstanceAssociatedWithEIP = false;
        Address selectedEIP = null;
        for (String eipEntry : candidateEIPs) {
            try {
                String associatedInstanceId = null;
                DescribeAddressesRequest describeAddressRequest = new DescribeAddressesRequest().withPublicIps(new String[]{eipEntry});
                DescribeAddressesResult result = ec2Service.describeAddresses(describeAddressRequest);
                if (result.getAddresses() == null || result.getAddresses().isEmpty()) continue;
                Address eipAddress = (Address)result.getAddresses().get(0);
                associatedInstanceId = eipAddress.getInstanceId();
                if (associatedInstanceId == null || associatedInstanceId.isEmpty()) {
                    if (selectedEIP != null) continue;
                    selectedEIP = eipAddress;
                    continue;
                }
                isMyinstanceAssociatedWithEIP = associatedInstanceId.equals(myInstanceId);
                if (isMyinstanceAssociatedWithEIP) {
                    selectedEIP = eipAddress;
                    break;
                }
                logger.warn("The selected EIP {} is associated with another instance {} according to AWS, hence skipping this", (Object)eipEntry, (Object)associatedInstanceId);
            }
            catch (Throwable t) {
                logger.error("Failed to bind elastic IP: " + eipEntry + " to " + myInstanceId, t);
            }
        }
        if (!isMyinstanceAssociatedWithEIP) {
            String publicIp = selectedEIP.getPublicIp();
            AssociateAddressRequest associateAddressRequest = new AssociateAddressRequest().withInstanceId(myInstanceId);
            String domain = selectedEIP.getDomain();
            if ("vpc".equals(domain)) {
                associateAddressRequest.setAllocationId(selectedEIP.getAllocationId());
            } else {
                associateAddressRequest.setPublicIp(publicIp);
            }
            ec2Service.associateAddress(associateAddressRequest);
            logger.info("\n\n\nAssociated " + myInstanceId + " running in zone: " + myZone + " to elastic IP: " + publicIp);
        }
        logger.info("My instance {} seems to be already associated with the EIP {}", (Object)myInstanceId, (Object)selectedEIP.getPublicIp());
    }

    public void unbindEIP() {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String myPublicIP = null;
        if (myInfo != null && myInfo.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon) {
            myPublicIP = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicIpv4);
            try {
                AmazonEC2 ec2Service = this.getEC2Service();
                DescribeAddressesRequest describeAddressRequest = new DescribeAddressesRequest().withPublicIps(new String[]{myPublicIP});
                DescribeAddressesResult result = ec2Service.describeAddresses(describeAddressRequest);
                if (result.getAddresses() != null && !result.getAddresses().isEmpty()) {
                    Address eipAddress = (Address)result.getAddresses().get(0);
                    DisassociateAddressRequest dissociateRequest = new DisassociateAddressRequest();
                    String domain = eipAddress.getDomain();
                    if ("vpc".equals(domain)) {
                        dissociateRequest.setAssociationId(eipAddress.getAssociationId());
                    } else {
                        dissociateRequest.setPublicIp(eipAddress.getPublicIp());
                    }
                    ec2Service.disassociateAddress(dissociateRequest);
                    logger.info("Dissociated the EIP {} from this instance", (Object)myPublicIP);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot dissociate address" + myPublicIP + "from this instance", e);
            }
        }
    }

    public Collection<String> getCandidateEIPs(String myInstanceId, String myZone) {
        Collection<String> eipCandidates;
        if (myZone == null) {
            myZone = "us-east-1d";
        }
        Collection<String> collection = eipCandidates = DiscoveryManager.getInstance().getEurekaClientConfig().shouldUseDnsForFetchingServiceUrls() ? this.getEIPsForZoneFromDNS(myZone) : this.getEIPsForZoneFromConfig(myZone);
        if (eipCandidates == null || eipCandidates.size() == 0) {
            throw new RuntimeException("Could not get any elastic ips from the EIP pool for zone :" + myZone);
        }
        return eipCandidates;
    }

    private Collection<String> getEIPsForZoneFromConfig(String myZone) {
        List ec2Urls = DiscoveryManager.getInstance().getEurekaClientConfig().getEurekaServerServiceUrls(myZone);
        return this.getEIPsFromServiceUrls(ec2Urls);
    }

    private Collection<String> getEIPsFromServiceUrls(List<String> ec2Urls) {
        ArrayList<String> returnedUrls = new ArrayList<String>();
        String region = DiscoveryManager.getInstance().getEurekaClientConfig().getRegion();
        String regionPhrase = "";
        if (!US_EAST_1.equals(region)) {
            regionPhrase = "." + region;
        }
        for (String cname : ec2Urls) {
            int beginIndex = cname.indexOf("ec2-") + 4;
            int endIndex = cname.indexOf(regionPhrase + ".compute");
            String eipStr = cname.substring(beginIndex, endIndex);
            String eip = eipStr.replaceAll("\\-", ".");
            returnedUrls.add(eip);
        }
        return returnedUrls;
    }

    private Collection<String> getEIPsForZoneFromDNS(String myZone) {
        List ec2Urls = DiscoveryManager.getInstance().getDiscoveryClient().getServiceUrlsFromDNS(myZone, true);
        return this.getEIPsFromServiceUrls(ec2Urls);
    }

    private AmazonEC2 getEC2Service() {
        this.eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
        String aWSAccessId = this.eurekaConfig.getAWSAccessId();
        String aWSSecretKey = this.eurekaConfig.getAWSSecretKey();
        AmazonEC2Client ec2Service = null != aWSAccessId && !"".equals(aWSAccessId) && null != aWSSecretKey && !"".equals(aWSSecretKey) ? new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(aWSAccessId, aWSSecretKey)) : new AmazonEC2Client((AWSCredentialsProvider)new InstanceProfileCredentialsProvider());
        String region = DiscoveryManager.getInstance().getEurekaClientConfig().getRegion();
        region = region.trim().toLowerCase();
        ec2Service.setEndpoint("ec2." + region + ".amazonaws.com");
        return ec2Service;
    }
}

