/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.util.EurekaMonitors;
import com.netflix.eureka.util.RateLimiter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RateLimitingFilter
implements Filter {
    private static final Set<String> DEFAULT_PRIVILEDGED_CLIENTS = new HashSet<String>(Arrays.asList("DefaultClient", "DefaultServer"));
    private static final RateLimiter rateLimiter = new RateLimiter();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && RateLimitingFilter.isRateLimited((HttpServletRequest)request)) {
            if (EurekaServerConfigurationManager.getInstance().getConfiguration().isRateLimiterEnabled()) {
                EurekaMonitors.RATE_LIMITED.increment();
                ((HttpServletResponse)response).setStatus(503);
            } else {
                EurekaMonitors.RATE_LIMITED_CANDIDATES.increment();
                chain.doFilter(request, response);
            }
            return;
        }
        chain.doFilter(request, response);
    }

    private static boolean isRateLimited(HttpServletRequest request) {
        return !RateLimitingFilter.isPrivilidged(request) && RateLimitingFilter.isOverloaded();
    }

    private static boolean isPrivilidged(HttpServletRequest request) {
        String clientName;
        Set<String> privilidgedClients = EurekaServerConfigurationManager.getInstance().getConfiguration().getRateLimiterPrivilidgedClients();
        return privilidgedClients.contains(clientName = request.getHeader("DiscoveryIdentity-Name")) || DEFAULT_PRIVILEDGED_CLIENTS.contains(clientName);
    }

    private static boolean isOverloaded() {
        int windowSize;
        int maxInWindow = EurekaServerConfigurationManager.getInstance().getConfiguration().getRateLimiterBurstSize();
        return !rateLimiter.acquire(maxInWindow, windowSize = EurekaServerConfigurationManager.getInstance().getConfiguration().getRateLimiterAverageRate());
    }

    public void destroy() {
    }

    static void reset() {
        rateLimiter.reset();
    }
}

