/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.Version;
import com.netflix.eureka.resources.ResponseCache;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVIPResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractVIPResource.class);

    AbstractVIPResource() {
    }

    protected Response getVipResponse(String version, String entityName, String acceptHeader, ResponseCache.Key.EntityType entityType) {
        if (!PeerAwareInstanceRegistry.getInstance().shouldAllowAccess(false)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        CurrentRequestVersion.set(Version.toEnum(version));
        ResponseCache.KeyType keyType = ResponseCache.KeyType.JSON;
        if (acceptHeader == null || !acceptHeader.contains("json")) {
            keyType = ResponseCache.KeyType.XML;
        }
        ResponseCache.Key cacheKey = new ResponseCache.Key(entityType, entityName, keyType, CurrentRequestVersion.get());
        String payLoad = ResponseCache.getInstance().get(cacheKey);
        if (payLoad != null) {
            logger.debug("Found: {}", (Object)entityName);
            return Response.ok((Object)payLoad).build();
        }
        logger.debug("Not Found: {}", (Object)entityName);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

