/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.resources.ApplicationResource;
import com.netflix.eureka.resources.InstanceResource;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{version}/peerreplication")
@Produces(value={"application/xml", "application/json"})
public class PeerReplicationResource {
    private static final String REPLICATION = "true";
    private static final Logger logger = LoggerFactory.getLogger(PeerReplicationResource.class);

    @Path(value="batch")
    @POST
    public Response batchReplication(PeerEurekaNode.ReplicationList replicationList) {
        Response response = null;
        try {
            PeerEurekaNode.ReplicationListResponse batchResponse = new PeerEurekaNode.ReplicationListResponse();
            for (PeerEurekaNode.ReplicationInstance instanceInfo : replicationList.getList()) {
                ApplicationResource applicationResource = new ApplicationResource(instanceInfo.getAppName());
                InstanceResource resource = new InstanceResource(applicationResource, instanceInfo.getId());
                String lastDirtyTimestamp = instanceInfo.getLastDirtyTimestamp() == null ? null : instanceInfo.getLastDirtyTimestamp().toString();
                String overriddenStatus = instanceInfo.getOverriddenStatus() == null ? null : instanceInfo.getOverriddenStatus();
                String instanceStatus = instanceInfo.getStatus() == null ? null : instanceInfo.getStatus();
                PeerEurekaNode.ReplicationInstanceResponse.Builder singleResponseBuilder = new PeerEurekaNode.ReplicationInstanceResponse.Builder();
                if (instanceInfo.getAction() == PeerAwareInstanceRegistry.Action.Heartbeat) {
                    response = resource.renewLease(REPLICATION, overriddenStatus, instanceStatus, lastDirtyTimestamp);
                    singleResponseBuilder.setStatusCode(response.getStatus());
                    if (response.getStatus() == Response.Status.OK.getStatusCode() && response.getEntity() != null) {
                        singleResponseBuilder.setResponseEntity((InstanceInfo)response.getEntity());
                    }
                } else if (instanceInfo.getAction() == PeerAwareInstanceRegistry.Action.Register) {
                    applicationResource.addInstance(instanceInfo.getInstanceInfo(), REPLICATION);
                    singleResponseBuilder = new PeerEurekaNode.ReplicationInstanceResponse.Builder().setStatusCode(Response.Status.OK.getStatusCode());
                } else if (instanceInfo.getAction() == PeerAwareInstanceRegistry.Action.StatusUpdate) {
                    response = resource.statusUpdate(instanceInfo.getStatus(), REPLICATION, instanceInfo.getLastDirtyTimestamp().toString());
                    singleResponseBuilder = new PeerEurekaNode.ReplicationInstanceResponse.Builder().setStatusCode(response.getStatus());
                } else if (instanceInfo.getAction() == PeerAwareInstanceRegistry.Action.DeleteStatusOverride) {
                    response = resource.deleteStatusUpdate(REPLICATION, instanceInfo.getStatus(), instanceInfo.getLastDirtyTimestamp().toString());
                    singleResponseBuilder = new PeerEurekaNode.ReplicationInstanceResponse.Builder().setStatusCode(response.getStatus());
                } else if (instanceInfo.getAction() == PeerAwareInstanceRegistry.Action.Cancel) {
                    response = resource.cancelLease(REPLICATION);
                    singleResponseBuilder = new PeerEurekaNode.ReplicationInstanceResponse.Builder().setStatusCode(response.getStatus());
                }
                batchResponse.addResponse(singleResponseBuilder.build());
            }
            return Response.ok((Object)batchResponse).build();
        }
        catch (Throwable e) {
            logger.error("Cannot execute batch Request", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

