/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.shared.EurekaJerseyClient;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.Version;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.logging.messaging.BatcherFactory;
import com.netflix.logging.messaging.MessageBatcher;
import com.netflix.logging.messaging.MessageProcessor;
import com.netflix.servo.monitor.DynamicCounter;
import com.netflix.servo.monitor.Monitors;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerEurekaNode {
    private static final Logger logger = LoggerFactory.getLogger(PeerEurekaNode.class);
    private static final int RETRY_SLEEP_TIME_MS = 100;
    public static final String HEADER_REPLICATION = "x-netflix-discovery-replication";
    private static final EurekaServerConfig config = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private final String serviceUrl;
    private final String name;
    private volatile EurekaJerseyClient.JerseyClient jerseyClient;
    private volatile ApacheHttpClient4 jerseyApacheClient;
    private MessageBatcher<ReplicationTask> heartBeatBatcher;
    private MessageBatcher<ReplicationTask> statusBatcher;
    private MessageBatcher<ReplicationTask> registerBatcher;
    private MessageBatcher<ReplicationTask> cancelBatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerEurekaNode(String serviceUrl) {
        this.serviceUrl = serviceUrl.intern();
        this.name = this.getClass().getSimpleName() + ": " + serviceUrl + "apps/: ";
        this.heartBeatBatcher = this.getBatcher(serviceUrl, PeerAwareInstanceRegistry.Action.Heartbeat);
        this.statusBatcher = this.getBatcher(serviceUrl, PeerAwareInstanceRegistry.Action.StatusUpdate);
        this.registerBatcher = this.getBatcher(serviceUrl, PeerAwareInstanceRegistry.Action.Register);
        this.cancelBatcher = this.getBatcher(serviceUrl, PeerAwareInstanceRegistry.Action.Cancel);
        String string = this.serviceUrl;
        synchronized (string) {
            if (this.jerseyApacheClient == null) {
                try {
                    this.jerseyClient = EurekaJerseyClient.createJerseyClient((int)config.getPeerNodeConnectTimeoutMs(), (int)config.getPeerNodeReadTimeoutMs(), (int)config.getPeerNodeTotalConnections(), (int)config.getPeerNodeTotalConnectionsPerHost(), (int)config.getPeerNodeConnectionIdleTimeoutSeconds());
                    this.jerseyApacheClient = this.jerseyClient.getClient();
                }
                catch (Throwable e) {
                    throw new RuntimeException("Cannot Create new Replica Node :" + this.name);
                }
            }
        }
        try {
            String serviceUrlHost = new URL(serviceUrl).getHost();
            Monitors.registerObject((String)serviceUrlHost, (Object)this);
        }
        catch (Throwable e) {
            logger.error("Cannot register monitors for Peer eureka node :" + serviceUrl, e);
        }
    }

    public void register(final InstanceInfo info) throws Exception {
        boolean success = this.registerBatcher.process((Object)new ReplicationTask(info.getAppName(), info.getId(), PeerAwareInstanceRegistry.Action.Register){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                CurrentRequestVersion.set(Version.V2);
                String urlPath = "apps/" + info.getAppName();
                ClientResponse response = null;
                try {
                    response = (ClientResponse)((WebResource.Builder)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)info);
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
        });
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public void cancel(final String appName, final String id) throws Exception {
        boolean success = this.cancelBatcher.process((Object)new ReplicationTask(appName, id, PeerAwareInstanceRegistry.Action.Cancel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                ClientResponse response = null;
                try {
                    String urlPath = "apps/" + appName + "/" + id;
                    response = (ClientResponse)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").delete(ClientResponse.class);
                    if (response.getStatus() == 404) {
                        logger.warn(PeerEurekaNode.this.name + appName + "/" + id + " : delete: missing entry.");
                    }
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
        });
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public void heartbeat(final String appName, final String id, final InstanceInfo info, final InstanceInfo.InstanceStatus overriddenStatus, boolean primeConnection) throws Throwable {
        if (primeConnection) {
            this.sendHeartBeat(appName, id, info, overriddenStatus);
            return;
        }
        boolean success = this.heartBeatBatcher.process((Object)new ReplicationTask(appName, id, PeerAwareInstanceRegistry.Action.Heartbeat){

            @Override
            public void execute() throws Throwable {
                PeerEurekaNode.this.sendHeartBeat(appName, id, info, overriddenStatus);
            }
        });
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public void statusUpdate(final String asgName, final ASGResource.ASGStatus newStatus) {
        boolean success = this.statusBatcher.process((Object)new ReplicationTask(asgName, asgName, PeerAwareInstanceRegistry.Action.StatusUpdate){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                ClientResponse response = null;
                try {
                    String urlPath = "asg/" + asgName + "/status";
                    response = (ClientResponse)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").put(ClientResponse.class);
                    if (response.getStatus() != 200) {
                        logger.error(PeerEurekaNode.this.name + asgName + " : statusUpdate:  failed!");
                    }
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
        });
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public void statusUpdate(final String appName, final String id, final InstanceInfo.InstanceStatus newStatus, final InstanceInfo info) {
        boolean success = this.statusBatcher.process((Object)new ReplicationTask(appName, id, PeerAwareInstanceRegistry.Action.StatusUpdate){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                CurrentRequestVersion.set(Version.V2);
                ClientResponse response = null;
                try {
                    String urlPath = "apps/" + appName + "/" + id + "/status";
                    response = (ClientResponse)PeerEurekaNode.this.jerseyApacheClient.resource(PeerEurekaNode.this.serviceUrl).path(urlPath).queryParam("value", newStatus.name()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString()).header(PeerEurekaNode.HEADER_REPLICATION, (Object)"true").put(ClientResponse.class);
                    if (response.getStatus() != 200) {
                        logger.error(PeerEurekaNode.this.name + appName + "/" + id + " : statusUpdate:  failed!");
                    }
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
        });
        if (!success) {
            logger.error("Cannot find space in the replication pool for " + this.serviceUrl + ". Check the network connectivity or the traffic");
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerEurekaNode other = (PeerEurekaNode)obj;
        return !(this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl));
    }

    public void destroyResources() {
        if (this.jerseyClient != null) {
            try {
                this.jerseyClient.destroyResources();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void shutDown() {
        if (this.heartBeatBatcher != null) {
            this.heartBeatBatcher.stop();
        }
        if (this.registerBatcher != null) {
            this.registerBatcher.stop();
        }
        if (this.cancelBatcher != null) {
            this.cancelBatcher.stop();
        }
        if (this.statusBatcher != null) {
            this.statusBatcher.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) throws Throwable {
        ClientResponse response = null;
        try {
            String urlPath = "apps/" + appName + "/" + id;
            WebResource r = this.jerseyApacheClient.resource(this.serviceUrl).path(urlPath).queryParam("status", info.getStatus().toString()).queryParam("lastDirtyTimestamp", info.getLastDirtyTimestamp().toString());
            if (overriddenStatus != null) {
                r = r.queryParam("overriddenstatus", overriddenStatus.name());
            }
            if ((response = (ClientResponse)r.header(HEADER_REPLICATION, (Object)"true").put(ClientResponse.class)).getStatus() == 404) {
                logger.warn(this.name + appName + "/" + id + " : heartbeat: missing entry.");
                if (info != null) {
                    logger.warn("Cannot find instance id {} and hence replicating the instance with status {}", (Object)info.getId(), (Object)info.getStatus().toString());
                    this.register(info);
                }
            } else if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                this.syncInstancesIfTimestampDiffers(id, info, response);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private boolean isNetworkConnectException(Throwable e) {
        while (e.getCause() != null) {
            if (IOException.class.isInstance(e.getCause())) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private void syncInstancesIfTimestampDiffers(String id, InstanceInfo info, ClientResponse response) {
        try {
            InstanceInfo infoFromPeer;
            if (config.shouldSyncWhenTimestampDiffers() && response.hasEntity() && (infoFromPeer = (InstanceInfo)response.getEntity(InstanceInfo.class)) != null) {
                Object[] args = new Object[]{id, info.getLastDirtyTimestamp(), infoFromPeer.getLastDirtyTimestamp()};
                logger.warn("Peer wants us to take the instance information from it, since the timestamp differs,Id : {} My Timestamp : {}, Peer's timestamp: {}", args);
                if (infoFromPeer.getOverriddenStatus() != null && !InstanceInfo.InstanceStatus.UNKNOWN.equals((Object)infoFromPeer.getOverriddenStatus())) {
                    Object[] args1 = new Object[]{id, info.getOverriddenStatus(), infoFromPeer.getOverriddenStatus()};
                    logger.warn("Overridden Status info -id {}, mine {}, peer's {}", args1);
                    PeerAwareInstanceRegistry.getInstance().storeOverriddenStatusIfRequired(id, infoFromPeer.getOverriddenStatus());
                }
                PeerAwareInstanceRegistry.getInstance().register(infoFromPeer, true);
            }
        }
        catch (Throwable e) {
            logger.warn("Exception when trying to get information from peer :", e);
        }
    }

    private MessageBatcher getBatcher(String serviceUrl, PeerAwareInstanceRegistry.Action action) {
        String batcherName = null;
        try {
            batcherName = new URL(serviceUrl).getHost();
        }
        catch (MalformedURLException e1) {
            batcherName = serviceUrl;
        }
        String absoluteBatcherName = batcherName + "-" + action.name();
        ConfigurationManager.getConfigInstance().setProperty("batcher." + absoluteBatcherName + ".queue.maxMessages", (Object)config.getMaxElementsInPeerReplicationPool());
        ConfigurationManager.getConfigInstance().setProperty("batcher." + absoluteBatcherName + ".keepAliveTime", (Object)(config.getMaxIdleThreadAgeInMinutesForPeerReplication() * 60L));
        ConfigurationManager.getConfigInstance().setProperty("batcher." + absoluteBatcherName + ".maxThreads", (Object)config.getMaxThreadsForPeerReplication());
        return BatcherFactory.createBatcher((String)absoluteBatcherName, (MessageProcessor)new MessageProcessor<ReplicationTask>(){

            public void process(List<ReplicationTask> tasks) {
                for (ReplicationTask task : tasks) {
                    boolean done = true;
                    do {
                        done = true;
                        try {
                            Object[] args = new Object[]{task.getAppName(), task.getId(), task.getAction(), new Date(System.currentTimeMillis()), new Date(task.getSubmitTime())};
                            if (System.currentTimeMillis() - (long)config.getMaxTimeForReplication() > task.getSubmitTime()) {
                                logger.warn("Replication events older than the threshold. AppName : {}, Id: {}, Action : {}, Current Time : {}, Submit Time :{}", args);
                                continue;
                            }
                            task.execute();
                        }
                        catch (Throwable e) {
                            logger.error(PeerEurekaNode.this.name + task.getAppName() + "/" + task.getId() + ":" + (Object)((Object)task.getAction()), e);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e1) {
                                // empty catch block
                            }
                            if (PeerEurekaNode.this.isNetworkConnectException(e)) {
                                DynamicCounter.increment((String)(task.getAction().name() + "_retries"), null);
                                done = false;
                                continue;
                            }
                            logger.info("Not re-trying this exception because it does not seem to be a network exception", e);
                        }
                    } while (!done);
                }
            }
        });
    }

    private abstract class ReplicationTask {
        private long submitTime = System.currentTimeMillis();
        private String appName;
        private String id;
        private PeerAwareInstanceRegistry.Action action;

        public String getAppName() {
            return this.appName;
        }

        public String getId() {
            return this.id;
        }

        public PeerAwareInstanceRegistry.Action getAction() {
            return this.action;
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public ReplicationTask(String appName, String id, PeerAwareInstanceRegistry.Action action) {
            this.appName = appName;
            this.id = id;
            this.action = action;
        }

        public abstract void execute() throws Throwable;
    }
}

