/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster.protocol;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;

public class ReplicationInstance {
    private String appName;
    private String id;
    private Long lastDirtyTimestamp;
    private String overriddenStatus;
    private String status;
    private InstanceInfo instanceInfo;
    private PeerAwareInstanceRegistryImpl.Action action;

    @JsonCreator
    public ReplicationInstance(@JsonProperty(value="appName") String appName, @JsonProperty(value="id") String id, @JsonProperty(value="lastDirtyTimestamp") Long lastDirtyTimestamp, @JsonProperty(value="overriddenStatus") String overriddenStatus, @JsonProperty(value="status") String status, @JsonProperty(value="instanceInfo") InstanceInfo instanceInfo, @JsonProperty(value="action") PeerAwareInstanceRegistryImpl.Action action) {
        this.appName = appName;
        this.id = id;
        this.lastDirtyTimestamp = lastDirtyTimestamp;
        this.overriddenStatus = overriddenStatus;
        this.status = status;
        this.instanceInfo = instanceInfo;
        this.action = action;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getId() {
        return this.id;
    }

    public Long getLastDirtyTimestamp() {
        return this.lastDirtyTimestamp;
    }

    public String getOverriddenStatus() {
        return this.overriddenStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public InstanceInfo getInstanceInfo() {
        return this.instanceInfo;
    }

    public PeerAwareInstanceRegistryImpl.Action getAction() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationInstance that = (ReplicationInstance)o;
        if (this.appName != null ? !this.appName.equals(that.appName) : that.appName != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.lastDirtyTimestamp != null ? !this.lastDirtyTimestamp.equals(that.lastDirtyTimestamp) : that.lastDirtyTimestamp != null) {
            return false;
        }
        if (this.overriddenStatus != null ? !this.overriddenStatus.equals(that.overriddenStatus) : that.overriddenStatus != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.instanceInfo != null ? !this.instanceInfo.equals((Object)that.instanceInfo) : that.instanceInfo != null) {
            return false;
        }
        return this.action == that.action;
    }

    public int hashCode() {
        int result = this.appName != null ? this.appName.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.lastDirtyTimestamp != null ? this.lastDirtyTimestamp.hashCode() : 0);
        result = 31 * result + (this.overriddenStatus != null ? this.overriddenStatus.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.instanceInfo != null ? this.instanceInfo.hashCode() : 0);
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        return result;
    }

    public static ReplicationInstanceBuilder replicationInstance() {
        return ReplicationInstanceBuilder.aReplicationInstance();
    }

    public static class ReplicationInstanceBuilder {
        private String appName;
        private String id;
        private Long lastDirtyTimestamp;
        private String overriddenStatus;
        private String status;
        private InstanceInfo instanceInfo;
        private PeerAwareInstanceRegistryImpl.Action action;

        private ReplicationInstanceBuilder() {
        }

        public static ReplicationInstanceBuilder aReplicationInstance() {
            return new ReplicationInstanceBuilder();
        }

        public ReplicationInstanceBuilder withAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public ReplicationInstanceBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ReplicationInstanceBuilder withLastDirtyTimestamp(Long lastDirtyTimestamp) {
            this.lastDirtyTimestamp = lastDirtyTimestamp;
            return this;
        }

        public ReplicationInstanceBuilder withOverriddenStatus(String overriddenStatus) {
            this.overriddenStatus = overriddenStatus;
            return this;
        }

        public ReplicationInstanceBuilder withStatus(String status) {
            this.status = status;
            return this;
        }

        public ReplicationInstanceBuilder withInstanceInfo(InstanceInfo instanceInfo) {
            this.instanceInfo = instanceInfo;
            return this;
        }

        public ReplicationInstanceBuilder withAction(PeerAwareInstanceRegistryImpl.Action action) {
            this.action = action;
            return this;
        }

        public ReplicationInstanceBuilder but() {
            return ReplicationInstanceBuilder.aReplicationInstance().withAppName(this.appName).withId(this.id).withLastDirtyTimestamp(this.lastDirtyTimestamp).withOverriddenStatus(this.overriddenStatus).withStatus(this.status).withInstanceInfo(this.instanceInfo).withAction(this.action);
        }

        public ReplicationInstance build() {
            return new ReplicationInstance(this.appName, this.id, this.lastDirtyTimestamp, this.overriddenStatus, this.status, this.instanceInfo, this.action);
        }
    }
}

