/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.AbstractInstanceRegistry;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.Version;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/xml", "application/json"})
@Path(value="/{version}/instances")
public class InstancesResource {
    private static final Logger logger = LoggerFactory.getLogger(InstancesResource.class);
    private final AbstractInstanceRegistry registry = PeerAwareInstanceRegistryImpl.getInstance();

    @GET
    @Path(value="{id}")
    public Response getById(@PathParam(value="version") String version, @PathParam(value="id") String id) {
        CurrentRequestVersion.set(Version.toEnum(version));
        List<InstanceInfo> list = this.registry.getInstancesById(id);
        if (list != null && list.size() > 0) {
            return Response.ok((Object)list.get(0)).build();
        }
        logger.info("Not Found: " + id);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

